{ entrdata.pas - Data entry routines

  Based on Jim Lemay's PULL full featured pull-down menus. (v 5.Xb, 03-04-89)
  Copyright (c) 1987-1989 James H. LeMay, All rights reserved.

  Modified for stand alone use by Gordon A. Feingold, System Dynamics.

  Version 1.0   06/03/89
}

{ TP5 directives }
{$ifdef Debug}
{$A-,B-,E-,F-,I-,N-,O-,V-}
{$else}
{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$endif}

UNIT EntrData;

INTERFACE

uses
  Crt,Qwik,Wutil,Wndw,Strs;

type
  WriteModeType = (ScrnRel, WndwRel); {[GAF]}
const
  {Set to ScrnRel for screen relative row & col use, WndwRel for wndw relative}
  DataWriteMode : WriteModeType = ScrnRel;

{ Former Inc: Data Vars...}
const
  MaxDataEntries   = 255;    {For new record format}
  DataStrSize      = 100;    { Max chars in data entry string }

var
  Key:             char;
  ExtKey:          boolean;
  AddrKbdIdle:     pointer;

const
  WaitForKbd:      boolean = true;

  { -- Function keys -- }
  F10Key  = #68;

  { -- Data Entry keys -- }
  NullKey  = #00;
  RetKey   = #13;   { ^M }
  BSKey    = #08;
  EscKey   = #27;   { ^[ }
  HomeKey  = #71;
  UpArrKey = #72;
  PgUpKey  = #73;
  LArrKey  = #75;
  RArrKey  = #77;
  EndKey   = #79;
  DnArrKey = #80;
  PgDnKey  = #81;
  InsKey   = #82;
  DelKey   = #83;
  CtrlLArrKey = #115;
  CtrlRArrKey = #116;
  CtrlEndKey  = #117;
  CtrlPgDnKey = #118;
  CtrlHomeKey = #119;
  CtrlPgUpKey = #132;
  TabKey      = #9;
  ShiftTabKey = #15;

type
  ProcPtrType  = Pointer;
  Toggle         = (Off, On, No, Yes);
  TypeOfDataType = (
    Bytes,Words,ShortInts,Integers,LongInts,Reals,UserNums,Chars,Strings);
  SetNames = (
    NoSet,UnsignedSet,SignedSet,RealSet,CharSet,HexSet,FileNameSet,PathSet,
    MaskSet);
  EntrySetArray  = array[UnsignedSet..MaskSet] of set of char;
  DataEntryRec =
    record
      VarAddr:                  pointer;
      TypeOfData:               TypeOfDataType;
      Row,Col,Field,MaxField:   byte;
      Decimals:                 shortint;
      SetName:                  SetNames;
      TranslateProc,
      CheckRangeProc:           ProcPtrType;
      JustifyOutput:            DirType;
      Oattr, Iattr,
      MsgLineNum, HelpWndwNum:  byte;
    end;

  DataEntries = array[1..MaxDataEntries] of DataEntryRec;
  DataEntriesPtr = ^DataEntries; {New type [GAF]}
  DEGroupRec = record            {Record for each group's data entries}
                 GroupPtr : DataEntriesPtr;
                 NumInGroup : word;
               end;
  DataStrType = string[DataStrSize];
  DataPadRec =
    record
      StoreMode,Valid,DataStored,NewData: boolean;
      FieldIndex,CursorOfs,Hattr: integer;
      ErrHandlerProc:   ProcPtrType; {Added [GAF]}
      RangeOK: boolean; {Added [GAF]}
      Flex:    byte;
      Justify: DirType;
      case TypeOfDataType of
        Bytes:        (Bdata:  byte);
        Words:        (Wdata:  word);
        ShortInts:    (SIdata: shortint);
        Integers:     (Idata:  integer);
        LongInts:     (Ldata:  longint);
        Reals:        (Rdata:  real);
        UserNums:     (UNdata: DataStrType);
        Chars:        (Cdata:  char);
        Strings:      (Sdata:  DataStrType);
    end;

const
  { -- Filter sets for valid data entry characters -- }
  EntrySet:  EntrySetArray = (
   { -- Reserved sets -- }
   { UnsignedSet: } ['0'..'9'],
   { SignedSet:   } ['0'..'9','-','+'],
   { RealSet:     } ['0'..'9','-','+','.','E','e'],
   { CharSet:     } [' '..'~'],
   { -- User customized sets -- }
   { HexSet:      } ['0'..'9','A'..'F','a'..'f'],
   { FileNameSet: }
     ['!','#'..')','-'..'.','0'..'9','@'..'Z','^'..'{','}'..'~'],
   { PathSet:     }
     ['!','#'..')','-'..'.','0'..':','@'..'Z','^'..'{','}'..'~','\'],
   { MaskSet:     }
     ['!','#'..'*','-'..'.','0'..':','?'..'Z','^'..'{','}'..'~','\']);

  SeqDoneKey : char = NullKey; {To be set by user in SetDataEntryDefaults}
var
  DEI:             word;        { Top data entry record index }
  TopEntry:        DataEntryRec;
  DataEntry:       DataEntriesPtr; {Now of type DatEntriesPtr}
  DataStr:         DataStrType;
  DataStrL:        byte absolute DataStr;  { length of DataStr }
  DataPad:         DataPadRec;
  AutoTab,
  AutoNumLock:     boolean;

{ End Former Inc: Data Vars}

  DataEntryOattr,          { Default Output attribute }
  DataEntryIattr : byte;   { Default Input  attribute }


procedure ReadKbd (VAR ExtKey: boolean; VAR Key: char);

function StrSL  (S: string; Field: byte): string;
function StrSR  (S: string; Field: byte): string;
function InRangeW (Low,Value,High: word): boolean;

procedure Enter             (DEGroup : DEGroupRec; RecNum: word);
procedure EnterSeq          (DEGroup : DEGroupRec; First,Last: word; VAR Start: word);
procedure DisplayFields     (DEGroup : DEGroupRec; First,Last: word);
procedure GetDataEntry      (DEGroup : DEGroupRec; Index: word);
procedure SaveDataEntry;
procedure AllocateDataEntries (var DEGroup : DEGroupRec; NumEntries : word);
procedure RemoveDataEntries   (var DEGroup : DEGroupRec);

IMPLEMENTATION

{$L strs.obj }
function StrSL; external;
function StrSR; external;

{$L inrangew.obj }
function InRangeW; external;

procedure CallKbdIdle;  { forward; }
inline ($FF/$1E/AddrKbdIdle); { call DWORD PTR [>AddrKbdIdle] }

procedure MonitorKbd;
begin
  repeat
    CallKbdIdle;
  until keypressed;
end;

procedure ReadKbd; { (VAR ExtKey: boolean; VAR Key: char); }
begin
  MonitorKbd;
  Key := ReadKey;                        { Read keyboard input.       }
  if KeyPressed and (Key=NullKey) then   { If first Char was Null ... }
    begin
      Key := ReadKey;                    { ... read second char.      }
      ExtKey := true
    end
  else ExtKey := false;
end;


{$I EntrData.inc }    { the data entry routines }

BEGIN {EntrData Initialization}
  {Set to nill in case it's not set in SetDataEntryDefaults}
  DataPad.ErrHandlerProc:=nil;
END.
