{$O+,F+} { Allow Overlays                   }
{$R-}    { No range checking                }
{$S-}    { No stack checking                }
{$I-}    { No I/O checking                  }
{$V-}    { No string checking               }
{$B-}    { Boolean short circuit evaluation }
{$N-}    { No numeric coprocessor           }
{$D-}    { No debug information             }
{$M 1024, 0, 4096}

(*Ŀ
   AstroSoft Data Systems LIM EMS 3.2 Unit demo program.                     
   This program shows you how to use the ASEMS unit to dynamically allocate a
   structure larger than the 64K page frame.  The program allocates 8 16K    
   pages of EMS memory 3.2 or above and then initializes an array of 80      
   character strings 1618 long writes them to the screen and then releases   
   the associated handle.  It is quite easy to allocate and use EMS memory   
   with this unit if the allocated structures have a constant record size.   
   It would be quite some work to get the structures to switch with variable 
   length records.  It is important to release the handles in your program   
   under terminations other than normal ones.  If handles are left in        
   memory they should not hazard the system, it is just sloppy practice.     
  *)

(* Direct questions or comments to AstroSoft Data Systems PO Box 12295, *)
(*                                 Baltimore, Maryland 21224            *)
(*                                 301-276-6569                         *)

PROGRAM Test1;                  { Program Name }

USES CRT, ASEMS;                { Need to put ASEMS in USES clause }

TYPE
Str55     =   STRING [ 55 ];    { Program types }
Str3      =   STRING [ 03 ];
Str4      =   STRING [ 04 ];
Str8      =   STRING [ 08 ];
Str80     =   STRING [ 80 ];
Str80Ptr  =   ^Str80;

VAR

Handle,                         { LIM EMS handle }
Address,                        { Base address of EMS physical page frame }
I, J        : WORD;             { Loop counter variables }
Error       : Str55;            { Error string passed to the program }
Version     : Str3;             { EMS version string }
Ch          : CHAR;             { stop key character }
BasePtr     : POINTER;          { Pointer to base of array within page frame }
TestArray   : ARRAY [ 1..809 ] OF Str80Ptr;  { array of string pointers }
NumString   : Str4;             { Used for number string }
Number      : WORD;             { Word variable used to pass number of handles }


{$F+} PROCEDURE CustomExit; {$F-}
BEGIN
  IF NOT ReleaseHandle ( Handle, Error ) THEN
  WRITELN ( 'Handles not released : ', Error );
END;

BEGIN

ExitProc       := @CustomExit;   { Release handles during terminations other }
CHECKBREAK     := TRUE;         { than normal. ie Interrupt 20h             }
TEXTBACKGROUND ( BLUE );
TEXTCOLOR      ( LIGHTCYAN );
CLRSCR;

IF NOT MapAndTestPages ( 8, 0, 1, 2, 3, Handle, Address, Error ) THEN

WRITELN  ( Error )         { If not successful then write cause of error }
ELSE
BEGIN                      { If successful then fill the array of pointers }
                           { with addresses starting at the base of the    }
                           { page frame                                    }

IF HandleCount ( Number, Error ) THEN   { Get the number of handles in use }
WRITELN  ( 'Number of handles in use: ', Number ) { Write the number      }
ELSE
WRITELN  ( Error );    { If unsuccessful then write the cause of the error }
WRITELN;
IF HandlePages ( Handle, Number, Error ) THEN  { Get the number of handles }
                                               { currently used by application }
WRITELN ( 'Number of pages in use for present handle : ', Number )
ELSE
WRITELN ( Error );                  { If unsuccessful the write the cause }
WRITELN;

{ Write the address of the base of the physical page frame }

WRITELN  ( 'EMM Base Page Frame Address: ', HexString ( Address ) );
IF ( EMMVersion ( Version ) = 0 ) THEN

{ Write the EMM version }

WRITELN  ( 'EMM Driver Version         : ', Version   );
WRITELN;
IF GetMappingSize ( Number, Error ) THEN
WRITE ( 'Number of bytes to save mapping array: ', Number );
WRITELN;
WRITELN;
WRITELN  ( 'Mapping and Allocation completed without error' );
WRITELN;
WRITELN  ( 'Strike any key to read strings to (2) 64 Kb page maps ...' );
Ch := READKEY;                       { Wait for a key stroke }

FOR I := 1 TO 809 DO
TestArray [ I ] :=  PTR ( Address , ( I * 81 ) - 81 );


FOR I := 1 TO 809 DO        { Fill the array in the first page map }
BEGIN
STR ( I, NumString );
TestArray [ I ]^ := 'Testing Array Position #' + Numstring;
END;

WRITELN;
WRITELN  ( 'Strike any key to read strings from EMS to the screen ...' );
Ch := READKEY;

FOR I := 1 TO 809 DO             { Write the array to the screen }
WRITELN ( TestArray [ I ]^ );
WRITELN;
WRITELN ( 'Remapping to second page frame : Strike any key ...' );
Ch := Readkey;
{ Remap to the second four pages allocated }
IF NOT Remap ( 4, 5, 6, 7, Handle, Error ) THEN
WRITELN ( Error )
ELSE
  BEGIN
  FOR I := 1 TO 809 DO       { Store and write the second page mapped array }
  BEGIN
  STR ( I + 809, NumString );
  TestArray [ I ]^ := 'Testing Array Position #' + Numstring;
  END;
  FOR I := 1 TO 809 DO
  BEGIN
  WRITELN ( TestArray [ I ]^ );
  END;
  END;
END;
WRITELN;
WRITELN ( 'Restoring to first page frame : Strike any key ...' );
Ch := Readkey;
{ Restore to the first page map }
IF NOT Remap ( 0, 1, 2, 3, Handle, Error ) THEN
WRITELN ( Error );

{ Write out values from the first half of the 128K array }
FOR I := 1 TO 809 DO WRITELN ( TestArray [ I ]^ );
WRITELN;

WRITELN ( 'Strike any key to deallocate the EMS handle ...' );
Ch := Readkey;
{ Release the handle in use for other applications }
IF NOT ReleaseHandle ( Handle, Error ) THEN WRITELN ( Error );
CLRSCR;

END.
