Program DTest;

{$IFDEF WINDOWS}
Uses Drives, WinCRT, Strings;
{$ELSE}
Uses Drives, Strings;
{$ENDIF}

Type
	TypesArray = Array [TDriveTypes] Of String[ 8 ];
Const
	TypeNames: TypesArray =
	  ( 'FLOPPY', 'HARDDISK','REMAPPED','REMOTE','CD_ROM',
      'RAMDISK','INVALID' );
Var
	n: TDriveNums;
	Map: TDriveMap;
	first: Boolean;
	f: TDriveTypes;

Procedure WriteInfo( Const di: TDriveInfo );
	Begin
		If ([ INVALID, CD_ROM, FLOPPY ] * di.Flags ) = [] Then Begin
		  Write( '  ' );
			If not(REMOTE In di.Flags) Then Begin
			  WriteLn( 'Volumen Name: ', StrPas(@di.Info.VolName),
			           ', Serial-No.: ', di.Info.SerialNo,
			           ', FAT-TYpe: ', StrPas(@di.Info.FATType) );
			End { If }
			Else
			  WriteLn( 'Netshare: ', StrPas(@di.DevName));
		End; { If }
	End; { WriteInfo }

Begin
{$IFDEF WINDOWS}
  ScreenSize.Y := 80;
{$ENDIF}

  BuildDriveMap( Map );
	For n := Min_DriveNums To Max_DriveNums Do Begin
	  first := True;
		Write( 'Drive ',Chr( n+Ord( '@' ) ),': [' );
		For f := Low( TDriveTypes ) To High( TDriveTypes )  Do Begin
		  If f in Map[ n ].Flags Then Begin
			  If first Then 
				  first := false
				Else
				  Write( ', ' );
				Write( TypeNames[ f ] );
		  End; { If }
		End; { For }
		WriteLn(']');
		WriteInfo( Map[ n ] );
	End; { For }
	
End.
