program DlgStr;

uses WinTypes, WinProcs, OWindows, ODialogs, Strings;
{$R DlgStr}

const
  cm_NewDialog = 205;
  id_Static = 201;
  id_SecondDialog = 202;
  id_Edit = 125;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

type
  PInputDialog = ^TInputDialog;
  TInputDialog = Object(TDialog)
      MyData: array[0..100] of Char;
    constructor Init(A: PWindowsObject; Name: PChar; Info: PChar);
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    procedure SetUpWindow; virtual;
    function GetClassName: PChar; virtual;
    procedure idSecondDialog(var Msg: TMessage);
      virtual id_First + id_SecondDialog;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
     Ed: PEdit;
    constructor Init(A: PWindowsObject; Name: PChar);
    procedure NewDialog(var Msg: TMessage);
      virtual cm_First + cm_NewDialog;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}
constructor TInputDialog.Init(A: PWindowsObject; Name: PChar; Info: PChar);
begin
  TDialog.Init(A, Name);
  StrCopy(MyData, Info);
end;

procedure TInputDialog.SetUpWindow;
var
  DlgWindow: HWnd;
begin
  TDialog.SetUpWindow;
  SetClassWord(HWindow, GCW_HICON, LoadIcon(HInstance, 'ICON_1'));
  DlgWindow := GetDlgItem(HWindow, id_Static);
  SetWindowText(DlgWindow, MyData);
end;

procedure TInputDialog.GetWindowClass(var WndClass: TWndClass);
begin
  TDialog.GetWindowClass(WndClass);
end;

function TInputDialog.GetClassName: PChar;
begin
  GetClassName := 'InputDialog';
end;

procedure TInputDialog.idSecondDialog(var Msg: TMessage);
var
  D: PDialog;
begin
  D := New(PDialog, Init(@Self, 'Dialog_2'));
  Application^.ExecDialog(D);
end;

constructor TMyWindow.Init(A: PWindowsObject; Name: PChar);
begin
  TWindow.Init(A, Name);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
  Ed := New(PEdit, Init(@Self, id_Edit, 'Type anything here',  10, 10, 300, 30, 100, False));
end;

procedure TMyWindow.NewDialog(var Msg: TMessage);
var
  D: PInputDialog;
  S: array[0..100] of Char;
begin
  GetWindowText(Ed^.HWindow, S, 100);
  D := New(PInputDialog, Init(@Self, 'Dialog_1', S));
  Application^.ExecDialog(D);
end;



{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
