program DlgDir;

uses
  Win31,
  Strings, WinTypes,
  WinProcs, OWindows,
  ODialogs, Objects;

{$R DLGLIST}
const
  WM_STARTDLG  = WM_USER + 2;
  id_ListBox = 101;

type
  PMyDialog = ^TMyDialog;
  TMyDialog = Object(TDialog)
      Foo: PListBox;
    constructor Init(P: PWindowsObject; N: PChar);
    procedure SetUpWindow; virtual;
    procedure ListClick(var Msg: TMessage);
      virtual id_First + id_ListBox;
  end;

  PStepWindow = ^TStepWIndow;
  TStepWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure SetUpWindow; virtual;
    procedure WMStartDlg(var Msg: TMessage);
      virtual wm_First + wm_StartDlg;
  end;

  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

constructor TMyDialog.Init(P: PWindowsObject; N: PChar);
begin
  inherited Init(P, N);
  Foo := New(PListBox, InitResource(@Self, Id_ListBox));
end;

procedure TMyDialog.SetUpWindow;
begin
  inherited SetUpWindow;
  DlgDirList(HWindow, 'C:\', ID_ListBox, 0, DDL_DIRECTORY or DDL_EXCLUSIVE );
end;

procedure TMyDialog.ListClick(var Msg: TMessage);
var
  AMsg: TMessage;
begin
  if Msg.LParamHi = lbn_DblClk then Ok(AMsg);
end;

constructor TStepWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  inherited Init(AParent, ATitle);
end;

procedure TStepWindow.SetUpWindow;
begin
  inherited SetUpWindow;
  PostMessage(HWindow, WM_STARTDLG, 0, 0);
{  DlgDirList( }
end;

procedure TStepWindow.WMStartDlg(var Msg: TMessage);
var
  D: PDialog;
begin
  D := New(PMyDialog, Init(@Self, 'DIALOG_1'));
  Application^.ExecDialog(D);
end;

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PStepWindow, Init(nil, 'Steps'));
end;

var
  MyApp: TMyApplication;

begin
  MyApp.Init('Steps');
  MyApp.Run;
  MyApp.Done;
end.