{===========================================================================}
{                                                                           }
{ Rectangl extends the standard TRect object with routines to make it       }
{ easier to create buttons, calendars, etc.                                 }
{                                                                           }
{===========================================================================}

                            { Optimize compiler. }

                       {$A+,B-,D-,F+,I-,L-,O+,R-,S-,V-}

Unit Rectangl;

Interface

Uses

 App,
 Views,
 Objects,
 Dialogs;

Const

 { Define button constants. }

 bcWidth:   Byte = 10;   { Button width.                      }
 bcNumber:  Byte =  3;   { How many buttons are in the group. }
 bcSpread:  Byte =  2;   { Buttons are bcSpread spaces apart. }


Type

 TRectangle = Object(TRect)
               Procedure Expand(AX,AY:  Integer);
               Procedure GotoX(AX:  Byte);
               Procedure GotoY(AY:  Byte);
               Procedure GotoXY(AX,AY:  Byte);
               Procedure Center_In_View(AView:  PView);
               Procedure Set_Button_Width(AWidth:  Byte);
               Procedure Set_Button_Number(ANumber:  Byte);
               Procedure Set_Button_Spread(ASpread:  Byte);
               Procedure Restore_Button_Defaults;
               Procedure Button;
               Procedure Standard_Button;
               Procedure Center_Buttons(AWidth,AY:  Byte);
               Procedure Move_Button_Right;
               Procedure Move_Button_Down;
               Procedure Calendar;
              end;

Var

 Box:  TRectangle;  { Provide a standard global box. }

Procedure Set_Center_Option(AView:  PView);
Function  Yes(AQuestion:  String; AHelpCtx:  Word):  Word;
Function  No(AQuestion:  String; AHelpCtx:  Word):  Word;
Function  Warning_Dialog(AWarning:  String; AHelpCtx:  Word):  Word;
Function  Error_Dialog(AError:  String; AHelpCtx:  Word):  Word;

Implementation

Var

 LocalBox:  TRectangle;  { Provide a local box. }

{===========================================================================}
{                                                                           }
{ Set_Center_Option centers the argument view in its owner view by setting  }
{ the ofCentered option flag.                                               }
{                                                                           }
{===========================================================================}

Procedure Set_Center_Option(AView:  PView);

Begin
 AView^.Options := AView^.Options OR ofCentered;
end;

{===========================================================================}
{                                                                           }
{ Function Yes asks a Yes/No question where the default answer is Yes.      }
{ Yes allows the user to pass a help context.                               }
{                                                                           }
{===========================================================================}

Function  Yes(AQuestion:  String; AHelpCtx:  Word):  Word;

Var

 Question_Dialog:  PDialog;
 No_Button,
 Yes_Button,
 Help_Button,
 Cancel_Button:    PButton;

Begin
 If (Length(AQuestion) < 46) then LocalBox.Assign(0,0,52,7)
                             else LocalBox.Assign(0,0,Length(AQuestion) + 6,7);
 Question_Dialog := New(PDialog,Init(LocalBox,'Yes/No Inquiry'));
 With Question_Dialog^ do Begin
  Options := Options OR ofCentered;
  HelpCtx := AHelpCtx;
  LocalBox.Assign(0,0,Size.X - 2,1);
  LocalBox.GotoXY(1,2);
  Insert(New(PStaticText,Init(LocalBox,^C + AQuestion)));
  If (HelpCtx > hcNoContext)
   then begin
    LocalBox.Set_Button_Number(4);
    LocalBox.Button;
   end
   else LocalBox.Standard_Button;
  LocalBox.Center_Buttons(Size.X,Size.Y - 3);
  Yes_Button := New(PButton,Init(LocalBox,'~Y~es',cmYes,bfDefault));
  LocalBox.Move_Button_Right;
  No_Button := New(PButton,Init(LocalBox,'~N~o',cmNo,bfNormal));
  If (HelpCtx > hcNoContext) then begin
   LocalBox.Move_Button_Right;
   Help_Button := New(PButton,Init(LocalBox,'~H~elp',cmHelp,bfNormal));
  end;
  LocalBox.Move_Button_Right;
  Cancel_Button := New(PButton,Init(LocalBox,'Cancel',cmCancel,bfNormal));
  Insert(Yes_Button);
  Insert(No_Button);
  If (HelpCtx > hcNoContext) then Insert(Help_Button);
  Insert(Cancel_Button);
  Yes_Button^.Select;
 end;
 Yes := DeskTop^.ExecView(Question_Dialog);
end;

{===========================================================================}
{                                                                           }
{ Function No asks a Yes/No question where the default answer is No.  No    }
{ allows the user to pass a help context.                                   }
{                                                                           }
{===========================================================================}

Function  No(AQuestion:  String; AHelpCtx:  Word):  Word;

Var

 Question_Dialog:  PDialog;
 No_Button,
 Yes_Button,
 Help_Button,
 Cancel_Button:    PButton;

Begin
 If (Length(AQuestion) < 46) then LocalBox.Assign(0,0,52,7)
                             else LocalBox.Assign(0,0,Length(AQuestion) + 6,7);
 Question_Dialog := New(PDialog,Init(LocalBox,'No/Yes Inquiry'));
 With Question_Dialog^ do Begin
  Options := Options OR ofCentered;
  HelpCtx := AHelpCtx;
  LocalBox.Assign(0,0,Size.X - 2,1);
  LocalBox.GotoXY(1,2);
  Insert(New(PStaticText,Init(LocalBox,^C + AQuestion)));
  If (HelpCtx > hcNoContext)
   then begin
    LocalBox.Set_Button_Number(4);
    LocalBox.Button;
  If (HelpCtx > hcNoContext)
   then begin
    LocalBox.Set_Button_Number(4);
    LocalBox.Button;
   end
   else LocalBox.Standard_Button;
   end
   else LocalBox.Standard_Button;
  LocalBox.Center_Buttons(Size.X,Size.Y - 3);
  No_Button := New(PButton,Init(LocalBox,'~N~o',cmNo,bfDefault));
  LocalBox.Move_Button_Right;
  Yes_Button := New(PButton,Init(LocalBox,'~Y~es',cmYes,bfNormal));
  If (HelpCtx > hcNoContext) then begin
   LocalBox.Move_Button_Right;
   Help_Button := New(PButton,Init(LocalBox,'~H~elp',cmHelp,bfNormal));
  end;
  LocalBox.Move_Button_Right;
  Cancel_Button := New(PButton,Init(LocalBox,'Cancel',cmCancel,bfNormal));
  Insert(No_Button);
  Insert(Yes_Button);
  If (HelpCtx > hcNoContext) then Insert(Help_Button);
  Insert(Cancel_Button);
  No_Button^.Select;
 end;
 No := DeskTop^.ExecView(Question_Dialog);
end;

{===========================================================================}
{                                                                           }
{ Function Warning_Dialog invokes a dialog box with a warning message.      }
{ Warning allows the user to pass a help context.                           }
{                                                                           }
{===========================================================================}

Function  Warning_Dialog(AWarning:  String; AHelpCtx:  Word):  Word;

Var

 Dialog:  PDialog;
 Ok_Button,
 Help_Button,
 Cancel_Button:    PButton;

Begin
 If (Length(AWarning) < 34) then LocalBox.Assign(0,0,40,7)
                            else LocalBox.Assign(0,0,Length(AWarning) + 6,7);
 Dialog := New(PDialog,Init(LocalBox,'Warning'));
 With Dialog^ do Begin
  Options := Options OR ofCentered;
  HelpCtx := AHelpCtx;
  LocalBox.Assign(0,0,Size.X - 2,1);
  LocalBox.GotoXY(1,2);
  Insert(New(PStaticText,Init(LocalBox,^C + AWarning)));
  If (HelpCtx > hcNoContext)
   then LocalBox.Standard_Button
   else begin
    LocalBox.Set_Button_Number(2);
    LocalBox.Button;
   end;
  LocalBox.Center_Buttons(Size.X,Size.Y - 3);
  Ok_Button := New(PButton,Init(LocalBox,'~O~k',cmOk,bfDefault));
  If (HelpCtx > hcNoContext) then begin
   LocalBox.Move_Button_Right;
   Help_Button := New(PButton,Init(LocalBox,'~H~elp',cmHelp,bfNormal));
  end;
  LocalBox.Move_Button_Right;
  Cancel_Button := New(PButton,Init(LocalBox,'Cancel',cmCancel,bfNormal));
  Insert(Ok_Button);
  If (HelpCtx > hcNoContext) then Insert(Help_Button);
  Insert(Cancel_Button);
  Ok_Button^.Select;
 end;
 Warning_Dialog := DeskTop^.ExecView(Dialog);
end;

{===========================================================================}
{                                                                           }
{ Function Error_Dialog invokes a dialog box with a warning message.  Error }
{ allows the user to pass a help context.                                   }
{                                                                           }
{===========================================================================}

Function  Error_Dialog(AError:  String; AHelpCtx:  Word):  Word;

Var

 Dialog:  PDialog;
 Ok_Button,
 Help_Button,
 Cancel_Button:    PButton;

Begin
 If (Length(AError) < 34) then LocalBox.Assign(0,0,40,7)
                          else LocalBox.Assign(0,0,Length(AError) + 6,7);
 Dialog := New(PDialog,Init(LocalBox,'Error'));
 With Dialog^ do Begin
  Options := Options OR ofCentered;
  HelpCtx := AHelpCtx;
  LocalBox.Assign(0,0,Size.X - 2,1);
  LocalBox.GotoXY(1,2);
  Insert(New(PStaticText,Init(LocalBox,^C + AError)));
  If (HelpCtx > hcNoContext)
   then LocalBox.Standard_Button
   else begin
    LocalBox.Set_Button_Number(2);
    LocalBox.Button;
   end;
  LocalBox.Center_Buttons(Size.X,Size.Y - 3);
  Ok_Button := New(PButton,Init(LocalBox,'~O~k',cmOk,bfDefault));
  If (HelpCtx > hcNoContext) then begin
   LocalBox.Move_Button_Right;
   Help_Button := New(PButton,Init(LocalBox,'~H~elp',cmHelp,bfNormal));
  end;
  LocalBox.Move_Button_Right;
  Cancel_Button := New(PButton,Init(LocalBox,'Cancel',cmCancel,bfNormal));
  Insert(Ok_Button);
  If (HelpCtx > hcNoContext) then Insert(Help_Button);
  Insert(Cancel_Button);
  Ok_Button^.Select;
 end;
 Error_Dialog := DeskTop^.ExecView(Dialog);
end;

{===========================================================================}
{                                                                           }
{ Define methods for TRectangle.                                            }
{                                                                           }
{===========================================================================}

{===========================================================================}
{                                                                           }
{ Expand expands a TRectangle rectangle by a specified amount without dis-  }
{ turbing the location of its upper-right corner.                           }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Expand(AX,AY:  Integer);

Begin
 B.X := B.X + AX;
 B.Y := B.Y + AY;
end;

{===========================================================================}
{                                                                           }
{ GotoX moves the upper-right corner of a TRectangle rectangle to a given X }
{ location without disturbing its dimensions.                               }
{                                                                           }
{===========================================================================}

Procedure TRectangle.GoToX(AX:  Byte);

Begin
 Move(AX - A.X,0);
end;

{===========================================================================}
{                                                                           }
{ GotoY moves the upper-right corner of a TRectangle rectangle to a given Y }
{ location without disturbing its dimensions.                               }
{                                                                           }
{===========================================================================}

Procedure TRectangle.GoToY(AY:  Byte);

Begin
 Move(0,AY - A.Y);
end;

{===========================================================================}
{                                                                           }
{ GotoXY moves the upper-right corner of a TRectangle rectangle to a given  }
{ XY location without disturbing its dimensions.                            }
{                                                                           }
{===========================================================================}

Procedure TRectangle.GotoXY(AX,AY:  Byte);

Begin
 Move(AX - A.X,AY - A.Y);
end;

{===========================================================================}
{                                                                           }
{ Center_In_View centers the TRectangle in the argument view.               }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Center_In_View(AView:  PView);

Begin
 TRect.Move((AView^.Size.X - B.X) DIV 2,(AView^.Size.Y - B.Y) DIV 2);
end;

{===========================================================================}
{                                                                           }
{ Set_Button_Width sets the bcWidth constant to the argument value.         }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Set_Button_Width(AWidth:  Byte);

Begin
 bcWidth := AWidth;
end;

{===========================================================================}
{                                                                           }
{ Set_Button_Number sets the bcNumber constant to the argument value.       }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Set_Button_Number(ANumber:  Byte);

Begin
 bcNumber := ANumber;
end;

{===========================================================================}
{                                                                           }
{ Set_Button_Spread sets the bcSpread constant to the argument value.       }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Set_Button_Spread(ASpread:  Byte);

Begin
 bcSpread := ASpread;
end;

{===========================================================================}
{                                                                           }
{ Restore_Button_Defaults restores the button constants to their defaults.  }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Restore_Button_Defaults;

Begin
 bcWidth  := 10;
 bcNumber :=  3;
 bcSpread :=  2;
end;

{===========================================================================}
{                                                                           }
{ Button sets the TRectangle to button dimensions.                          }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Button;

Begin
 TRect.Assign(0,0,bcWidth,2);
end;

{===========================================================================}
{                                                                           }
{ Standard_Button sets the TRectangle to "Standard" button dimensions.      }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Standard_Button;

Begin
 Restore_Button_Defaults;
 Button;
end;

{===========================================================================}
{                                                                           }
{ Center_Buttons moves the TRectangle to the Y location specified and to    }
{ the appropriate X location so that the group of buttons will be centered  }
{ in the owner dialog box.  AWidth is the width of the owner dialog box,    }
{ i.e., Size.X and AY is the Y location.                                    }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Center_Buttons(AWidth,AY:  Byte);

Begin
 GotoXY((AWidth DIV 2) - (((bcWidth + bcSpread) * bcNumber) DIV 2) + 1,AY);
end;

{===========================================================================}
{                                                                           }
{ Move_Button_Right moves the TRectangle to the next button location to     }
{ the right.                                                                }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Move_Button_Right;

Begin
 Move(bcWidth + bcSpread,0);
end;

{===========================================================================}
{                                                                           }
{ Move_Button_Down moves the TRectangle to the next button location below   }
{ the current location.                                                     }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Move_Button_Down;

Begin
 Move(0,2);
end;

{===========================================================================}
{                                                                           }
{ Calendar sets the TRectangle to the standard size of a calendar.          }
{                                                                           }
{===========================================================================}

Procedure TRectangle.Calendar;

Begin
 TRect.Assign(0,0,26,10);
end;

end.