{ NOTE: This module may cause problems running in protected mode.
  Call DW Consulting, 503-884-7166 to get the portected mode version.
  Ask for David Willis }

unit Serial;

interface

{$I SERIAL.INC}         { Bring in SERIAL.INC, the equivalent of serial.h }

type

  ModeStr = String[3];

const
  VERSION = $0101;

  NOERROR  =       0;           { No error               }
  BUFOVFL  =       1;           { Buffer overflowed      }

  ESC      =       $1B;         { ASCII Escape character }
  ASCII    =       $007F;       { Mask ASCII characters  }

  SError          = NOERROR;

var

OldComVec: Pointer;


{function  Calcrc( char *, int );}
procedure i_enable(Base: Word; IRQMASK: Byte);
procedure i_disable(Base: Word; IRQMASK: Byte);


type

     PComPort = ^TComPort;
     TComPort = object
       ComPort: Byte;             { COM1 or COM2 }
       PortBase:      Word;       { Base Address of the Port; 0x3F8 for COM1 }
       IRQInt:        Byte;
       IRQ:           Byte;

       BaudRate:      Word;
       NBits:         Byte;
       NStopBits:     Byte;
       Parity:        Byte;
       ComIsOn:       Boolean;    { tells if on or off }
       ComIsInit:     Boolean;    { to keep calls to read etc, from
                                    screwing up system when not init }

       OldComVec: Pointer;
       constructor Init(NewPort: Byte; NewBaud: Word;
                        NewMode: ModeStr; NewBase: Word; NewIRQ: Byte);

       function SetPort(NewPort: Byte):  Boolean;
       function SetBaud(NewBaud: Word):  Boolean;
       function SetMode(NewMode: ModeStr):  Boolean;
       function GetMode(var Mode: ModeStr):  ModeStr;

       function Com_On: Boolean;
       function Com_Off: Boolean;

       function PutC(ch: char): integer;
       function WriteBuf(const CBuf; Count: Word): integer;
       function WriteStr(CStr: string): integer;
       function GetC(var ch: char): integer;
       function ReadBuf(var CBuf; Count: Word): integer;
       function ReadStr(var CStr: string): integer;
       function BufCount: integer;

       procedure Flush;
       destructor Done; virtual;

     end; {TComPort}


implementation

uses DOS, Strings, CRT;

const

BUFSIZE  =       $4000;       { Serial buffer size     }

var
Cportbase: word;
startbuf: integer;
endbuf: integer;
ComBuf: Array[0..BUFSIZE-1] of Byte;



procedure Com_Int; interrupt;
begin
  asm
    CLI
  end;

  if ( (Port[Cportbase + IIR] AND RX_MASK) = RX_ID) then
    begin
      ComBuf[endbuf] := Port[Cportbase+RXR];
      Inc(endbuf);
      endbuf := endbuf AND (BUFSIZE-1);
{      if (endbuf = startbuf) then }
    end;

  Port[ICR] := EOI;
  asm
    STI
  end;

end;


procedure i_disable(Base: Word; IRQMASK: Byte); {Disable the port specified}
var
  b: byte;
begin
  asm
    CLI
  end;

  b := Port[IMR] OR (NOT IRQMASK);
  Port[IMR] := b;
  Port[Base+IER] := 0;

{  c := Port[Base+MCR];
  c := Port[Base+MCR] AND (NOT MC_INT); }
  Port[Base+MCR] := Port[Base+MCR] AND (NOT MC_INT);

  asm
    STI
  end;
end;

procedure i_enable(Base: Word; IRQMASK: Byte); {Enable the port specified}
var
c: Byte;

begin
  asm
    CLI
  end;

  c := Port[Base+MCR] OR MC_INT;
{  Port[Base+MCR] := Port[Base+MCR] OR MC_INT; }
  Port[Base+MCR] := c;
  Port[Base+IER] := RX_INT;

  c := Port[IMR] AND IRQMASK;
  Port[IMR] := c;

  asm
    STI
  end;
end;

constructor TComPort.Init(NewPort: byte; NewBaud: Word;
                          NewMode: ModeStr; NewBase: Word; NewIRQ: Byte);
begin
   startbuf := 0;
   endbuf := 0;

   if (NOT SetPort(NewPort)) then
     exit;
   if (NewBase <> 0) then               { I still need to set base1, base2 }
     PortBase := NewBase;

   if (NOT SetBaud(NewBaud)) then
     exit;
   if (NOT SetMode(NewMode)) then
     exit;

   IRQ := NewIRQ;
   case IRQ of
     0:      case NewPort of
               COM1, COM3: begin
                            IRQ := 4;
                            IRQInt := IRQ4;
                           end;
               COM2, COM4: begin
                            IRQ := 3;
                            IRQInt := IRQ3;
                           end;
             end;
{     2: IRQInt := $0a;  {Cascade Intrpt}
     3: IRQInt := IRQ3;  {Com2 Normally, or Com4}
     4: IRQInt := IRQ4;  {Com1 Normally, or Com3}
     5: IRQInt := IRQ5;  {LPT2, Bus Mouse, Fixed Disk}
     7: IRQInt := IRQ7;  {LPT1}
{    10: IRQInt := $72;  {Reserved? and Don't know how to use}
{    11: IRQInt := $73;  {Reserved? and Don't know how to use}
{    15: IRQInt := $77;  {Reserved? and Don't know how to use}
   else
     exit;              {While others can be used, it is not recommended}
   end; {case IRQ}

   GetIntVec(IRQInt, OldComVec);
   SetIntVec(IRQInt, @Com_Int);
   ComIsInit := TRUE;
end;

{ SetPort sets the current serial object to the correct port (COM1,2 etc)
  Currently, the code only goes to COM3.  The parameter must be the
  constant, COM1, COM2, or COM3 from the serial.inc file }
function TComPort.SetPort(NewPort: Byte): Boolean;

begin

  case NewPort of
    COM1: begin
            asm
              Mov ES, Seg0040           { This works with DPMI }
              Mov AX, ES:[0000]
              Mov [Cportbase], AX
            end; {asm}
          end;
    COM2: begin
            asm
              Mov ES, Seg0040
              Mov AX, ES:[0002]
              Mov [Cportbase], AX
            end; {asm}
          end;
    COM3: begin
            asm
              Mov ES, Seg0040
              Mov AX, ES:[0004]
              Mov [Cportbase], AX
            end; {asm}
          end;
    else
       PortBase := 0;
   end; {case NewPort}

   PortBase := Cportbase;
   if (PortBase = 0) then
     SetPort := FALSE
   else
     SetPort := TRUE;

end; {SetPort}

{ SetBaud sets up the baud rate to as close as possible the desired baud
  All standard baud rates are exact. Nonstandard baud rates (ie 247 baud )
  are valid but made not be exact. }
function TComPort.SetBaud(NewBaud: Word):  Boolean;
const
  Numerator = 115200;

var
  c:       Byte;
  divisor: integer;

begin

  if (NewBaud <= 0) OR (PortBase = 0) then
    begin
       SetBaud := FALSE;
       exit;
    end
  else
    begin
      divisor := Integer(Numerator div NewBaud);
    end;

  asm
    CLI
  end;

  c := Port[PortBase + LCR];
  Port[PortBase+LCR] := c OR $80;     { Set DLAB }
  Port[PortBase+DLL] := Lo(divisor);  { Low Order Bits }
  Port[PortBase+DLH] := Hi(divisor);  { High Order Bits }
  Port[PortBase+LCR] := c;            { Reset DLAB }
  asm
    STI
  end;

 SetBaud := TRUE;
end;


{ SetMode sets the port to 7 or 8 bits, Even, Odd, or No Parity,
  and 0,1 or 2 stop bits }

function TComPort.SetMode(NewMode: ModeStr):  Boolean;
var
  OK: Boolean;
  tst: Byte;

begin

  OK := TRUE;              { Assume it is OK unless we get an error }

  case NewMode[2] of
   'N': Parity := NO_PARITY;
   'E': Parity := EVEN_PARITY;
   'O': Parity := ODD_PARITY;
  else
    OK := FALSE;
  end; {case}

  NBits := Byte(NewMode[1]) - $30;
  NStopBits := Byte(NewMode[3]) - $30;

  if (NBits > 8) OR (NBits < 5) then
    OK := FALSE;
  if (NStopBits > 2) OR (NStopBits < 1) then
    OK := FALSE;

  if (OK <> FALSE) AND (PortBase <> 0) then
    begin
      Port[PortBase+LCR] := Parity OR (NBits-5) OR (4*(NStopBits-1));

      { Make sure it got there right }
      tst := Port[PortBase+LCR];
      if    ( Parity    <>  (tst AND $18) )
         OR ( NBits     <>  (tst AND $03 + 5) )
         OR ( NStopBits <> ((tst AND $04) div 4 + 1) ) then
      OK := FALSE;
    end;
  SetMode := OK;
end;

{ Returns the mode of the current port }
function TComPort.GetMode(var Mode: ModeStr):  ModeStr;
begin
  Mode[0] := #3;         { Make the Length = 3}

  case Parity of
    NO_PARITY:   Mode[2] := 'N';
    EVEN_PARITY: Mode[2] := 'E';
    ODD_PARITY:  Mode[2] := 'O';
  else
    Mode[2] := ' ';
  end; {case}

  Mode[1] := Char(NBits + $30);
  Mode[3] := Char(NStopBits + $30);
  GetMode := Mode;
end;

function TComPort.Com_On: Boolean;  { Tell Modem we are ready to go }
var
  Mask: Byte;
  d: Byte;
begin
  if (CPortBase <> 0) AND (IRQ > 0)  then
    begin
      Mask := NOT (1 SHL IRQ);
      i_enable(CPortBase, Mask);
    end
  else
    exit;

  d := Port[PortBase+MCR] OR Byte(DTR OR RTS);
  Port[PortBase+MCR] := d;

  Port[ICR] := EOI;
  ComIsOn := TRUE;
end; {Com_On}

function TComPort.Com_Off: Boolean; { Go Offline }
var
  Mask: Byte;
begin
  ComIsOn := FALSE;
  if (CPortBase <> 0) AND (IRQ > 0) then
    begin
      Mask := NOT (1 SHL IRQ);
      i_disable(CPortBase, Mask);
    end
  else
    exit;
  Port[PortBase+MCR] := 0;
end;

{ PutC sends a character to the port.  The parameter is a single byte }
function TComPort.PutC(ch: char): integer;
const
  TTimeOut: Word = 65535;

begin
  if (NOT ComIsOn) then
   begin
     PutC := 0;
     Exit;
   end;

 {Wait for Clear to Send from Modem}
 Port[PortBase+MCR] := Byte(MC_INT OR DTR OR RTS);  {Set up Control}
 while ( (Port[PortBase+MSR] AND CTS) = 0) do  {Read Status Reg until CTS}
   if ( TTimeOut = 0) then
     begin
       PutC := 0;
       exit;
     end
   else
     Dec(TTimeOut);

  TTimeOut := 65535;

 {Wait for Transmitter to Clear}
 while ( (Port[PortBase+LSR] AND Byte(XMTRDY)) = 0) do
   if ( TTimeOut = 0) then
     begin
       PutC := 0;
       exit;
     end
   else
     Dec(TTimeOut);

 asm
   CLI
 end;
 Port[PortBase+TXR] := Byte(ch);
 asm
   STI
 end;

 PutC := 1;
end; {PutC}

{ WriteBuf sends Count bytes to the port.  CBUF can be any type
  of variable, and need not be a string (in fact it is best to use
  WriteStr to send strings.  The calling routine must know how many
  bytes to send }
function TComPort.WriteBuf(const CBuf; Count: Word): integer;
var
  OutCount: Word;
  Buf: ^Char;

begin
  if (NOT ComIsOn) then
   begin
     WriteBuf := 0;
     Exit;
   end;

  Buf := @CBuf;
  OutCount := 0;
  While (Count > 0) do
    begin
      if (PutC( Buf^ ) = 0) then
        Count := 0
      else
        begin
          Inc(OutCount);
          Inc(Buf);
          Dec(Count);
        end;
    end;
 WriteBuf := OutCount;
end;

{Send a PASCAL string to the COM port }
function TComPort.WriteStr(CStr: string): integer;
var
  OutCount: Word;
  Buf: ^Char;
begin
  Buf := @CStr[1];      { point to first real ASCII char }
  WriteStr := WriteBuf(Buf, Length(CStr));
end;

{ Read a single byte from the port }
function TComPort.GetC(var ch: Char): integer;
begin
{  WriteLn('startbuf = ',startbuf,' endbuf = ', endbuf); }

  if (endbuf = startbuf) then
    GetC := 0
  else
    begin
      ch := Char( ComBuf[startbuf] AND $ff );
      Inc(startbuf);
      startbuf := startbuf mod BUFSIZE;
      GetC := 1;
    end;
end;

{ ReadBuf reads Count bytes from the port.  CBUF can be any type
  of variable, and need not be a string (in fact it is best to use
  ReadStr to send strings.  The calling routine must know how many
  bytes to read and no type or bounds checking is done so it is possible
  to read beyond the end of the array or variable!}
function TComPort.ReadBuf(var CBuf; Count: Word): integer;
var
  InCount: Word;
  Buf: ^Char;

begin

  Buf := @CBuf;
  InCount := 0;
  While (Count > 0) do
    begin
      if (GetC( Buf^ ) = 0) then
        Count := 0
      else
        begin
          Inc(InCount);
          Inc(Buf);
          Dec(Count);
        end;
    end;
 ReadBuf := InCount;

end;

{ Read a PASCAL string from the COM port }
function TComPort.ReadStr(var CStr: string): integer;
var
  n, i: integer;

begin
  n := 1;
  While ( GetC(CStr[n]) <> 0 ) do
    Inc(n);
  CStr[0] := Chr(n-1);
end;

{ returns the number of bytes currently in the input buffer }
function TComPort.BufCount: integer;
begin
   if (endbuf >= startbuf) then
     BufCount := endbuf - startbuf
   else
     BufCount := (BUFSIZE - startbuf) + endbuf;
end;

{ Read characters from the input buffer until a key is hit or the
  buffer is empty.  The keyhit is just a precaution in case you
  find that the buffer never empties due to a continuous data stream }
procedure TComPort.Flush;
var
c: Char;
begin
 while (Getc(c) <> 0) do
  begin
    if KeyPressed then exit;
  end;
end;

destructor TComPort.Done;
begin
   if (ComIsInit)  then                   { don't reset it to garbage }
     SetIntVec(IRQInt, @OldComVec);
   ComIsInit := FALSE;
end;

end.