{---------------------------------------------------------------------*
   FILENAME:                     SERIAL.INC

                  Some definitions used by SERIAL.PAS

 *--------------------------------------------------------------------}

const

     COM1 =           1;
     COM2  =          2;
     COM3  =          3;
     COM4  =          4;
     COM1BASE =       $3F8;   { Default Base port address for COM1 }
     COM2BASE =       $2F8;   { Default Base port address for COM2 }
     COM3BASE =       $3E8;   { Default Base port address for COM3 }
     COM4BASE =       $2E8;   { Default Base port address for COM4 }

{
    The 8250 UART has 10 registers accessible through 7 port addresses.
    Here are their addresses relative to COM1BASE and COM2BASE. Note
    that the baud rate registers, (DLL) and (DLH) are active only when
    the Divisor-Latch Access-Bit (DLAB) is on. The (DLAB) is bit 7 of
    the (LCR).

	o TXR Output data to the serial port.
	o RXR Input data from the serial port.
	o LCR Initialize the serial port.
	o IER Controls interrupt generation.
	o IIR Identifies interrupts.
	o MCR Send contorl signals to the modem.
	o LSR Monitor the status of the serial port.
	o MSR Receive status of the modem.
	o DLL Low byte of baud rate divisor.
	o DHH High byte of baud rate divisor.
}
      TXR =            0;       {  Transmit register (WRITE) }
      RXR =            0;       {  Receive register  (READ)  }
      IER =            1;       {  Interrupt Enable          }
      IIR =            2;       {  Interrupt ID              }
      LCR =            3;       {  Line control              }
      MCR =            4;       {  Modem control             }
      LSR =            5;       {  Line Status               }
      MSR =            6;       {  Modem Status              }
      DLL =            0;       {  Divisor Latch Low         }
      DLH =            1;       {  Divisor latch High        }


{-------------------------------------------------------------------*
  Bit values held in the Line Control Register (LCR).
	bit		meaning
	---		-------
	0-1		00=5 bits, 01=6 bits, 10=7 bits, 11=8 bits.
	2		Stop bits.
	3		0=parity off, 1=parity on.
	4		0=parity odd, 1=parity even.
	5		Sticky parity.
	6		Set break.
	7		Toggle port addresses.
 *-------------------------------------------------------------------}
      NO_PARITY   =    $00;
      EVEN_PARITY =    $18;
      ODD_PARITY  =    $08;


{-------------------------------------------------------------------*
  Bit values held in the Line Status Register (LSR).
	bit		meaning
	---		-------
	0		Data ready.
	1		Overrun error - Data register overwritten.
	2		Parity error - bad transmission.
	3		Framing error - No stop bit was found.
	4		Break detect - End to transmission requested.
	5		Transmitter holding register is empty.
	6		Transmitter shift register is empty.
	7               Time out - off line.
 *-------------------------------------------------------------------}
       RCVRDY   =       $01;
       OVRERR   =       $02;
       PRTYERR  =       $04;
       FRMERR   =       $08;
       BRKERR   =       $10;
       XMTRDY   =       $20;
       XMTRSR   =       $40;
       TIMEOUT	=	$80;

{-------------------------------------------------------------------*
  Bit values held in the Modem Output Control Register (MCR).
	bit     	meaning
	---		-------
	0		Data Terminal Ready. Computer ready to go.
	1		Request To Send. Computer wants to send data.
	2		auxillary output #1.
	3		auxillary output #2.(Note: This bit must be
			set to allow the communications card to send
			interrupts to the system)
	4		UART ouput looped back as input.
	5-7		not used.
 *------------------------------------------------------------------}
       DTR     =        $01;
       RTS     =        $02;
       MC_INT  =	$08;


{------------------------------------------------------------------*
  Bit values held in the Modem Input Status Register (MSR).
	bit		meaning
	---		-------
	0		delta Clear To Send.
	1		delta Data Set Ready.
	2		delta Ring Indicator.
	3		delta Data Carrier Detect.
	4		Clear To Send.
	5		Data Set Ready.
	6		Ring Indicator.
	7		Data Carrier Detect.
 *------------------------------------------------------------------}
       CTS   =          $10;
       DSR   =          $20;
       DCD   =          $80;


{------------------------------------------------------------------*
  Bit values held in the Interrupt Enable Register (IER).
	bit		meaning
	---		-------
	0		Interrupt when data received.
	1		Interrupt when transmitter holding reg. empty.
	2		Interrupt when data reception error.
	3		Interrupt when change in modem status register.
	4-7		Not used.
 *------------------------------------------------------------------}
       RX_INT   =       $01;


{------------------------------------------------------------------*
  Bit values held in the Interrupt Identification Register (IIR).
	bit		meaning
	---		-------
	0		Interrupt pending
	1-2             Interrupt ID code
			00=Change in modem status register,
			01=Transmitter holding register empty,
			10=Data received,
			11=reception error, or break encountered.
	3-7		Not used.
 *------------------------------------------------------------------}
       RX_ID   =        $04;
       RX_MASK =        $07;


{
    These are the port addresses of the 8259 Programmable Interrupt
    Controller (PIC).
}
       IMR     =        $21;   { Interrupt Mask Register port }
       ICR     =        $20;   { Interrupt Control Port       }


{
    An end of interrupt needs to be sent to the Control Port of
    the 8259 when a hardware interrupt ends.
}
       EOI     =        $20;   { End Of Interrupt }


{
    The (IMR) tells the (PIC) to service an interrupt only if it
    is not masked (FALSE).
}
       IRQ3     =       $0B;    { Actual IRQ Number }
       IRQ4     =       $0C;
       IRQ5     =       $0D;
       IRQ7     =       $0F;

       IRQ3MASK     =       $F7;  { COM2, bit 3 }
       IRQ4MASK     =       $EF;  { COM1, bit 4 }
{       IRQ5MASK     =       $DF;  { LPT2 or BUS MOUSE, bit 5 }
{       IRQ7MASK     =       $7F;  { LPT1, bit 7 }
