{ --
  Example showing how to pick up on the moment when
  a user selects a item from a ComboBox
  -- }

program MyProgram;

uses WinTypes, WinProcs, OWindows, ODialogs;
{$R ComboDlg}

const
  cm_Dialog = 105;
  id_ListBox = 101;

type
  TMyApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyDialog =^TMyDialog;
  TMyDialog = Object(TDlgWindow)
      ListBox: PComboBox;
    Constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure SetUpWindow; virtual;
    procedure Ok(var Msg: TMessage);
      virtual id_First + idOk;
    procedure ListClick(var Msg: TMessage);
      virtual id_First + id_ListBox;
  end;

type
  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; AName: PChar);    
    procedure CmDialog(var Msg: TMessage);
      virtual cm_First + cm_Dialog;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TMyDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
  TDlgWindow.Init(AParent, AName);
  ListBox := New(PComboBox, InitResource(@Self, Id_ListBox, 200));
end;

procedure TMyDialog.SetUpWindow;
var
  S: array[0..200] of Char;
  i: Integer;
begin
  TDlgWindow.SetUpWindow;
  for i := 0 to 20 do begin
    WvsPrintF(S, 'Item: %d', i);
    ListBox^.AddString(S);
  end;
end;

procedure TMyDialog.Ok(var Msg: TMessage);
begin
  TDialog.Ok(Msg);
end;

procedure TMyDialog.ListClick(var Msg: TMessage);
var
  S: array[0..100] of Char;
begin
  if Msg.LParamHi = cbn_SelChange then begin
    ListBox^.GetText(S, 100);
    MessageBox(HWindow, S, 'Info', mb_Ok);
  end;

{  if Msg.LParamHi = cbn_KillFocus then
    MessageBox(HWindow, 'None', nil, mb_Ok); }
end;

constructor TMyWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  TWindow.Init(AParent, AName);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
end;

procedure TMyWindow.cmDialog(var Msg: TMessage);
var
  D: PMyDialog;

begin
  D := new(PMyDialog, Init(@Self, 'Dialog_1'));
  Application^.ExecDialog(D);
  {ShowWindow(D^.HWindow, sw_Normal);}
end;


{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}

procedure TMyApplication.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'Sample ObjectWindows Program'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var
  MyApp: TMyApplication;

begin
  MyApp.Init('MyProgram');
  MyApp.Run;
  MyApp.Done;
end.
