{--------------------------------------------------------------}
{                           SoftIntTest                        }
{                                                              }
{       Software interrupt service routine demonstration       }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/17/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM SoftIntTest;

USES DOS,CRT;


VAR
  Foo : Word;
  Regs : Registers;
  OldVector : Pointer;



PROCEDURE EnableInterrupts;

INLINE($FB);



PROCEDURE SoftISR(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : Word);
INTERRUPT;

BEGIN
  EnableInterrupts;
  FOO := AX;
  BX := 17;
END;



{$F+}
PROCEDURE OurExitProc;

BEGIN
  SetIntVec(76,OldVector); { Put 76 back to whatever it was before }
END;
{$F-}



BEGIN
  ExitProc := @OurExitProc;  { Link exit proc into the chain }

  FOO := 0;
  ClrScr;

  { We use 76 here because it's an unused vector }
  GetIntVec(76,OldVector);   { Save old copy...just in case }
  SetIntVec(76,@SoftISR);    { Give vector 76 SoftISR's address }

  Regs.AX := 42;      { Pass a value to SoftISR through AX }
  Regs.BX := 0;       { Zero BX before making the call }
  Intr(76,Regs);      { Trip interrupt 76 }

  Writeln('Foo=',Foo);     { Now examine FOO and BX }
  Writeln('BX =',Regs.BX);
  Readln;
END.
