{--------------------------------------------------------------}
{                            FONT                              }
{                                                              }
{      Display adapter text font query and change utility      }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V4.0                }
{                             Last update 7/1/88               }
{                                                              }
{ From the book, COMPLETE TURBO PASCAL 5.0   by Jeff Duntemann }
{           Scott, Foresman & Co.  ISBN 0-673-38355-5          }
{--------------------------------------------------------------}

PROGRAM Font;

USES Crt,DOS;

TYPE
  AdapterType = (None,MDA,CGA,EGAMono,EGAColor,VGAMono,
                  VGAColor,MCGAMono,MCGAColor);
  FontSizes   = SET OF Byte;

CONST
  AdapterStrings : ARRAY[AdapterType] OF String =
                     ('None','MDA','CGA','EGAMono','EGAColor',
                      'VGAMono','VGAColor','MCGAMono','MCGAColor');


VAR
  InstalledAdapter : AdapterType;
  LegalSizes       : FontSizes;
  AdapterSizes     : FontSizes;
  ErrorPos         : Integer;
  ErrorSize        : String;
  NewFont          : Byte;
  FontCode         : Byte;
  OldAdapters      : SET OF AdapterType;
  Regs             : Registers;


{$I QUERYDSP.SRC}  { Contains function QueryAdapterType; see Section 18.4 }

{$I FONTSIZE.SRC}  { Contains function DeterminePoints; see Section 18.4 }


PROCEDURE ShowFontSizeError(BadSize : String);

BEGIN
  Writeln(BadSize,' is not a valid font size.');
  Writeln('Legal values are 8, 14, and 16,');
  Writeln('*if* your display adapter supports them.')
END;



BEGIN   { MAIN }
  LegalSizes := [8,14,16];  { IBM adapters only use these three sizes }
  OldAdapters := [CGA,MDA]; { The CGA and MDA cannot change fonts }

  IF ParamCount < 1 THEN
    BEGIN
      InstalledAdapter := QueryAdapterType;
      Writeln('>>FONT<<  V1.1 by Jeff Duntemann');
      Writeln('          From the book, COMPLETE TURBO PASCAL 5.0');
      Writeln('          ISBN 0-673-38355-5');
      Writeln;
      Writeln('The installed adapter is: ',
               AdapterStrings[InstalledAdapter]);
      Writeln('The current font size is: ',DeterminePoints);
      Writeln;
      Writeln
      ('To change the current font size, invoke FONT.EXE with the desired');
      Writeln
      ('font size as the only parameter, which must be one of 8, 14, or 16:');
      WRiteln; Writeln('   C>FONT 14'); WRITELN;
      Writeln('Remember that the font size of the CGA and MDA cannot change.');
      Writeln
('The EGA supports 8 and 14, while the VGA supports 8, 14, or 16.');
      Writeln('The MCGA supports the 16 pixel font size *only*.');
      Writeln
('FONT.EXE passes the current font size in ERRORLEVEL for use in batch files.');
      Halt(DeterminePoints)  { Make point size available in ERRORLEVEL }
      { THIS IS AN EXIT POINT FROM FONT.PAS!!! }
    END
  ELSE
    BEGIN
      Val(ParamStr(1),NewFont,ErrorPos);
      IF ErrorPos <> 0 THEN ShowFontSizeError(ParamStr(2))
      ELSE
        IF NOT (NewFont IN LegalSizes) THEN
          BEGIN
            Str(NewFont,ErrorSize);
            ShowFontSizeError(ErrorSize)
          END
        ELSE      { At this point entered font size is OK... }
          BEGIN   { ...but we must be sure the adapter supports it: }
            InstalledAdapter := QueryAdapterType;
            CASE InstalledAdapter OF
              CGA                : AdapterSizes := [8];
              MDA                : AdapterSizes := [14];
              EGAMono,EGAColor   : AdapterSizes := [8,14];
              VGAMono,VGAColor   : AdapterSizes := [8,14,16];
              MCGAMono,MCGAColor : AdapterSizes := [16];
            END;  { CASE }
            IF NOT (NewFont IN AdapterSizes) THEN
              BEGIN
                Writeln('That font size does not exist');
                Writeln('on your display adapter.')
              END
            ELSE      { Finally, do the font switch }
              BEGIN
                ClrScr;
                IF NOT (InstalledAdapter IN OldAdapters) THEN
                  BEGIN
                    CASE NewFont OF
                      8  : FontCode := $12;
                      14 : FontCode := $11;
                      16 : FontCode := $10;
                    END;  { CASE }
                    Regs.AH := $11;  { EGA/VGA character generator services }
                    Regs.AL := FontCode;  { Plug in the code for this size... }
                    Regs.BX := 0;
                    Intr($10,Regs);  { ...and make the BIOS call. }
                    { Suppress BIOS cursor emulation: }
                    MEM[$40:$87] := MEM[$40:$87] OR $01;
                    { Now reset the cursor to the appropriate lines: }
                    Regs.AX := $100;
                    Regs.BX := 0;
                    Regs.CL := 0;
                    Regs.CH := NewFont - 2;  { i.e., 6, 12, or 14 }
                    Intr($10,Regs);  { Make the BIOS call. }
                    HALT(DeterminePoints);
                  END
              END
          END
    END
END.
