{--------------------------------------------------------------}
{                          BoxStuff                            }
{                                                              }
{           Demonstration unit -- draws text boxes             }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/13/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}


UNIT BoxStuff;


INTERFACE


USES Crt;     { For GotoXY }

TYPE
  GrafRec = RECORD
              ULCorner,
              URCorner,
              LLCorner,
              LRCorner,
              HBar,
              VBar,
              LineCross,
              TDown,
              TUp,
              TRight,
              TLeft : String[4]
            END;

VAR
  GrafChars : GrafRec;  { Contains box-drawing strings for MakeBox.}
                        { Any program or unit that USES BoxStuff   }
                        { can access the GrafChars variable just   }
                        { as though it had been defined within the }
                        { USEing program or unit.                  }


{<<<< MakeBox >>>>}
{ This is all that the "outside world" really needs to see of the }
{ MakeBox procedure.  *How* it happens is irrelevant to using it. }

PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  GrafChars        : GrafRec);



IMPLEMENTATION


{<<<< DefineChars >>>>}
{ This procedure is called from the initialization part of the    }
{ unit, and fills the GrafChars record with the box characters.   }
{ Note that it is private to the BoxStuff unit, and *cannot* be   }
{ called from outside the unit.  Note that because it is not part }
{ of the INTERFACE, the full parameter list *must* be given here. }

PROCEDURE DefineChars(VAR GrafChars : GrafRec);

BEGIN
  WITH GrafChars DO
    BEGIN
      ULCorner  := Chr(201);
      URCorner  := Chr(187);
      LLCorner  := Chr(200);
      LRCorner  := Chr(188);
      HBar      := Chr(205);
      VBar      := Chr(186);
      LineCross := Chr(206);
      TDown     := Chr(203);
      TUp       := Chr(202);
      TRight    := Chr(185);
      TLeft     := Chr(204)
    END
END;



{ <<<<MakeBox>>>> }
{ Note here that the parameter line does not have to be repeated. }
{ (We gave the full parameter list definition in the INTERFACE.)  }
{ But since it does no harm, you might as well re-state the       }
{ parameter list.  That makes it easier to read the full source   }
{ for MakeBox. }

PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  GrafChars        : GrafRec);

VAR
  I,J : Integer;

BEGIN
  IF X < 0 THEN X := (80-Width) DIV 2;    { Negative X centers box }
  WITH GrafChars DO
    BEGIN                                 { Draw top line }
      GotoXY(X,Y); Write(ULCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(URCorner);
                                          { Draw bottom line }
      GotoXY(X,(Y+Height)-1); Write(LLCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(LRCorner);
                                          { Draw sides }
      FOR I := 1 TO Height-2 DO
        BEGIN
          GotoXY(X,Y+I); Write(VBar);
          GotoXY((X+Width)-1,Y+I); Write(VBar)
        END
    END
END;


{-------------------------------------------------------------------}
{ <<<< BOXSTUFF INITIALIZATION SECTION >>>>                         }
{ The initialization section executes before the main block of any  }
{ Pascal program that USES BoxStuff.  Here, the initialization      }
{ section fills a record variable called GrafChars with box-drawing }
{ characters, so that the variable is initialized and ready to use  }
{ as soon as the main block begins executing.  The programmer does  }
{ not have to know ANYTHING about procedure DefineChars.            }
{-------------------------------------------------------------------}

BEGIN
  DefineChars(GrafChars);
END.
