{--------------------------------------------------------------}
{                           Averager                           }
{                                                              }
{             Binary file I/O demonstration program            }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/24/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM Averager;

VAR
  IntFile       : FILE OF Integer;
  I,J,Count     : Integer;
  Average,Total : Real;

BEGIN
  Assign(IntFile,'INTEGERS.BIN');
  {$I-} Reset(IntFile); {$I+}
  I := IOResult;
  IF I <> 0 THEN
    BEGIN
      Writeln('>>File INTEGERS.BIN is missing or damaged.');
      Writeln('  Please investigate and run the program again.')
    END
  ELSE
    BEGIN
      Count := 0; Total := 0.0;
      WHILE NOT EOF(IntFile) DO
        BEGIN
          Read(IntFile,J);
          IF NOT EOF(IntFile) THEN
            BEGIN
              Count := Count + 1;
              Total := Total + J
            END;
        END;
      Close(IntFile);
      AVERAGE := Total / Count;
      Writeln;
      Writeln('>>There are ',Count,' integers in INTEGERS.BIN.');
      Writeln('  Their average value is ',Average:10:6,'.');
    END
END.
