{->>>>DrawMarker<<<<-------------------------------------------}
{                                                              }
{ Filename : DRAWMARK.SRC -- Last Modified 7/10/88             }
{                                                              }
{ This routine uses relative line draws to draw "polymarkers"  }
{ at the current pointer (CP).  The patterns to be drawn are   }
{ arrays of "deltas", each delta being a "change in X" and     }
{ "change in Y" integer pair.  The first pair is a MOVE not a  }
{ line draw, to allow the marker to be drawn entirely away     }
{ from the CP.                                                 }
{                                                              }
{ This routine may only be used in graphics mode.              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

TYPE
  PointArray = ARRAY[0..9,0..1] OF Integer;

CONST
  Lozenge : PointArray =
  ((0,-3),(-3,3),(3,3),(3,-3),(-3,-3),(0,0),(0,0),(0,0),(0,0),(0,0));
  Cross   : PointArray =
  ((0,0),(0,-3),(0,6),(0,-3),(3,0),(-6,0),(0,0),(0,0),(0,0),(0,0));
  Square  : PointArray =
  ((-2,-2),(0,4),(4,0),(0,-4),(-4,0),(0,0),(0,0),(0,0),(0,0),(0,0));

PROCEDURE DrawMarker(Marker : PointArray);

VAR
  I : Integer;

BEGIN
  MoveRel(Marker[0,0],Marker[0,1]);  { First pair is relative move }
  I := 1;    { Start drawing with coordinate pair 1, not 0! }
  WHILE NOT ((Marker[I,0] = 0) AND (Marker[I,1] = 0)) DO
    BEGIN
      LineRel(Marker[I,0],Marker[I,1]);
      Inc(I)
    END
END;
