{$X+}

unit cdc;

interface

uses WinTypes, Strings;

const
  MCI_Notify            = $03B9;    { MCI Notification Message }
  MCI_Notify_Successful = 1;
  MCI_Notify_Superseded = 2;
  MCI_Notify_Aborted    = 4;
  MCI_Notify_Failure    = 8;


Type
  TimeTMSF = Record
    Tracks,
    Minutes,
    Seconds,
    Frames   : Integer;
  end;

  TrackRecord = Record
    Minutes,
    Seconds,
    Frames : Integer;
    StartMin,
    StartSec,
    StartFrame : Integer;
  end;

Var
  WinHandle  : HWnd;
  MixerAvail : Boolean;
  CDAvail    : Boolean;
  NumTracks  : Integer;
  Paused     : Boolean;
  Repeating  : Boolean;

FUNCTION mciSendString (pSendString: Pointer;
    PReturnString: Pointer; wReturnStringLength: WORD; hCallback: THandle) : LONGINT;
FUNCTION mciGetErrorString (liErrorCode: LONGINT; pErrorBuffer: pointer;
    wBufferLength: WORD) : WORD;

function CanPlay : Boolean;

function OpenCD : Boolean;

function StopCD : Boolean;

function CloseCD : Boolean;

function PauseCD : Boolean;

function ResumeCD : Boolean;

function PlayCD(FrTrack, ToTrack : Integer) : Boolean;

function EjectCD : Boolean;

function SetTMSF : Boolean;

function SetMSF : Boolean;

function CurrentTrack : Integer;

function LengthCD : String;

function LengthTrack(TrackNum : Integer) : String;

Function StartCD : String;

Function Position : String;

Function StartTrack(TrackNum : Integer) : String;

function Mode : String;

function NumberOfTracks : Integer;

function MediaPresent : Boolean;

function Ready : Boolean;

function OpenMixer : Boolean;

function CloseMixer : Boolean;

function Bass(Value : Integer) : Integer;

function Treble(Value : Integer) : Integer;

function MidRange(Value : Integer) : Integer;

function Volume(Channel : String; Value : Integer) : Integer;

function Reverb(Value : Integer) : Integer;

function Loudness(Value : Integer) : Integer;

function StereoEnhance(Value : Integer) : Integer;

procedure ConvTMSF(var TMSF_Rec : TimeTMSF;TStr : String);

procedure ConvMSF(var TMSF_Rec : TimeTMSF;TStr : String);

{********************************************************************}

implementation

{********************************************************************}

const
  RetLen = 256;

FUNCTION MCIGetErrorString    ; EXTERNAL 'MMSYSTEM' INDEX   706;
FUNCTION MCISendString        ; EXTERNAL 'MMSYSTEM' INDEX   702;

function CanPlay : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('capability cdaudio canplay');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     CanPlay := FALSE
  Else
     CanPlay := (StrIComp(RetStr,'true') = 0);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function OpenCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('open cdaudio shareable');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     OpenCD := FALSE
  Else
     OpenCD := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function StopCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('stop cdaudio');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     StopCD := FALSE
  Else
     StopCD := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function CloseCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('close cdaudio');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     CloseCD := FALSE
  Else
     CloseCD := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function SetTMSF : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('set cdaudio time format tmsf');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SetTMSF := FALSE
  Else
     SetTMSF := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function SetMSF : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('set cdaudio time format msf');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SetMSF := FALSE
  Else
     SetMSF := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function CurrentTrack : Integer;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio current track');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Num := 0
  Else
     Val(RetStr, Num, Code);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  CurrentTrack := Num;
end;

Function LengthCD : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio length');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := '0'
  Else
     SStr := StrPas(RetStr);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  LengthCD := SStr;
end;

function LengthTrack(TrackNum : Integer) : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  GetMem(SendStr, 64);
  Str(TrackNum, SStr);
  SStr := 'status cdaudio length track ' + SStr;
  StrPCopy(SendStr, SStr);
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := '0'
  Else
     SStr := StrPas(RetStr);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  LengthTrack := SStr;
end;

Function StartCD : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio start position');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := '0'
  Else
     SStr := StrPas(RetStr);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  StartCD := SStr;
end;

Function Position : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio position');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := '0'
  Else
     SStr := StrPas(RetStr);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  Position := SStr;
end;

Function StartTrack(TrackNum : Integer) : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  GetMem(SendStr, 64);
  Str(TrackNum, SStr);
  SStr := 'status cdaudio position track ' + SStr;
  StrPCopy(SendStr, SStr);
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := '0'
  Else
     SStr := StrPas(RetStr);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  StartTrack := SStr;
end;


function Mode : String;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio mode');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     SStr := 'not ready'
  Else
     SStr := StrPas(RetStr);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  Mode := SStr;
end;


function NumberOfTracks : Integer;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio number of tracks');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Num := 0
  Else
     Val(RetStr, Num, Code);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  NumberOfTracks := Num;
end;

function MediaPresent : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio media present');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     MediaPresent := FALSE
  Else
     MediaPresent := (StrIComp(RetStr,'true') = 0);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;


function Ready : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('status cdaudio ready');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Ready := FALSE
  Else
     Ready := (StrIComp(RetStr,'true') = 0);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function PauseCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  If Paused THEN
     ResumeCD
  ELSE
  Begin
    GetMem(RetStr, 256);
    SendStr := StrNew('pause cdaudio');
    If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
       PauseCD := FALSE
    Else
       PauseCD := TRUE;
    Dispose(SendStr);
    FreeMem(RetStr, 256);
    Paused := TRUE;
  End;
end;

function ResumeCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  Paused := FALSE;
  GetMem(RetStr, 256);
  SendStr := StrNew('play cdaudio notify');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     ResumeCD := FALSE
  Else
     ResumeCD := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function PlayCD(FrTrack, ToTrack : Integer) : Boolean;
var
  SendStr,
  RetStr : PChar;
  Error           : LongInt;
  FStr, TStr, SStr      : String;
begin
  If Paused Then
     ResumeCD
  ELSE
  Begin
    GetMem(RetStr, 256);
    GetMem(SendStr, 64);
    Str(FrTrack, FStr);
    Str(ToTrack, TStr);
    SStr := 'play cdaudio notify';
    If FrTrack <> 0 THEN
       SStr := SStr + ' from ' + FStr;
    If ToTrack <> 0 THEN
       SStr := SStr + ' to ' + TStr;
    StrPCopy(SendStr, SStr);
    If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
       PlayCD := FALSE
    Else
       PlayCD := TRUE;
    FreeMem(SendStr, 64);
    FreeMem(RetStr, 256);
  End;
end;

function EjectCD : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('set cdaudio door open');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     EjectCD := FALSE
  Else
     EjectCD := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function OpenMixer : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('open mixer shareable');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     OpenMixer := FALSE
  Else
     OpenMixer := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;

function CloseMixer : Boolean;
var
  SendStr, RetStr : PChar;
  Error           : LongInt;
begin
  GetMem(RetStr, 256);
  SendStr := StrNew('close mixer');
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     CloseMixer := FALSE
  Else
     CloseMixer := TRUE;
  Dispose(SendStr);
  FreeMem(RetStr, 256);
end;


function Bass(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  Str(Value, SStr);
  If Value >= 0 THEN
     Begin
       GetMem(SendStr, 64);
       SStr := 'set mixer control bass Line_Out 1 to ' + SStr;
       StrPCopy(SendStr, SStr);
       mciSendString(SendStr, RetStr, RetLen, WinHandle);
       FreeMem(SendStr, 64);
     End;
  SStr := 'get mixer control bass Line_Out 1';
  GetMem(SendStr, 64);
  StrPCopy(SendStr, SStr);
  mciSendString(SendStr, RetStr, RetLen, WinHandle);
  Val(RetStr, Num, Code);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  Bass := Num;
end;

function Treble(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  Str(Value, SStr);
  If Value >= 0 THEN
     Begin
       GetMem(SendStr, 64);
       SStr := 'set mixer control treble Line_Out 1 to ' + SStr;
       StrPCopy(SendStr, SStr);
       mciSendString(SendStr, RetStr, RetLen, WinHandle);
       FreeMem(SendStr, 64);
     End;
  SStr := 'get mixer control treble Line_Out 1';
  GetMem(SendStr, 64);
  StrPCopy(SendStr, SStr);
  mciSendString(SendStr, RetStr, RetLen, WinHandle);
  Val(RetStr, Num, Code);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  Treble := Num;
end;

function MidRange(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Error           : LongInt;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  Str(Value, SStr);
  If Value >= 0 THEN
     Begin
       GetMem(SendStr, 64);
       SStr := 'set mixer control midrange Line_Out 1 to ' + SStr;
       StrPCopy(SendStr, SStr);
       mciSendString(SendStr, RetStr, RetLen, WinHandle);
       FreeMem(SendStr, 64);
     End;
  SStr := 'get mixer control midrange Line_Out 1';
  GetMem(SendStr, 64);
  StrPCopy(SendStr, SStr);
  mciSendString(SendStr, RetStr, RetLen, WinHandle);
  Val(RetStr, Num, Code);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  MidRange := Num;
end;

function Volume(Channel : String; Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  SStr            : String;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  Str(Value, SStr);
  If Value >= 0 THEN
     Begin
       GetMem(SendStr, 64);
       SStr := 'set mixer control volume ' + channel + ' Line_Out 1 to ' + SStr;
       StrPCopy(SendStr, SStr);
       mciSendString(SendStr, RetStr, RetLen, WinHandle);
       FreeMem(SendStr, 64);
     End;
  SStr := 'get mixer control volume ' + channel + ' Line_Out 1';
  GetMem(SendStr, 64);
  StrPCopy(SendStr, SStr);
  mciSendString(SendStr, RetStr, RetLen, WinHandle);
  Val(RetStr, Num, Code);
  FreeMem(SendStr, 64);
  FreeMem(RetStr, 256);
  Volume := Num;
end;

function Reverb(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  GetMem(SendStr, 64);
  Case Value OF
       -1 : SendStr := StrNew('set mixer both control reverb Line_Out 1 to 0');
        0 : SendStr := StrNew('get mixer both control reverb Line_Out 1');
        1 : SendStr := StrNew('set mixer both control reverb Line_Out 1 to 99');
  End; { Case }
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Num := -1000
  Else
     Val(RetStr, Num, Code);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  Reverb := Num;
end;

function Loudness(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  GetMem(SendStr, 64);
  Case Value OF
       -1 : SendStr := StrNew('set mixer both control loudness Line_Out 1 to 0');
        0 : SendStr := StrNew('get mixer both control loudness Line_Out 1');
        1 : SendStr := StrNew('set mixer both control loudness Line_Out 1 to 99');
  End; { Case }
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Num := -1000
  Else
     Val(RetStr, Num, Code);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  Loudness := Num;
end;

function StereoEnhance(Value : Integer) : Integer;
var
  SendStr, RetStr : PChar;
  Num, Code       : Integer;
begin
  GetMem(RetStr, 256);
  GetMem(SendStr, 64);
  Case Value OF
       -1 : SendStr := StrNew('set mixer both control stereoenhance Line_Out 1 to 0');
        0 : SendStr := StrNew('get mixer both control stereoenhance Line_Out 1');
        1 : SendStr := StrNew('set mixer both control stereoenhance Line_Out 1 to 99');
  End; { Case }
  If (mciSendString(SendStr, RetStr, RetLen, WinHandle) <> 0) THEN
     Num := -1000
  Else
     Val(RetStr, Num, Code);
  Dispose(SendStr);
  FreeMem(RetStr, 256);
  StereoEnhance := Num;
end;

procedure ConvTMSF(var TMSF_Rec : TimeTMSF;TStr : String);
var
  SLen : Integer;
  SPos : Integer;
  Code : Integer;
  Temp : String;
begin
  If Length(TStr) < 11 THEN
     FillChar(TMSF_Rec, SizeOf(TMSF_Rec), #0)
  ELSE
  Begin
    Temp := Copy(TStr, 1, Pos(TStr, ':')-1);
    Val(Temp, TMSF_Rec.Tracks, Code);
    Delete(TStr, 1, Pos(':', TStr));

    Temp := Copy(TStr, 1, Pos(':', TStr)-1);
    Val(Temp, TMSF_Rec.Minutes, Code);
    Delete(TStr, 1, Pos(':', TStr));

    Temp := Copy(TStr, 1, Pos(':', TStr)-1);
    Val(Temp, TMSF_Rec.Seconds, Code);
    Delete(TStr, 1, Pos(':', TStr));

    Temp := TStr;
    Val(Temp, TMSF_Rec.Frames, Code);
  End;
end;

procedure ConvMSF(var TMSF_Rec : TimeTMSF;TStr : String);
var
  SLen : Integer;
  SPos : Integer;
  Code : Integer;
  Temp : String;
begin
  If Length(TStr) < 8 THEN
     FillChar(TMSF_Rec, SizeOf(TMSF_Rec), #0)
  ELSE
  Begin
    Temp := Copy(TStr, 1, Pos(':', TStr)-1);
    Val(Temp, TMSF_Rec.Minutes, Code);
    Delete(TStr, 1, Pos(':', TStr));

    Temp := Copy(TStr, 1, Pos(':', TStr)-1);
    Val(Temp, TMSF_Rec.Seconds, Code);
    Delete(TStr, 1, Pos(':', TStr));

    Temp := TStr;
    Val(Temp, TMSF_Rec.Frames, Code);
  End;
End;

Begin
  WinHAndle := 0;
  MixerAvail := OpenMixer;
  CDAvail := OpenCD;

  CloseCD;
  CloseMixer;
end.