Unit Cursors;

{This unit contains the definitions of several different cursors     }
{for use with the MOUSE.TPU unit.  This unit is found in the book    }
{OBJECT ORIENTED PROGRAMMING IN TURBO PASCAL 5.5                     }
{The Graphic Cursors are passed as shown below and can be created    }
{using the program MOUSEPTR.EXE, compiled from MOUSEPTR.PAS also     }
{found in the bood OOP IN TP 5.5.                                    }

Interface

{This unit exports a Type GCursor which defines the record holding   }
{a graphics cursor, and the graphics cursors themselves              }

Type
    GCursor = record
            ScreenMask,
            CursorMask : array[0..15] of word;
            hotX,hotY  : integer;
            end; {record}


                  {================================}
                  {Graphics Cursors are predefined }
                  {for use with GraphicMouse       }
                  {================================}


Const           {The graphics cursors are defined as constants       }

     HAMMER : GCursor =       {As in the hammer of THOR, my favorite}
            (ScreenMask : ($8003,$0001,$0001,$1831,
                           $1011,$0001,$0001,$8003,
                           $F83F,$F83F,$F83F,$F83F,
                           $F83F,$F83F,$F83F,$F83F);
             CursorMask : ($0000,$3FF8,$4284,$4104,
                           $4284,$4444,$3FF8,$0380,
                           $0380,$0380,$0380,$0380,
                           $0380,$0380,$0380,$0000);
             HotX : $0007;
             HotY : $0003);

     ARROW : GCursor =       {Your run-of-the-mill Graphics Arrow cursor}
           (ScreenMask : ($1FFF,$0FFF,$07FF,$03FF,
                          $01FF,$00FF,$007F,$003F,
                          $001F,$003F,$01FF,$01FF,
                          $E0FF,$F0FF,$F8FF,$F8FF);
            CursorMask : ($0000,$4000,$6000,$7000,
                          $7800,$7C00,$7E00,$7F00,
                          $7F80,$7C00,$4C00,$0600,
                          $0600,$0300,$0400,$0000);
            HotX : $0001;
            HotY : $0001);

     CHECK : GCursor =       {A check-mark cursor}
           (ScreenMask : ($FFF0,$FFE0,$FFC0,$FF81,
                          $FF03,$0607,$000F,$001F,
                          $803F,$C07F,$E0FF,$F1FF,
                          $FFFF,$FFFF,$FFFF,$FFFF);
            CursorMask : ($0000,$0006,$000C,$0018,
                          $0030,$0060,$70C0,$3980,
                          $1F00,$0E00,$0400,$0000,
                          $0000,$0000,$0000,$0000);
            HotX : $0005;
            HotY : $0010);

     CROSS : GCursor =       {A circle with center cross cursor}
           (ScreenMask : ($F01F,$E00F,$C007,$8003,
                          $0441,$0C61,$0381,$0381,
                          $0381,$0C61,$0441,$8003,
                          $C007,$E00F,$F01F,$FFFF);
            CursorMask : ($0000,$07C0,$0920,$1110,
                          $2108,$4004,$4004,$783C,
                          $4004,$4004,$2108,$1110,
                          $0920,$07C0,$0000,$0000);
            HotX : $0007;
            HotY : $0007);

     GLOVE : GCursor =       {The hand with pointing finger cursor}
           (ScreenMask : ($F3FF,$E1FF,$E1FF,$E1FF,
                          $E1FF,$E049,$E000,$8000,
                          $0000,$0000,$07FC,$07F8,
                          $9FF9,$8FF1,$C003,$E007);
            CursorMask : ($0C00,$1200,$1200,$1200,
                          $1200,$13B6,$1249,$7249,
                          $9249,$9001,$9001,$8001,
                          $4002,$4002,$2004,$1FF8);
            HotX : $0004;
            HotY : $0000);

     IBEAM : GCursor =       {Your normal text entering I shaped cursor}
           (ScreenMask : ($F3FF,$E1FF,$E1FF,$E1FF,
                          $E1FF,$E049,$E000,$8000,
                          $0000,$0000,$07FC,$07F8,
                          $9FF9,$8FF1,$C003,$E007);
            CursorMask : ($0C30,$0240,$0180,$0180,
                          $0180,$0180,$0180,$0180,
                          $0180,$0180,$0180,$0180,
                          $0180,$0180,$0240,$0C30);
            HotX : $0007;
            HotY : $0007);

      KKG : GCursor =     {KKG symbol, a little sorority stuff}
        (ScreenMask : ($FFFF,$1040,$1040,$0000,
                       $0000,$0000,$0411,$0411,
                       $0001,$0001,$0001,$1041,
                       $1041,$1041,$FFFF,$FFFF );
         CursorMask : ($0000,$0000,$4517,$4515,
                       $4925,$5144,$6184,$6184,
                       $5144,$4924,$4514,$4514,
                       $4514,$0000,$0000,$0000 );
         HotX : $0007;
         HotY : $0005);

      SMILEY : GCursor =  {a Smiley face for you!}
        (ScreenMask : ($C003,$8001,$07E0,$0000,
                       $0000,$0000,$0000,$0000,
                       $0000,$0000,$0000,$8001,
                       $C003,$C003,$E007,$F81F );
         CursorMask : ($0FF0,$1008,$2004,$4002,
                       $4E72,$4A52,$4E72,$4002,
                       $4992,$581A,$2424,$13C8,
                       $1008,$0C30,$03C0,$0000 );
         HotX : $0007;
         HotY : $0005);

      XOUT : GCursor =    {a BIG X marks the spot}
        (ScreenMask : ($1FF8,$0FF0,$07E0,$03C0,
                       $8181,$C003,$E007,$F00F,
                       $F81F,$F00F,$E007,$C003,
                       $8181,$03C0,$07E0,$0FF0 );
         CursorMask : ($8001,$C003,$6006,$300C,
                       $1818,$0C30,$0660,$03C0,
                       $0180,$03C0,$0660,$0C30,
                       $1818,$300C,$6006,$C003 );
         HotX : $0007;
         HotY : $0008);

      SWORD : GCursor =   {For the D&D buffs...}
        (ScreenMask : ($F83F,$F83F,$F83F,$F83F,
                       $F83F,$F83F,$F83F,$F83F,
                       $8003,$8003,$8003,$8003,
                       $8003,$F83F,$F01F,$F01F );
         CursorMask : ($0100,$0380,$0380,$0380,
                       $0380,$0380,$0380,$0380,
                       $0380,$3398,$3398,$3FF8,
                       $0380,$0380,$0380,$07C0 );
         HotX : $0007;
         HotY : $0000);


{*************************************************************************}

Implementation

{*************************************************************************}

BEGIN
END.

