{ test program for displaying and writing PCX file }
{ using standard 256 color VGA mode, 13h; 320x200 }
{ use READ13H.PAS to display new written file results}
uses Crt, graph, uBGI256, uPcxVga, uPal, uVga;

const
	fPcxIn  = 'COLOR256.PCX';
	fPcxOut = 'TEST256.PCX';
  XLoc = 0;
  YLoc = 0;

var
	Adapter: PVga;
	MaxVesaMode: integer;
	PicW, PicH: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
begin
	LoadPCX := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vga, Init(fPcxIn, Adapter));
	if pcx <> nil then
	begin
		pcx^.Decode(ToRam);
		if PcxError = PcxError0 then
		begin
			PicW := pcx^.GetMxX;
			PicH := pcx^.GetMxY;
			pcx^.Set_Palette;
			pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0, 0, PicW, PicH)));
			Dispose(pcx, Done);
		end;
	end
	else Exit;
	LoadPCX := 1;
end;

procedure SavePcx;
var
	pcx: PPcxEncoder_Vga;
begin
	pcx := nil;
	Pcx := New(PPcxEncoder_Vga, Init(fPcxOut, Adapter));
	if Assigned(Pcx) then
	begin
		Pcx^.Save(New(PWin, Init(XLoc, YLoc, XLoc+PicW, YLoc+PicH)));
		Dispose(Pcx, Done);
	end;
end;

begin
	writeln('Display PCX file in VGA mode 13h.');
	writeln('Please wait approx 30 secs while picture is being test written to new file.');
	writeln('After completing, run READ13H to view newly written PCX file.');
	writeln('press any key to proceed...');
	pause;
	Adapter := New(PVga, Init);
	if Adapter = nil then Halt(0); {no VESA TSR loaded}
	if InitBGI_BGI256 = 0 then Halt(0);
	SetGraphMode(Mode200);
	Adapter^.UpdateVga;
	SetTextStyle(SmallFont, HorizDir, 4);
	if LoadPcx = 0 then
	begin
		OutTextxy(10,15, 'PCX file: ' + fPCXIn + ' not found.');
		Pause;
		Halt(0);
	end;
	SavePcx;
	Dispose(Adapter, Done);
	Closegraph;
end.
