{ test program for displaying and writing PCX file }
{ using standard 16 color VGA mode, 12h; 640x480 }
{ use READ12H.PAS to display new written file results}
uses Crt, graph, uBGI, uPcxVga, uPal, uVga;

const
	fPcxIn  = 'COLOR16.PCX';
	fPcxOut = 'TEST16.PCX';
	XLoc = 0;
	YLoc = 0;

var
	Adapter: PVga;
	PicW, PicH: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
begin
	LoadPCX := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vga, Init(fPcxIn, Adapter));
	if pcx <> nil then
	begin
		pcx^.Decode(ToRam);
		if PcxError = PcxError0 then
		begin
			PicW := pcx^.GetMxX;
			PicH := pcx^.GetMxY;
			pcx^.Set_Palette;
			pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0, 0, PicW, PicH)));
			Dispose(pcx, Done);
		end;
	end
	else Exit;
	LoadPCX := 1;
end;

procedure SavePcx;
var
	pcx: PPcxEncoder_Vga;
begin
	pcx := nil;
	Pcx := New(PPcxEncoder_Vga, Init(fPcxOut, Adapter));
	if Assigned(Pcx) then
	begin
		Pcx^.Save(New(PWin, Init(XLoc, YLoc, XLoc+PicW, YLoc+PicH)));
		Dispose(Pcx, Done);
	end;
end;

begin
	Adapter := New(PVga, Init);
	if Adapter = nil then Halt(0); {no VESA TSR loaded}
	if InitBGI = 0 then Halt(0);
	Adapter^.UpdateVga;
	SetTextStyle(SmallFont, HorizDir, 4);
	if LoadPcx = 0 then
	begin
		OutTextxy(10,15, 'PCX file: ' + fPCXIn + ' not found.');
		Pause;
		Halt(0);
	end;
	SetColor(White);
	OutTextxy(10, 260, 'Press any key ...');
	Pause;
	OutTextxy(10, 280, 'Writing PCX file: ' + fPCXOut);
	OutTextxy(10, 300, 'please wait ...');
	SavePcx;
	Dispose(Adapter, Done);
	Closegraph;
end.
