{ test program for displaying PCX file written by WRITEVSA.PAS}
{ using VESA 256 color mode, upto 1024x768 }
{ use WRITEVSA.PAS prior to running this program }
{ You can replace const: fPcxIn with any PCX file to decode to VESA mode }
uses Crt, graph, uBGI256, uPcxVga, uVesa, uPal;

const
	fPcxIn  = 'TESTVESA.PCX';
	XLoc = 0;
	YLoc = 0;

var
	Adapter: PVesa;
	MaxMode: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
	PicW, PicH: integer;
begin
	LoadPcx := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vesa, Init(fPcxIn, Adapter));
  if not (pcx = nil) then
  begin
    pcx^.Decode(ToRam);
    if PcxError = PcxError0 then
		begin
    	PicW := pcx^.GetMxX;
    	PicH := pcx^.GetMxY;
      pcx^.Set_Palette;
	    pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0,0,PicW,PicH)));
      Dispose(pcx, Done);
    end;
	end
	else Exit;
	LoadPcx := 1;
end;

begin
	Adapter := New(PVesa, Init);
	if Adapter = nil then Halt(0); {no VESA TSR loaded}
	if InitBGI_BGI256 = 0 then Halt(0);
	MaxMode := GetMaxMode;
	SetGraphMode(MaxMode);
	{IMPORTANT! Sync Adapter object to BGI256 driver}
	{The BGI256 driver has one non-Vesa mode, 0 = 320x200 13h}
	Adapter^.SetVesaMode(Vesa_Modes[Equate_VesaMode(MaxMode)]);
	if LoadPcx = 0 then
	begin
		Dispose(Adapter, Done);
		Halt(0);
	end;
	{make sure color 255 is white}
	Adapter^.SetColor(255,255,255,255);
	SetColor(255);
	SetTextStyle(SmallFont, HorizDir, 6);
	OutTextxy(10, 260, 'Press any key ...');
  Pause;
	Dispose(Adapter, Done);
end.
