{ test program for displaying PCX file written by WRITE12H.PAS}
{ using standard 16 color VGA mode, 12h; 640x480 }
{ use WRITE12H.PAS prior to running this program }
{ You can replace const: fPcxIn with any PCX file to decode to mode 12h }
uses Crt, graph, uBGI, uPcxVga, uVga, uPal;

const
	fPcxIn  = 'TEST16.PCX';
	XLoc = 0;
	YLoc = 0;

var
	Adapter: PVga;
	MaxMode: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
	PicW, PicH: integer;
begin
	LoadPcx := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vga, Init(fPcxIn, Adapter));
  if not (pcx = nil) then
  begin
		pcx^.Decode(ToRam);
    if PcxError = PcxError0 then
		begin
    	PicW := pcx^.GetMxX;
    	PicH := pcx^.GetMxY;
      pcx^.Set_Palette;
	    pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0,0,PicW,PicH)));
      Dispose(pcx, Done);
    end;
	end
	else Exit;
	LoadPcx := 1;
end;

begin
	Adapter := New(PVga, Init);
	if Adapter = nil then Halt(0);
	if InitBGI = 0 then Halt(0);
	Adapter^.UpdateVGA;
	if LoadPcx = 0 then
	begin
		Dispose(Adapter, Done);
		Halt(0);
	end;
	SetTextStyle(SmallFont, HorizDir, 6);
	OutTextxy(10, 260, 'Press any key ...');
  Pause;
	Dispose(Adapter, Done);
end.
