{ Sample program for TPPCX-VGA256 }
{ Copyright 1992, Mark D. Rafn, MDRUtils (tm) }
program PALPLAY;
uses uVesa, graph, crt, uVGA, uPal, uPcxVGA, uBgi256;

var
  Status: word;
  Rows: integer;
  Color: integer;
  x, y: integer;
  r,g,b: integer;
  BarW, BarH, TxtX, TxtY: integer;
	MaxVesaMode, VGAStatus: integer;
  Dac16: aDac_16;
  Rown, Rownx: string;
	Adapter: PVga;         { VGA object }

procedure Pause;
begin
  repeat until keypressed;
  MemW[ $0000:$041C ] := MemW[ $0000:$041A ];
end;

procedure EraseText;
var
  WinWidth: integer;
  bx1,bx2,by1,by2: integer;
begin
  SetFillStyle(SolidFill,Black);
	WinWidth := (Adapter^.StateInfo.NoCharCols * 8) - 1;
  bx1 := 0;
  by1 := TxtY;
  bx2 := WinWidth;
	by2 := TxtY + TextHeight('Mg');
  Bar(bx1,by1,bx2,by2);
end;

procedure WriteOut(S : string);
begin
  EraseText;
	Adapter^.SetColor(255,63,63,63);
	Color := 255;
  SetColor(Color);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(LeftText,TopText);
  OutTextXY(Txtx, Txty, S);
end; { WriteOut }

procedure DoBars;
var
  i,j: integer;
begin
  SetColor(DarkGray);
  x := 0;
  y := 0;
  for i := 0 to 15 do
  begin
    x := 0;
		for j := 0 to 15 do
    begin
      SetFillStyle(SolidFill, (i * 16)+j);
			Bar(x, y, x + BarW, y + BarH);
      Rectangle(x, y, x + BarW, y + BarH);
      x := x + BarW + 5;
    end;
    y := y + BarH + 5;
  end;
  x := 0;
	WriteOut('Default VGA palette (color #255 will be reset for text.)');
	Adapter^.SavePalette;
  Pause;
end;

procedure CycleBGI;
begin
	for Rows := 0 to 15 do
	begin
    Str(Rows * 16, Rown);
		Str((Rows * 16 + 15), Rownx);
    WriteOut('Cycling BGI 16 color palette by rows, color '+ Rown +' to color '+ Rownx);
		Adapter^.ReadColorBlock(Rows * 16, 16, @Dac16);
		Adapter^.SetColorBlock(Rows * 16, 16, @Dac16_BGI);
    Pause;
		Adapter^.SetColorBlock(Rows * 16, 16, @Dac16);
  end;
end;

procedure GrayScale;
begin
  WriteOut('Summing colors to gray scale');
	Adapter^.SumToGray(0, 256);
	pause;
end;

procedure Rows_Default;
begin
  WriteOut('Resetting each row to default setting');
  for Rows := 0 to 15 do
	begin
		Adapter^.ResetPalette(Rows * 16, 16);
    pause;
  end;
end;

procedure UserBlocks;
begin
  WriteOut('Setting user described blocks x 16 - Red Yellow scale');
	Adapter^.SetColorBlock(1*16, 16, @Dac16_Red);
  pause;
  WriteOut('Setting user described blocks x 16 - Green Cyan scale');
	Adapter^.SetColorBlock(2*16, 16, @Dac16_Green);
	pause;
	WriteOut('Setting user described blocks x 16 - Blue Magenta scale');
	Adapter^.SetColorBlock(3*16, 16, @Dac16_Blue);
  pause;
end;

procedure ResetAll;
begin
  WriteOut('Resetting complete palette to default');
	Adapter^.ResetPalette(0, 256);
  pause;
end;

procedure Set4Color;
var
  Number: integer;
  i: integer;
begin
  Number := 0;
  for i := 0 to 63 do
  begin
		Adapter^.SetColor(Number,i,i,i);
    Inc(Number);
  end;
  for i := 0 to 63 do
	begin
		Adapter^.SetColor(Number,i,0,0);
		Inc(Number);
  end;
  for i := 0 to 63 do
  begin
		Adapter^.SetColor(Number,0,i,0);
    Inc(Number);
  end;
  for i := 0 to 63 do
  begin
		Adapter^.SetColor(Number,0,0,i);
    Inc(Number);
  end;
  WriteOut('Setting individual colors to primary gradients.');
	Pause;
end;

procedure FadeIt;
var
	TempPal: aDac_256;
begin
	Adapter^.ReadColorBlock(0, 256, @TempPal);
	_fadePalout(0, 256);
	delay(150);
	_fadePalin(0, 256, @TempPal);
	delay(1500);
end;


begin
	if not Vga_Detect then Halt;
	Adapter := New(PVesa, Init);
	{ is VESA present? }
	if Adapter <> nil then
	begin
		{ VESA is present }
		if InitBGI_BGI256 = 0 then Halt(0);
		MaxVesaMode := GetMaxMode;
		SetGraphMode(MaxVesaMode);
		PVesa(Adapter)^.SetVesaMode(Vesa_Modes[Equate_VesaMode(MaxVesaMode)]);
	end
	else
	begin
		Adapter := New(PVga, Init);
		{Initialize graphics}
		InitBGI_BGI256;
		Adapter^.UpdateVGA;
	end;
  BarH := (Adapter^.GetMaxY div 17) - 5;
	BarW := BarH;
	TxtY := ((BarH + 5) * 16);
	TxtX := 0;

  Dobars;
	CycleBGI;
	GrayScale;
	Rows_Default;
	GrayScale;
	UserBlocks;
	Set4Color;
	ResetAll;
	FadeIt;
end.
