{ test program for displaying and writing PCX file }
{ using VESA 256 color VGA mode upto 1024x768 }
{ use READVESA.PAS to display new written file results}
uses Crt, graph, uBGI256, uPcxVga, uVesa, uPal;

const
	fPcxIn  = 'COLOR256.PCX';
	fPcxOut = 'TESTVESA.PCX';
  XLoc = 0;
  YLoc = 0;

var
  Adapter: PVesa;
	MaxMode: integer;
	PicW, PicH: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
begin
	LoadPCX := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vesa, Init(fPcxIn, Adapter));
	if pcx <> nil then
	begin
		pcx^.Decode(ToRam);
		if PcxError = PcxError0 then
		begin
			PicW := pcx^.GetMxX;
			PicH := pcx^.GetMxY;
			pcx^.Set_Palette;
			pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0, 0, PicW, PicH)));
			Dispose(pcx, Done);
		end;
	end
	else Exit;
	LoadPCX := 1;
end;

procedure SavePcx;
var
	pcx: PPcxEncoder_Vga;
begin
	pcx := nil;
	Pcx := New(PPcxEncoder_Vesa, Init(fPcxOut, Adapter));
	if Assigned(Pcx) then
	begin
		Pcx^.Save(New(PWin, Init(XLoc, YLoc, XLoc+PicW, YLoc+PicH)));
		Dispose(Pcx, Done);
	end;
end;

begin
	Adapter := New(PVesa, Init);
	if Adapter = nil then Halt(0); {no VESA TSR loaded}
	if InitBGI_BGI256 = 0 then Halt(0);
	MaxMode := GetMaxMode;
	SetGraphMode(MaxMode);
	{IMPORTANT! Sync Adapter object to BGI256 driver}
	{The BGI256 driver has one non-Vesa mode, 0 = 320x200 13h}
	Adapter^.SetVesaMode(Vesa_Modes[Equate_VesaMode(MaxMode)]);
	SetTextStyle(SmallFont, HorizDir, 6);
	if LoadPcx = 0 then
	begin
		OutTextxy(10,15, 'PCX file: ' + fPCXIn + ' not found.');
		Pause;
		Halt(0);
	end;
	{make sure color 255 is white}
	Adapter^.SetColor(255,255,255,255);
	SetColor(255);
	OutTextxy(10, 260, 'Press any key ...');
	Pause;
	OutTextxy(10, 280, 'Writing PCX file: ' + fPCXOut);
	OutTextxy(10, 300, 'please wait ...');
	SavePcx;
	Dispose(Adapter, Done);
	Closegraph;
end.
