Unit BPstr;

{	Kestrel Technologies toolbox version 1.0.0. }

{	Version 1.1.0.P
	Created Monday, October 24, 1994.

	Requires Kestrel Technologies toolbox version 1.0.0 or later.

	Requires Borland Turbo Pascal version 6.0 or later to compile.

	Author:  Bruce J. Lackore of Kestrel Technologies.  
	Copyright (c) 1994 Bruce J. Lackore.  ALL RIGHTS RESERVED.
}

{$IFDEF Test}
	{$A+,B-,D+,F+,G-,I+,L+,O+,R+,S+,V-,X+}
{$ELSE}
	{$A+,B-,D-,F+,G-,I-,L-,O+,R-,S-,V-,X+}
{$ENDIF}

{	This unit provides all necessary standard Pascal string manipulations along
	with a few odds and ends.
}

Interface

Function Up_cs(In_str:  String):  String;

{	This function converts In_str to all upper case characters.
}

Function Cnt_ch(Scan_char:  Char;  In_str:  String):  Byte;

{	This function will scan a string for occurences of a particular character.
	The function will return the number of occurences.
}

Function Last_Cpos(Srch_ch:  Char;  Src_str:  String):  Byte;

{	This function performs the same function as the Pascal POS function except
	that rather than returning the position of the first character found, it
	returns the LAST position that the search character is found in.
}

Function CPos(Srch_ch:  Char;  Src_str:  String):  Byte;

{	This function is similar to the Pos function of Pascal except that it
	accepts only a single character to search for and uses a very fast Asm
	routine to do the searching.  This function returns the position of the
	first encountered Srch_ch or 0 if none are found.
}

Function Next_CPos(Srch_ch:  Char;  Src_str:  String;  Strt_at:  Byte):  Byte;

{	This function is exactly like the CPos function except that it starts its
	search at Strt_at and works toward the back of the Src_str.  The value
	returned is the absolute location of the next encountered Srch_ch NOT the
	relative offset from Strt_at.  The function returns a 0 if no Srch_ch was
	found.
}

Function PosC(Srch_ch:  Char;  Src_str:  String):  Boolean;

{	This function is similar to the Pos function of Pascal except that it
	accepts only a single character to search for and uses a very fast Asm
	routine to do the searching.  This function returns a True if a Srch_ch is
	encountered, a False if not.
}

Function Fill_str(Dupe_ch:  Char;  How_many:  Byte):  String;

{	This function returns How_many of Dupe_char.  Thanx to Neil J. Rubenking
	for this routine from "Turbo Pascal 6.0 Techniques and Utilities".

}

{ ************************************************************************** }

Implementation

Function Up_cs;

	Begin{ Function Up_cs }
		Asm
							CLD
							LEA		SI,In_str
							LES		DI,@Result
							SEGSS	LODSB
							STOSB
							XOR		AH,AH
							XCHG	AX,CX
							JCXZ	@END
			@DOIT:	SEGSS	LODSB
							CMP		AL,'a'
							JB		@NXTCH
							CMP		AL,'z'
							JA		@NXTCH
							SUB		AL,20H
			@NXTCH:	STOSB
							LOOP	@DOIT
			@END:
  	End  { Asm }
	End;  { Function Up_cs }

Function Cnt_ch;  Assembler;

	Asm  { Function Cnt_ch }
							XOR		AX,AX					{	0 AX }
							MOV		BL,Scan_char  {	Put char to count in BL }
							LES		SI,In_str     {	Set ES:SI to point to start of string }
							XOR		CX,CX         {	0 CX }
							MOV		CL,[ES:SI]    {	Move string length to CX }
							ADD		SI,CX         {	Set ES:SI to point to END of string }
		@LOOK:		CMP		BL,[ES:SI]    {	Start Loop, compare current char and BL }
							JNE		@NEXT         {	If not equal, jump to end of loop }
							INC		AX            { If equal, Inc char cnt (AX) }
		@NEXT:		DEC		SI            {	Set ES:SI back one character }
							LOOP	@LOOK         {	Decrement CX and jump to start of loop }
	End;  { Function Cnt_ch }

Function Fill_str;  Assembler;

	Asm  { Function Fill_str }
							LES		DI,@Result		{	Set ES:DI to function result area }
							CLD                 {	Clear direction flag }
							XOR 	CH,CH         {	0 CH }
							MOV 	CL,How_many  	{ Length in CX }
							MOV 	AX,CX        	{ and in AX }
							STOSB             	{ Store length byte }
							MOV 	AL,Dupe_ch    {	Put char to dupe in AL }
							REP 	STOSB         { Fill string with char }
	End;  { Function Fill_str }

Function Last_Cpos;  Assembler;

	Asm { Function Last_Cpos }
							MOV		AL,Srch_ch		{	Put char to look for in AL }
							LES		DI,Src_str    {	Set ES:DI to start of Src_str }
							XOR		CX,CX         {	0 CX }
							MOV		CL,[ES:DI]    {	Move length of Src_str to CL }
							ADD		DI,CX         {	Set ES:DI to end of Src_str }
							INC		CX            { Add one to CX (correct for string length }
							STD                 {	Set direction flag }
							REPNZ	SCASB         {	Look for character in string }
							MOV		AX,CX         { If found CX indicates position, else 0 }
	End;  { Function Last_Cpos }

Function CPos;  Assembler;

	Asm  { Function CPos }
							MOV		AL,Srch_ch
							LES		DI,Src_str
							XOR		CX,CX
							MOV		CL,[ES:DI]
							INC		DI
							MOV		BX,CX
							CLD
							REPNZ	SCASB
							JNZ		@NOTFND
							SUB		BX,CX
							JMP		@DONE
		@NOTFND:	XOR		BX,BX
		@DONE:		MOV		AX,BX
	End;  { Function CPos }

Function Next_CPos;  Assembler;

	Asm  { Function Next_CPos }
							XOR		AX,AX         {	0 AX }
							MOV		AL,Strt_at    {	Move position to start at to AL }
							LES		DI,Src_str    {	Set ES:DI to start of Src_str }
							XOR		CX,CX         {	0 CX }
							MOV		CL,[ES:DI]    {	Store length of Src_str in CL }
							INC		DI            {	Set ES:DI to first char of Src_str }
							MOV		BX,CX         {	Move CX to BX }
							SUB		CX,AX         {	Set CX to length of string after Strt_at }
							ADD		DI,AX         {	Set ES:DI to char at Strt_at in Src_str }
							MOV		AL,Srch_ch    {	Move Srch_ch to AL }
							CLD                 {	Clear direction flag }
							REPNZ	SCASB         {	Look for character following Strt_at }
							JNZ		@NOTFND       {	If not found, jump to end of procedure }
							SUB		BX,CX         {	Set BX to position char found in }
							JMP		@DONE         {	Jump to end of procedure }
		@NOTFND:	XOR		BX,BX         {	Srch_ch not found, set BX to 0 }
		@DONE:		MOV		AX,BX         {	Move position found at (BX) to AX }
	End;  { Function Next_CPos }

Function PosC;  Assembler;

	Asm  { Function PosC }
							XOR		BX,BX					{	0 BX }
							MOV		AL,Srch_ch    {	Put char to look for in AL }
							LES		DI,Src_str    {	Set ES:DI to start of Src_str }
							XOR		CX,CX         {	0 CX }
							MOV		CL,[ES:DI]    {	Store length of Src_str in CL }
							ADD		DI,CX         {	Set ES:DI to end of string }
							STD                 {	Set direction flag }
		@LOOK:		REPNZ	SCASB         {	Look for AL in Src_str }
							JNZ		@DONE         {	If not found, jump to end (BX = 0) }
							INC		BX            {	If Found, Inc Bx  to 1 = Pascal True }
		@DONE:		MOV		AX,BX         {	Move BX to AX (return result) }
	End;  { Function PosC }

End.  { Unit BPstr }