(* ====================================================== *)
(*                        PMSPL.PAS                       *)
(*     Implementation of the functions of PMSPL.DLL       *)
(*                 Printer-/spooler functions             *)
(*          Translation to Pascal by jb/toolbox mag       *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT PMSPL;

INTERFACE

USES
  Os2Def;

CONST
  SPL_INI_SPOOLER       = 'PM_SPOOLER';
  SPL_INI_QUEUE         = 'PM_SPOOLER_QUEUE';
  SPL_INI_PRINTER       = 'PM_SPOOLER_PRINTER';
  SPL_INI_PRINTERDESCR  = 'PM_SPOOLER_PRINTER_DESCR';
  SPL_INI_QUEUEDESCR    = 'PM_SPOOLER_QUEUE_DESCR';
  SPL_INI_QUEUEDD       = 'PM_SPOOLER_QUEUE_DD';
  SPL_INI_QUEUEDDDATA   = 'PM_SPOOLER_QUEUE_DDDATA';

(*** General SPL return values ****************************)
CONST
  SPL_ERROR   =  $00000000;
  SPL_OK      =  $00000001;

(*** handle to a spool file *******************************)
TYPE
  hSpl = LHandle;               (* hspl *)

(* Used in recording of PM_Q_STD data via SplStdxxx calls *)
  hStd        = LHandle ;               (* hstd *)
  pHstd       = ^hStd;

(*** spooler manager open data ****************************)
  PQMOPENDATA =^pChar;       (* pqmdop *)


(*** Spooler Queue Processor interface ********************)

   (* control codes for SplQpControl *)
CONST
  SPLC_ABORT     = 1;
  SPLC_PAUSE     = 2;
  SPLC_CONTINUE  = 3;

(* flag defines for optional SplQpQueryFlags              *)
(* set this to allow spooler to bypass Queue Processor    *)
(* for PM_Q_RAW jobs.  This allows print while a job      *)
(* is still spooling.                                     *)
  QP_RAWDATA_BYPASS = $00000001;

(*** handle to a spooler queue processor ******************)
TYPE
   hProc = LHandle;              (* hproc *)

(*** spooler processor open data **************************)
   PQPOPENDATA = ^pChar;          (* pqpdop *)

(*** Spooler Queue Processor interface ********************)
(* API's exported by Queue Processor DLL's                *)

{                 NOT YET IMPLEMENTED !!!!!!!

FUNCTION SplQpOpen(cData     : LongInt;
                   pQPDataIn : PQPOPENDATA ): HProc;

FUNCTION SplQpPrint(aHProc: hProc; pszFileName: PSZ): BOOL;

FUNCTION SplQpClose(aHProc: hProc): BOOL;

FUNCTION SplQpControl(aHProc : hProc;
                      cmdCode: LongInt): BOOL;

FUNCTION SplQpQueryDt(pcDataType   : pLong;
                      paszDataTypes: pPSZ): BOOL;

FUNCTION SplQpInstall(aHWnd: HWnd): BOOL;

(* The next API is optionally exported by Queue           *)
(* Processors. The flags may be set to                    *)
(* QP_RAWDATA_BYPASS to allow the spooler to print the    *)
(* job while spooling, bypassing this queue processor     *)

FUNCTION SplQpQueryFlags(pulFlags: pULONG): BOOL;

 (*******************************************************)
 (* There are two definitions governing the QpOpen data *)
 (* block :-                                            *)
 (* 1) the original  QPOPENDATA, which is used as       *)
 (*    an array of PSZ and has a list of associated     *)
 (*    QPDAT defines for accessing elements of the      *)
 (*    array. This has been extended from 6 to 12       *)
 (*    elements. The last element is a numeric type     *)
 (*    and cannot satisfactorily be accessed via array  *)
 (*    indexing.                                        *)
 (*                                                     *)
 (* 2) a new SQPOPENDATA structure (see below)          *)
 (*                                                     *)
 (* The old defn has been retained to support existing  *)
 (* QProcs.                                             *)
 (*                                                     *)
 (*******************************************************)
------ }

(*** Definition for elements within the PQPOPENDATA block *)
CONST
  QPDAT_ADDRESS     =  0;
  QPDAT_DRIVER_NAME =  1;
  QPDAT_DRIVER_DATA =  2;
  QPDAT_DATA_TYPE   =  3;
  QPDAT_COMMENT     =  4;
  QPDAT_PROC_PARAMS =  5;
  QPDAT_SPL_PARAMS  =  6;     (* SplQmOpen Spooler params *)
  QPDAT_NET_PARAMS  =  7;     (* SplQmOpen Network params *)
  QPDAT_DOC_NAME    =  8;     (* SplQmStartDoc name       *)
  QPDAT_QUEUE_NAME  =  9;     (* Queue name for job       *)
  QPDAT_TOKEN       = 10;     (* SplQmOpen token name     *)
  QPDAT_JOBID       = 11;     (* SQM job identity         *)

TYPE
  SQPOPENDATA = RECORD          (* SplQpOpenData *)
    pszLogAddress    : pChar;
    pszDriverName    : pChar ;
    pdriv            : pDrivData ;
    pszDataType      : pChar ;
    pszComment       : pChar ;
    pszProcParams    : pChar ;
    pszSpoolParams   : pChar ;
    pszNetworkParams : pChar ;
    pszDocName       : pChar ;
    pszQueueName     : pChar ;
    pszToken         : pChar ;
    idJobId          : WORD;
  END;
  pSQPOpenData = ^SQPOPENDATA;


(**********************************************************)
(** Error information and return codes                    *)
(**********************************************************)

(* Error information for SplMessageBox *)
CONST
  SPLINFO_QPERROR       = $0001;
  SPLINFO_DDERROR       = $0002;
  SPLINFO_SPLERROR      = $0004;
  SPLINFO_OTHERERROR    = $0080;
  SPLINFO_INFORMATION   = $0100;
  SPLINFO_WARNING       = $0200;
  SPLINFO_ERROR         = $0400;
  SPLINFO_SEVERE        = $0800;
  SPLINFO_USERINTREQD   = $1000;

(* Error Data for SplMessageBox *)
CONST
  SPLDATA_PRINTERJAM    = $0001;
  SPLDATA_FORMCHGREQD   = $0002;
  SPLDATA_CARTCHGREQD   = $0004;
  SPLDATA_PENCHGREQD    = $0008;
  SPLDATA_DATAERROR     = $0010;
  SPLDATA_UNEXPECTERROR = $0020;
  SPLDATA_OTHER         = $8000;

(* return code for fSplStdQueryLength *)
  SSQL_ERROR = -00000001;

(* #ifdef INCL_SPLERRORS
      #include <pmerr.h>
   #endif /* INCL_SPLERRORS */
*)

TYPE
  SplErr = LongInt;


(* length for character arrays in structs (excluding zero terminator) *)
CONST
  CNLEN                = 15; (* Computer name length      *)
  UNLEN                = 20; (* Maximum user name length  *)
  QNLEN                = 12; (* Queue name maximum length *)
  PDLEN                =  8; (* Print destination length  *)
  DTLEN                =  9; (* Spool file data type      *)
  (* e.g. PM_Q_STD,PM_Q_RAW    *)
  QP_DATATYPE_SIZE     = 15; (* returned by SplQpQueryDt  *)
  DRIV_DEVICENAME_SIZE = 31; (* see DRIVDATA struc        *)
  DRIV_NAME_SIZE       =  8; (* name of device driver     *)
  PRINTERNAME_SIZE     = 32; (* max printer name length   *)
  FORMNAME_SIZE        = 31; (* max form name length      *)
  MAXCOMMENTSZ         = 48; (* queue comment length      *)

TYPE
  DrivProps  = RECORD    (* dprop *)
     pszKeyName : pChar;
     cbBuf      : LongInt;
     pBuf       : pVoid;
  END;
  pDrivProps  = ^DrivProps;
  npDrivProps = ^DrivProps;

  PrjInfo  = RECORD    (* prj1 *)
    uJobId                : WORD;
    szUserName            : ARRAY[0..UNLEN+1] OF CHAR;
    pad_1                 : CHAR;
    szNotifyName          : ARRAY[0..CNLEN+1] OF CHAR;
    szDataType            : ARRAY[0..DTLEN+1] OF CHAR;
    pszParms              : pChar;
    uPosition             : WORD;
    fsStatus              : WORD;
    pszStatus             : pChar;
    ulSubmitted           : LongInt;
    ulSize                : LongInt;
    pszComment            : pChar;
  END;
  pPrjInfo  = ^PrjInfo;
  npPrjInfo = ^PrjInfo;

  PrjInfo2 = RECORD     (* prj2 *)
    uJobId       : WORD;
    uPriority    : WORD;
    pszUserName  : pChar;
    uPosition    : WORD;
    fsStatus     : WORD;
    ulSubmitted  : LongInt;
    ulSize       : LongInt;
    pszComment   : pChar;
    pszDocument  : pChar;
  END;
  pPrjInfo2 = ^PrjInfo2;
  npPrjInfo2= ^PrjInfo2;

  PrjInfo3 = RECORD     (* prj *)
    uJobId          : WORD;
    uPriority       : WORD;
    pszUserName     : pChar;
    uPosition       : WORD;
    fsStatus        : WORD;
    ulSubmitted     : LongInt;
    ulSize          : LongInt;
    pszComment      : pChar;
    pszDocument     : pChar;
    pszNotifyName   : pChar;
    pszDataType     : pChar;
    pszParms        : pChar;
    pszStatus       : pChar;
    pszQueue        : pChar;
    pszQProcName    : pChar;
    pszQProcParms   : pChar;
    pszDriverName   : pChar;
    pDriverData     : pDrivData ;
    pszPrinterName  : pChar;
  END;
  pPrjInfo3  = ^PrjInfo3;
  npPrjInfo3 = ^PrjInfo3;

  PrdInfo = RECORD       (* prd1 *)
    szName        : ARRAY [0..PDLEN+1] OF CHAR;
    szUserName    : ARRAY [0..UNLEN+1] OF CHAR;
    uJobId        : WORD;
    fsStatus      : WORD;
    pszStatus     : pChar;
    time          : WORD;
  END;
  pPrdInfo    = ^PrdInfo;
  npPrdInfo   = ^PrdInfo;
      
  PrdInfo3  = RECORD    (* prd *)
    pszPrinterName : pChar;
    pszUserName    : pChar;
    pszLogAddr     : pChar;
    uJobId         : WORD;
    fsStatus       : WORD;
    pszStatus      : pChar;
    pszComment     : pChar;
    pszDrivers     : pChar;
    time           : WORD;
    usTimeOut      : WORD;
  END;
  pPrdInfo3  = ^PrdInfo3;
  npPrdInfo3 = ^PrdInfo3;

  PrqInfo = RECORD     (* prq1 *)
    szName          : ARRAY [0..QNLEN+1] OF CHAR;
    pad_1           : CHAR;
    uPriority       : WORD;
    uStartTime      : WORD;
    uUntilTime      : WORD;
    pszSepFile      : pChar;
    pszPrProc       : pChar;
    pszDestinations : pChar;
    pszParms        : pChar;
    pszComment      : pChar;
    fsStatus        : WORD;
    cJobs           : WORD;
  END;
  pPrqInfo    = ^PrqInfo;
  npPrqInfo   = ^PrqInfo;
      
  PrqInfo3    = RECORD (* prq *)
    pszName      : pChar;
    uPriority    : WORD;
    uStartTime   : WORD;
    uUntilTime   : WORD;
    fsType       : WORD;
    pszSepFile   : pChar;
    pszPrProc    : pChar ;
    pszParms     : pChar;
    pszComment   : pChar;
    fsStatus     : WORD;
    cJobs        : WORD;
    pszPrinters  : pChar;
    pszDriverName: pChar;
    pDriverData  : pDrivData;
  END;
  pPrqInfo3    = ^PrqInfo3;
  npPrqInfo3   = ^PrqInfo3;
      
  PrqInfo6 = RECORD    (* prq6 *)
    pszName               : pChar;
    uPriority             : WORD;
    uStartTime            : WORD;
    uUntilTime            : WORD;
    fsType                : WORD;
    pszSepFile            : pChar;
    pszPrProc             : pChar;
    pszParms              : pChar;
    pszComment            : pChar;
    fsStatus              : WORD;
    cJobs                 : WORD;
    pszPrinters           : pChar;
    pszDriverName         : pChar;
    pDriverData           : pDrivData ;
    pszRemoteComputerName : pChar;
    pszRemoteQueueName    : pChar;
  END;
  pPrqInfo6  = ^PrqInfo6;
  npPrqInfo6 = ^PrqInfo6;

(** structure for DosPrintJobGetId *)
  PridInfo  = RECORD   (* prjid *)
    uJobId         : WORD;
    szComputerName : ARRAY [0..CNLEN + 1] OF CHAR;
    szQueueName    : ARRAY [0..QNLEN + 1] OF CHAR;
    pad_1          : CHAR;
  END;
  pPridInfo  = ^PridInfo;
  npPridInfo = ^PridInfo;

(** structure for DosPrintDriverEnum *)
  PrDrivInfo = RECORD  (* prdid *)
    szDrivName: ARRAY[0..DRIV_NAME_SIZE + 1 +
                         DRIV_DEVICENAME_SIZE + 1] OF CHAR;
  END;
  pPrDrivInfo  = ^PrDrivInfo;
  npPrDrivInfo = ^PrDrivInfo;

(** structure for DosPrintQProcessorEnum *)
  PrqProcInfo  = RECORD   (* prqp *)
    szQProcName: ARRAY[0..QNLEN+1] OF CHAR;
  END;
  pPrqProcInfo  = ^PrqProcInfo;
  npPrqProcInfo = ^PrqProcInfo;

(** structure for DosPrintPortEnum Level 0 *)
  PrPortInfo = RECORD   (* prpo *)
    szPortName: ARRAY[0..PDLEN+1] OF CHAR;
  END;
  pPrPortInfo  = ^PrPortInfo;
  npPrPortInfo = ^PrPortInfo;

(** structure for DosPrintPortEnum Level 1 *)
  PrPortInfo1  = RECORD   (* prpo1 *)
    pszPortName           : pChar;
    pszPortDriverName     : pChar;
    pszPortDriverPathName : pChar;
  END;
  pPrPortInfo1  = ^PrPortInfo1;
  npPrPortInfo1 = ^PrPortInfo1;

(*** Values for parmnum in DosPrintQSetInfo/SplSetQueue  **)
CONST
  PRQ_PRIORITY_PARMNUM         =   2;
  PRQ_STARTTIME_PARMNUM        =   3;
  PRQ_UNTILTIME_PARMNUM        =   4;
  PRQ_SEPARATOR_PARMNUM        =   5;
  PRQ_PROCESSOR_PARMNUM        =   6;
  PRQ_DESTINATIONS_PARMNUM     =   7;
  PRQ_PARMS_PARMNUM            =   8;
  PRQ_COMMENT_PARMNUM          =   9;
  PRQ_TYPE_PARMNUM             =  10;
  PRQ_PRINTERS_PARMNUM         =  12;
  PRQ_DRIVERNAME_PARMNUM       =  13;
  PRQ_DRIVERDATA_PARMNUM       =  14;
  PRQ_REMOTE_COMPUTER_PARMNUM  =  15;
  PRQ_REMOTE_QUEUE_PARMNUM     =  16;
  PRQ_MAXPARMNUM               =  16;

(*** Print Queue Priority *********************************)
  PRQ_MAX_PRIORITY  =   1;            (* highest priority *)
  PRQ_DEF_PRIORITY  =   5;
  PRQ_MIN_PRIORITY  =   9;            (* lowest priority  *)
  PRQ_NO_PRIORITY   =   0;

  (*** Print queue status bitmask and values for level 1 **)
  PRQ_STATUS_MASK    =   3;
  PRQ_ACTIVE         =   0;
  PRQ_PAUSED         =   1;           (* queue is held    *)
  PRQ_ERROR          =   2;
  PRQ_PENDING        =   3;           (* pending deletion *)

  (*** Print queue status bits for level 3 ****************)
  PRQ3_PAUSED        = $1;            (* queue is held    *)
  PRQ3_PENDING       = $2;            (* pending deletion *)

  (*** Print queue type bits for level 3 ******************)
  PRQ3_TYPE_RAW    = $0001; (*spools printer-specific data*)
  PRQ3_TYPE_BYPASS = $0002; (*allow print while spooling  *)

  (*** Values for parmnum in DosPrintJobSetInfo/SplSetJob *)
  PRJ_NOTIFYNAME_PARMNUM     =   3;
  PRJ_DATATYPE_PARMNUM       =   4;
  PRJ_PARMS_PARMNUM          =   5;
  PRJ_POSITION_PARMNUM       =   6;
  PRJ_JOBFILEINUSE_PARMNUM   =   7;

  PRJ_COMMENT_PARMNUM        =  11;
  PRJ_DOCUMENT_PARMNUM       =  12;
  PRJ_STATUSCOMMENT_PARMNUM  =  13;
  PRJ_PRIORITY_PARMNUM       =  14;
  PRJ_PROCPARMS_PARMNUM      =  16;
  PRJ_DRIVERDATA_PARMNUM     =  18;
  PRJ_MAXPARMNUM             =  18;

(*** Bitmap masks for status field of PRJINFO. ************)
      (* 2-7 bits also used in device status *)
  PRJ_QSTATUS      = $0003;      (* Bits 0,1  *)
  PRJ_DEVSTATUS    = $0FFC;      (* 2-11 bits *)
  PRJ_COMPLETE     = $0004;      (* Bit 2     *)
  PRJ_INTERV       = $0008;      (* Bit 3     *)
  PRJ_ERROR        = $0010;      (* Bit 4     *)
  PRJ_DESTOFFLINE  = $0020;      (* Bit 5     *)
  PRJ_DESTPAUSED   = $0040;      (* Bit 6     *)
  PRJ_NOTIFY       = $0080;      (* Bit 7     *)
  PRJ_DESTNOPAPER  = $0100;      (* Bit 8     *)
  PRJ_DESTFORMCHG  = $0200;      (* BIT 9     *)
  PRJ_DESTCRTCHG   = $0400;      (* BIT 10    *)
  PRJ_DESTPENCHG   = $0800;      (* BIT 11    *)
  PRJ_JOBFILEINUSE = $4000;      (* Bit 14    *)
  PRJ_DELETED      = $8000;      (* Bit 15    *)

(* Values of PRJ_QSTATUS bits in fsStatus field of PRJINFO*)
  PRJ_QS_QUEUED    =  0;
  PRJ_QS_PAUSED    =  1;
  PRJ_QS_SPOOLING  =  2;
  PRJ_QS_PRINTING  =  3;

  (*** Print Job Priority *********************************)
  PRJ_MAX_PRIORITY = 99;              (* lowest priority  *)
  PRJ_MIN_PRIORITY =  1;              (* highest priority *)
  PRJ_NO_PRIORITY  =  0;


  (*** Bitmap masks for status field of PRDINFO. **********)
  PRD_STATUS_MASK  = $0003;                  (* Bits 0,1  *)
  PRD_DEVSTATUS    = $0FFC;                  (* 2-11 bits *)

  (*** Values of PRD_STATUS_MASK bits in fsStatus field   *)
  (*** of PRDINFO.                                      ***)
  PRD_ACTIVE            =  0;
  PRD_PAUSED            =  1;

  (*** Control codes used in DosPrintDestControl/         *)
  (*** SplControlDevice                              ******)
  PRD_DELETE            =  0;
  PRD_PAUSE             =  1;
  PRD_CONT              =  2;
  PRD_RESTART           =  3;

  (*** Values for parmnum in DosPrintDestSetInfo/         *)
  (***                              SplSetDevice **********)
  PRD_LOGADDR_PARMNUM   =  3;
  PRD_COMMENT_PARMNUM   =  7;
  PRD_DRIVERS_PARMNUM   =  8;
  PRD_TIMEOUT_PARMNUM   = 10;

(*** structure for SplEnumPrinter *************************)
TYPE
  PRINTERINFO  = RECORD    (* prtin *)
    flType                   : LongInt;
    pszComputerName          : pChar;
    pszPrintDestinationName  : pChar;
    pszDescription           : pChar;
    pszLocalName             : pChar;
   END;
   pPrinterInfo = ^PRINTERINFO;

(*** Flags for flType in  PRINTERINFO and SplEnumPrinter **)
CONST
  SPL_PR_QUEUE         = $00000001; (* include queues     *)
  SPL_PR_DIRECT_DEVICE = $00000002; (* unattached devices *)
  SPL_PR_QUEUED_DEVICE = $00000004; (* queued devices     *)
  SPL_PR_LOCAL_ONLY    = $00000100;(*exclude remote queues*)


(**********************************************************)
(* In the case of the DosPrintxxx, the API is presented   *)
(* by new name with the old name in parenthesis.          *)
(**********************************************************)

  FUNCTION SplQmOpen(pszToken  : pChar;
                     lCount    : LongInt;
                     pqmdopData: PQMOPENDATA): hSpl;
  FUNCTION Spl16QmOpen(pszToken: pChar;
                     lCount    : LongInt;
                     pqmdopData: PQMOPENDATA): hSpl;

  FUNCTION SplQmStartDoc(ahSpl       : hSpl;
                         pszDocName  : pChar): BOOL;
  FUNCTION Spl16QmStartDoc(ahSpl     : hSpl;
                         pszDocName  : pChar): BOOL;

  FUNCTION SplQmWrite(ahSpl : hSpl;
                      lCount: LongInt;
                      pData : pVoid): BOOL;
  FUNCTION Spl16QmWrite(ahSpl : hSpl;
                      lCount: LongInt;
                      pData : pVoid): BOOL;

  FUNCTION SplQmEndDoc(  ahSpl : hSpl): BOOL;
  FUNCTION Spl16QmEndDoc(ahSpl : hSpl): BOOL;

  FUNCTION SplQmClose(  ahSpl: hSpl): BOOL;
  FUNCTION Spl16QmClose(ahSpl: hSpl): BOOL;

  FUNCTION SplQmAbort(  ahSpl: hSpl): BOOL;
  FUNCTION Spl16QmAbort(ahSpl: hSpl): BOOL;

  FUNCTION SplQmAbortDoc(  ahSpl: hSpl): BOOL;
  FUNCTION Spl16QmAbortDoc(ahSpl: hSpl): BOOL;

  FUNCTION SplMessageBox(pszLogAddr: pChar;
                         fErrInfo  : LongInt;
                         fErrData  : LongInt;
                         pszText   : pChar;
                         pszCaption: pChar;
                         idWindow  : LongInt;
                         fStyle    : LongInt ): LongInt;
  FUNCTION Spl16MessageBox(pszLogAddr: pChar;
                         fErrInfo  : LongInt;
                         fErrData  : LongInt;
                         pszText   : pChar;
                         pszCaption: pChar;
                         idWindow  : LongInt;
                         fStyle    : LongInt ): LongInt;

(*** Direct Device File System Interface ******************)
  FUNCTION PrtOpen(pszDeviceName: pChar;
                   phDevice     : HFile;
                   pActionTaken : pULong;
                   cbFileSize,
                   uFileAttr,
                   openFlag,
                   openMode,
                   Reserved     : LongInt): LongInt;
  FUNCTION Prt16Open(pszDeviceName  : pChar;
                     phDevice       : HFile;
                     pActionTaken   : pULong;
                     cbFileSize,
                     uFileAttr,
                     openFlag,
                     openMode,
                     Reserved       : LongInt): LongInt;

  FUNCTION PrtClose(  hDevice: HFile): LongInt;
  FUNCTION Prt16Close(hDevice: HFile): LongInt;

  FUNCTION PrtWrite(hDevice   : HFile;
                    pchData   : pVoid;
                    cbData    : LongInt;
                    pcbWritten: pULong): LongInt;
  FUNCTION Prt16Write(hDevice : HFile;
                    pchData   : pVoid;
                    cbData    : LongInt;
                    pcbWritten: pULong): LongInt;

  FUNCTION PrtDevIOCtl(pData    : pVoid;
                       pParms   : pVoid;
                       uFunction: LongInt;
                       uCategory: LongInt;
                       hDevice  : HFile): LongInt;
  FUNCTION Prt16DevIOCtl(pData  : pVoid;
                       pParms   : pVoid;
                       uFunction: LongInt;
                       uCategory: LongInt;
                       hDevice  : HFile): LongInt;

  PROCEDURE PrtAbort(  hDevice: HFile);
  PROCEDURE Prt16Abort(hDevice: HFile);
(* end of include File System Emulation functions *)

  FUNCTION SplStdOpen(  ahdc: hDC): BOOL;
  FUNCTION Spl16StdOpen(ahdc: hDC): BOOL;

  FUNCTION SplStdClose(  ahdc: hDC): BOOL;
  FUNCTION Spl16StdClose(ahdc: hDC): BOOL;

  FUNCTION SplStdStart(  ahdc: hDC): BOOL;
  FUNCTION Spl16StdStart(ahdc: hDC): BOOL;

  FUNCTION SplStdStop(  ahdc: hDC): hStd;
  FUNCTION Spl16StdStop(ahdc: hDC): hStd;

  FUNCTION SplStdDelete(hMetaFile: hStd): BOOL;
  FUNCTION Spl16StdDelete(hMetaFile: hStd): BOOL;

  FUNCTION SplStdGetBits(hMetaFile: hStd;
                         OffData: LongInt;
                         cbData: LongInt;
                         pchData: pCh): BOOL;
  FUNCTION Spl16StdGetBits(hMetaFile: hStd;
                         OffData: LongInt;
                         cbData: LongInt;
                         pchData: pCh): BOOL;

  FUNCTION SplStdQueryLength(hMetaFile: hStd ): LongInt;
  FUNCTION Spl16StdQueryLength(hMetaFile: hStd ): LongInt;


   (*              SplCreateDevice(DosPrintDestAdd) *)
  FUNCTION SplCreateDevice(pszComputerName: pChar;
                           ulLevel: LongInt;
                           pBuf: pVoid;
                           cbBuf: LongInt): SplErr;
  FUNCTION DosPrintDestAdd(pszComputerName: pChar;
                           ulLevel: LongInt;
                           pBuf: pVoid;
                           cbBuf: LongInt): SplErr;
  FUNCTION DosPrint16DestAdd(pszComputerName: pChar;
                             ulLevel: LongInt;
                             pBuf: pVoid;
                             cbBuf: LongInt): SplErr;

   (*              SplControlDevice(DosPrintDestControl) *)
  FUNCTION SplControlDevice(     pszComputerName: pChar;
                                 pszPortName: pChar;
                                 ulControl: LongInt): SplErr;
  FUNCTION DosPrintDestControl(  pszComputerName: pChar;
                                 pszPortName: pChar;
  (* ALT ! *)                    ulControl: LongInt): SplErr;
  FUNCTION DosPrint16DestControl(pszComputerName: pChar;
                                 pszPortName: pChar;
  (* ALT ! *)                    ulControl: LongInt): SplErr;

   (*              SplDeleteDevice(DosPrintDestDel) *)
   FUNCTION SplDeleteDevice(pszComputerName,
                            pszPrintDeviceName: pChar):SplErr;
   FUNCTION DosPrintDestDel(pszComputerName,
                            pszPrintDeviceName: pChar):SplErr;
   FUNCTION DosPrint16DestDel(pszComputerName,
                            pszPrintDeviceName: pChar):SplErr;

   (*              SplEnumDevice(DosPrintDestEnum) *)
   FUNCTION SplEnumDevice(pszComputerName: pChar;
                          ulLevel        : LongInt;
                          pBuf           : pVoid;
                          cbBuf          : LongInt;
                          pcReturned,
                          pcTotal,
                          pcbNeeded      : pULong;
                          pReserved      : pVoid): SplErr;
   FUNCTION DosPrintDestEnum(pszComputerName: pChar;
                          ulLevel        : LongInt;
                          pBuf           : pVoid;
                          cbBuf          : LongInt;
                          pcReturned,
                          pcTotal,
                          pcbNeeded      : pULong;
                          pReserved      : pVoid): SplErr;
   FUNCTION DosPrint16DestEnum(pszComputerName: pChar;
                          ulLevel        : LongInt;
                          pBuf           : pVoid;
                          cbBuf          : LongInt;
                          pcReturned,
                          pcTotal,
                          pcbNeeded      : pULong;
                          pReserved      : pVoid): SplErr;



   (*              SplQueryDevice(DosPrintDestGetInfo) *)
  FUNCTION SplQueryDevice(pszComputerName : pChar;
                 pszPrintDeviceName       : pChar;
                 ulLevel                  : LongInt;
                 pBuf                     : pVoid;
                 cbBuf                    : LongInt;
                 pcbNeeded                : pULong): SplErr;
  FUNCTION DosPrintDestGetInfo(pszComputerName: pChar;
                 pszPrintDeviceName           : pChar;
                 ulLevel                      : LongInt;
                 pBuf                         : pVoid;
                 cbBuf                        : LongInt;
                 pcbNeeded                    : pULong
                                             ): SplErr;
  FUNCTION DosPrint16DestGetInfo(pszComputerName : pChar;
                 pszPrintDeviceName              : pChar;
                 ulLevel                         : LongInt;
                 pBuf                            : pVoid;
                 cbBuf                           : LongInt;
                 pcbNeeded                       : pULong
                                                ): SplErr;

   (*              SplSetDevice(DosPrintDestSetInfo) *)
  FUNCTION SplSetDevice(pszComputerName,
                        pszPrintDeviceName : pChar;
                        ulLevel            : LongInt;
                        pBuf               : pVoid;
                        cbBuf              : LongInt;
                        ulParmNum          : LongInt): SplErr;
  FUNCTION DosPrintDestSetInfo(pszComputerName,
                        pszPrintDeviceName : pChar;
                        ulLevel            : LongInt;
                        pBuf               : pVoid;
                        cbBuf              : LongInt;
                        ulParmNum          : LongInt): SplErr;
  FUNCTION DosPrint16DestSetInfo(pszComputerName,
                        pszPrintDeviceName : pChar;
                        ulLevel            : LongInt;
                        pBuf               : pVoid;
                        cbBuf              : LongInt;
                        ulParmNum          : LongInt): SplErr;

   (*              SplReleaseJob(DosPrintJobContinue) *)
  FUNCTION SplReleaseJob(pszComputerName,
                         pszQueueName    : pChar;
                         ulJob           : LongInt): SplErr;
  FUNCTION DosPrintJobContinue(pszComputerName,
                         pszQueueName    : pChar;
                         ulJob           : LongInt): SplErr;
  FUNCTION DosPrint16JobContinue(pszComputerName,
                         pszQueueName    : pChar;
                         ulJob           : LongInt): SplErr;



   (*              SplDeleteJob(DosPrintJobDel) *)
  FUNCTION SplDeleteJob(pszComputerName,
                        pszQueueName       : pChar;
                        ulJob              : LongInt): SplErr;
  FUNCTION DosPrintJobDel(pszComputerName,
                        pszQueueName       : pChar;
                        ulJob              : LongInt): SplErr;
  FUNCTION DosPrint16JobDel(pszComputerName,
                        pszQueueName       : pChar;
                        ulJob              : LongInt): SplErr;

   (*              SplEnumJob(DosPrintJobEnum) *)
   FUNCTION SplEnumJob(pszComputerName,
                       pszQueueName   : pChar;
                       ulLevel        : LongInt;
                       pBuf           : pVoid;
                       cbBuf          : LongInt;
                       pcReturned,
                       pcTotal,
                       pcbNeeded      : pULong;
                       pReserved      : pVoid): SplErr;
   FUNCTION DosPrintJobEnum(pszComputerName,
                            pszQueueName   : pChar;
                            ulLevel        : LongInt;
                            pBuf           : pVoid;
                            cbBuf          : LongInt;
                            pcReturned,
                            pcTotal,
                            pcbNeeded      : pULong;
                            pReserved      : pVoid): SplErr;
   FUNCTION DosPrint16JobEnum(pszComputerName,
                            pszQueueName   : pChar;
                            ulLevel        : LongInt;
                            pBuf           : pVoid;
                            cbBuf          : LongInt;
                            pcReturned,
                            pcTotal,
                            pcbNeeded      : pULong;
                            pReserved      : pVoid): SplErr;

   (*** See above for change to PRIDINFO datatype for     *)
   (* this API.                                   *********)

   (*              SplQueryJob(DosPrintJobGetInfo)  *)
   FUNCTION SplQueryJob(pszComputerName,
                        pszQueueName : pChar;
                        ulJob,
                        ulLevel      : LongInt;
                        pBuf         : pVoid;
                        cbBuf        : LongInt;
                        pcbNeeded    : pULong): SplErr;
   FUNCTION DosPrintJobGetInfo(pszComputerName,
                        pszQueueName : pChar;
                        ulJob,
                        ulLevel      : LongInt;
                        pBuf         : pVoid;
                        cbBuf        : LongInt;
                        pcbNeeded    : pULong): SplErr;
   FUNCTION DosPrint16JobGetInfo(pszComputerName,
                        pszQueueName : pChar;
                        ulJob,
                        ulLevel      : LongInt;
                        pBuf         : pVoid;
                        cbBuf        : LongInt;
                        pcbNeeded    : pULong): SplErr;

   (*              SplHoldJob(DosPrintJobPause)   *)
  FUNCTION SplHoldJob(pszComputerName,
                      pszQueueName   : pChar;
                      ulJob          : LongInt): SplErr;
  FUNCTION DosPrintJobPause(pszComputerName,
                      pszQueueName   : pChar;
                      ulJob          : LongInt): SplErr;
  FUNCTION DosPrint16JobPause(pszComputerName,
                      pszQueueName   : pChar;
                      ulJob          : LongInt): SplErr;

   (*              SplSetJob(DosPrintJobSetInfo)*)
  FUNCTION SplSetJob(pszComputerName,
                     pszQueueName   : pChar;
                     ulJob,
                     ulLevel        : LongInt;
                     pBuf           : pVoid;
                     cbBuf,
                     ulParmNum      : LongInt): SplErr;
  FUNCTION DosPrintJobSetInfo(pszComputerName,
                              pszQueueName   : pChar;
                              ulJob,
                              ulLevel        : LongInt;
                              pBuf           : pVoid;
                              cbBuf,
                              ulParmNum      : LongInt
                                            ): SplErr;
  FUNCTION DosPrint16JobSetInfo(pszComputerName,
                                pszQueueName : pChar;
                                ulJob,
                                ulLevel      : LongInt;
                                pBuf         : pVoid;
                                cbBuf,
                                ulParmNum    : LongInt
                                            ): SplErr;

   (*              SplCreateQueue(DosPrintQAdd) *)
  FUNCTION SplCreateQueue(pszComputerName : pChar;
                          ulLevel         : LongInt;
                          pBuf            : pVoid;
                          cbBuf           : LongInt): SplErr;
  FUNCTION DosPrintQAdd(pszComputerName   : pChar;
                        ulLevel           : LongInt;
                        pBuf              : pVoid;
                        cbBuf             : LongInt): SplErr;
  FUNCTION DosPrint16QAdd(pszComputerName : pChar;
                          ulLevel         : LongInt;
                          pBuf            : pVoid;
                          cbBuf           : LongInt): SplErr;

   (*              SplReleaseQueue(DosPrintQContinue) *)
  FUNCTION SplReleaseQueue(pszComputerName,
                           pszQueueName      : pChar): SplErr;
  FUNCTION DosPrintQContinue(pszComputerName,
                             pszQueueName    : pChar): SplErr;
  FUNCTION DosPrint16QContinue(pszComputerName,
                               pszQueueName  : pChar): SplErr;

   (*              SplDeleteQueue(DosPrintQDel) *)
  FUNCTION SplDeleteQueue(pszComputerName,
                          pszQueueName    : pChar): SplErr;
  FUNCTION DosPrintQDel(pszComputerName,
                        pszQueueName      : pChar): SplErr;
  FUNCTION DosPrint16QDel(pszComputerName,
                          pszQueueName    : pChar): SplErr;


   (*              SplEnumQueue(DosPrintQEnum) *)
  FUNCTION SplEnumQueue(pszComputerName: pChar;
                        ulLevel        : LongInt;
                        pBuf           : pVoid;
                        cbBuf          : LongInt;
                        pcReturned,
                        pcTotal,
                        pcbNeeded      : pULong;
                        pReserved      : pVoid): SplErr;
  FUNCTION DosPrintQEnum(pszComputerName: pChar;
                        ulLevel         : LongInt;
                        pBuf            : pVoid;
                        cbBuf           : LongInt;
                        pcReturned,
                        pcTotal,
                        pcbNeeded       : pULong;
                        pReserved       : pVoid): SplErr;
  FUNCTION DosPrint16QEnum(pszComputerName: pChar;
                           ulLevel        : LongInt;
                           pBuf           : pVoid;
                           cbBuf          : LongInt;
                           pcReturned,
                           pcTotal,
                           pcbNeeded      : pULong;
                           pReserved      : pVoid): SplErr;

   (*               SplQueryQueue(DosPrintQGetInfo) *)
  FUNCTION  SplQueryQueue(pszComputerName,
                          pszQueueName    : pChar;
                          ulLevel         : LongInt;
                          pBuf            : pVoid;
                          cbBuf           : LongInt;
                          pcbNeeded       : pULong): SplErr;
  FUNCTION  DosPrintQGetInfo(pszComputerName,
                             pszQueueName : pChar;
                             ulLevel      : LongInt;
                             pBuf         : pVoid;
                             cbBuf        : LongInt;
                             pcbNeeded    : pULong): SplErr;
  FUNCTION  DosPrint16QGetInfo(pszComputerName,
                               pszQueueName   : pChar;
                               ulLevel        : LongInt;
                               pBuf           : pVoid;
                               cbBuf          : LongInt;
                               pcbNeeded      : pULong
                                             ): SplErr;

   (*              SplHoldQueue(DosPrintQPause) *)
  FUNCTION SplHoldQueue(pszComputerName,
                        pszQueueName   : pChar)  : SplErr;
  FUNCTION DosPrintQPause(pszComputerName,
                          pszQueueName   : pChar) : SplErr;
  FUNCTION DosPrint16QPause(pszComputerName,
                            pszQueueName   : pChar) : SplErr;

   (*              SplPurgeQueue(DosPrintQPurge) *)
  FUNCTION SplPurgeQueue(pszComputerName,
                         pszQueueName   : pChar): SplErr;
  FUNCTION DosPrintQPurge(pszComputerName,
                          pszQueueName   : pChar): SplErr;
  FUNCTION DosPrint16QPurge(pszComputerName,
                            pszQueueName   : pChar): SplErr;

   (*               SplSetQueue(DosPrintQSetInfo) *)
  FUNCTION SplSetQueue(pszComputerName,
                       pszQueueName   : pChar;
                       ulLevel        : LongInt;
                       pBuf           : pVoid;
                       cbBuf,
                       ulParmNum      : LongInt): SplErr;
  FUNCTION DosPrintQSetInfo(pszComputerName,
                            pszQueueName   : pChar;
                            ulLevel        : LongInt;
                            pBuf           : pVoid;
                            cbBuf,
                            ulParmNum      : LongInt): SplErr;
  FUNCTION DosPrint16QSetInfo(pszComputerName,
                              pszQueueName   : pChar;
                              ulLevel        : LongInt;
                              pBuf           : pVoid;
                              cbBuf,
                              ulParmNum      : LongInt
                                            ): SplErr;

   (*               SplEnumDriver(DosPrintDriverEnum) *)
  FUNCTION SplEnumDriver(pszComputerName: pChar;
                         ulLevel        : LongInt;
                         pBuf           : pVoid;
                         cbBuf          : LongInt;
                         pcReturned     : pULong;
                         pcTotal        : pULong;
                         pcbNeeded      : pULong;
                         pReserved      : pVoid): SplErr;
  FUNCTION DosPrintDriverEnum(pszComputerName: pChar;
                              ulLevel        : LongInt;
                              pBuf           : pVoid;
                              cbBuf          : LongInt;
                              pcReturned     : pULong;
                              pcTotal        : pULong;
                              pcbNeeded      : pULong;
                              pReserved      : pVoid
                                            ): SplErr;
  FUNCTION DosPrint16DriverEnum(pszComputerName: pChar;
                                ulLevel        : LongInt;
                                pBuf           : pVoid;
                                cbBuf          : LongInt;
                                pcReturned     : pULong;
                                pcTotal        : pULong;
                                pcbNeeded      : pULong;
                                pReserved      : pVoid
                                              ): SplErr;

   (*               SplEnumPort(DosPrintPortEnum) *)
  FUNCTION SplEnumPort(pszComputerName: pChar;
                       ulLevel        : LongInt;
                       pBuf           : pVoid;
                       cbBuf          : LongInt;
                       pcReturned     : pULong;
                       pcTotal        : pULong;
                       pcbNeeded      : pULong;
                       pReserved      : pVoid): SplErr;
  FUNCTION DosPrintPortEnum(pszComputerName: pChar;
                            ulLevel        : LongInt;
                            pBuf           : pVoid;
                            cbBuf          : LongInt;
                            pcReturned     : pULong;
                            pcTotal        : pULong;
                            pcbNeeded      : pULong;
                            pReserved      : pVoid): SplErr;
  FUNCTION DosPrint16PortEnum(pszComputerName: pChar;
                              ulLevel        : LongInt;
                              pBuf           : pVoid;
                              cbBuf          : LongInt;
                              pcReturned     : pULong;
                              pcTotal        : pULong;
                              pcbNeeded      : pULong;
                              pReserved      : pVoid
                                            ): SplErr;

   (*               SplEnumQueueProcessor(DosPrintQProcessorEnum) *)
  FUNCTION SplEnumQueueProcessor(pszComputerName : pChar;
                                 ulLevel         : LongInt;
                                 pBuf            : pVoid;
                                 cbBuf           : LongInt;
                                 pcReturned,
                                 pcTotal,
                                 pcbNeeded       : pULong;
                                 pReserved       : pVoid
                                                ): SplErr;
  FUNCTION DosPrintQProcessorEnum(pszComputerName: pChar;
                                  ulLevel        : LongInt;
                                  pBuf           : pVoid;
                                  cbBuf          : LongInt;
                                  pcReturned,
                                  pcTotal,
                                  pcbNeeded      : pULong;
                                  pReserved      : pVoid
                                                ): SplErr;
  FUNCTION DosPrint16QProcessorEnum(pszComputerName: pChar;
                                    ulLevel        : LongInt;
                                    pBuf           : pVoid;
                                    cbBuf          : LongInt;
                                    pcReturned,
                                    pcTotal,
                                    pcbNeeded      : pULong;
                                    pReserved      : pVoid
                                                  ): SplErr;
{
  FUNCTION SplEnumPrinter(pszComputerName: PSZ;
                          uLevel         : LongInt;
                          flType         : LongInt;
                          pBuf           : pVoid;
                          cbbuf          : ULong;
                          pcReturned     : pLongInt;
                          pcTotal        : pLongInt;
                          pcbNeeded      : pLongInt;
                          pReserved      : PVOID): SPLERR;

  FUNCTION SplCopyJob(pszSrcComputerName,
                      pszSrcQueueName    : PSZ;
                      ulSrcJob           : ULong;
                      pszTrgComputerName,
                      pszTrgQueueName    : PSZ;
                      pulTrgJob          : pULong): SPLERR;
}
IMPLEMENTATION

  FUNCTION SplQmOpen;           EXTERNAL 'PMSpl' INDEX  1;
  FUNCTION Spl16QmOpen;         EXTERNAL 'PMSpl' INDEX  1;

  FUNCTION SplQmStartDoc;       EXTERNAL 'PMSpl' INDEX  2;
  FUNCTION Spl16QmStartDoc;     EXTERNAL 'PMSpl' INDEX  2;

  FUNCTION SplQmEndDoc;         EXTERNAL 'PMSpl' INDEX  3;
  FUNCTION Spl16QmEndDoc;       EXTERNAL 'PMSpl' INDEX  3;

  FUNCTION SplQmWrite;          EXTERNAL 'PMSpl' INDEX  4;
  FUNCTION Spl16QmWrite;        EXTERNAL 'PMSpl' INDEX  4;

  FUNCTION SplQmAbort;          EXTERNAL 'PMSpl' INDEX  5;
  FUNCTION Spl16QmAbort;        EXTERNAL 'PMSpl' INDEX  5;

  FUNCTION SplQmClose;          EXTERNAL 'PMSpl' INDEX  6;
  FUNCTION Spl16QmClose;        EXTERNAL 'PMSpl' INDEX  6;

  FUNCTION SplMessageBox;       EXTERNAL 'PMSpl' INDEX  7;
  FUNCTION Spl16MessageBox;     EXTERNAL 'PMSpl' INDEX  7;

  FUNCTION SplQmAbortDoc;       EXTERNAL 'PMSpl' INDEX  8;
  FUNCTION Spl16QmAbortDoc;     EXTERNAL 'PMSpl' INDEX  8;

(* ====================================================== *)

{         FUNCTIONS NOT YET INTERFACED !!!!!!!!!!

  FUNCTION SPLInit;             External 'PMSpl' INDEX 20;
  FUNCTION SPL16Init;           External 'PMSpl' INDEX 20;

  FUNCTION SPLQMListQueues;     External 'PMSpl' INDEX  21;
  FUNCTION SPLQMQueryQInfo;     External 'PMSpl' INDEX  22;

  FUNCTION SPLQMListJobs;       External 'PMSpl' INDEX 23;
  FUNCTION SPLQMQueryJInfo;     External 'PMSpl' INDEX 24;

  FUNCTION SPLQMHoldQueue;      External 'PMSpl' INDEX 25;
  FUNCTION SPLQMReleaseQueue;   External 'PMSpl' INDEX 26;

  FUNCTION SPLQMHoldJob;        External 'PMSpl' INDEX 27;
  FUNCTION SPLQMReleaseJob;     External 'PMSpl' INDEX 28;

  FUNCTION SPLQMCancelJob;      External 'PMSpl' INDEX 29;
  FUNCTION SPLQMRestartJob;     External 'PMSpl' INDEX 30;

  FUNCTION SPLQMRepeatJob;      External 'PMSpl' INDEX 31;
  FUNCTION SPLQMPrintJobNext;   External 'PMSpl' INDEX 32;

  FUNCTION SPLQMQueryPInfo;     External 'PMSpl' INDEX 33;
  FUNCTION SPLQMChangeJobPrtY;  External 'PMSpl' INDEX 34;

  FUNCTION SPLQMWriteFile;      External 'PMSpl' INDEX 35;

(* ===================================================== *)
}
  FUNCTION SplStdOpen;          EXTERNAL 'PMSpl' INDEX 50;
  FUNCTION Spl16StdOpen;        EXTERNAL 'PMSpl' INDEX 50;

  FUNCTION SplStdClose;         EXTERNAL 'PMSpl' INDEX 51;
  FUNCTION Spl16StdClose;       EXTERNAL 'PMSpl' INDEX 51;

  FUNCTION SplStdStart;         EXTERNAL 'PMSpl' INDEX 52;
  FUNCTION Spl16StdStart;       EXTERNAL 'PMSpl' INDEX 52;

  FUNCTION SplStdStop;          EXTERNAL 'PMSpl' INDEX 53;
  FUNCTION Spl16StdStop;        EXTERNAL 'PMSpl' INDEX 53;

  FUNCTION SplStdDelete;        EXTERNAL 'PMSpl' INDEX 54;
  FUNCTION Spl16StdDelete;      EXTERNAL 'PMSpl' INDEX 54;

  FUNCTION SplStdGetBits;       EXTERNAL 'PMSpl' INDEX 55;
  FUNCTION Spl16StdGetBits;     EXTERNAL 'PMSpl' INDEX 55;

  FUNCTION SplStdQueryLength;   EXTERNAL 'PMSpl' INDEX 56;
  FUNCTION Spl16StdQueryLength; EXTERNAL 'PMSpl' INDEX 56;

(* ====================================================== *)

  FUNCTION PrtOpen;             EXTERNAL 'PMSpl' INDEX 70;
  FUNCTION Prt16Open;           EXTERNAL 'PMSpl' INDEX 70;

  FUNCTION PrtWrite;            EXTERNAL 'PMSpl' INDEX 71;
  FUNCTION Prt16Write;          EXTERNAL 'PMSpl' INDEX 71;

  FUNCTION PrtDevIOCtl;         EXTERNAL 'PMSpl' INDEX 72;
  FUNCTION Prt16DevIOCtl;       EXTERNAL 'PMSpl' INDEX 72;

  FUNCTION PrtClose;            EXTERNAL 'PMSpl' INDEX 73;
  FUNCTION Prt16Close;          EXTERNAL 'PMSpl' INDEX 73;

(* ====================================================== *)

  PROCEDURE PrtAbort;           EXTERNAL 'PMSpl' INDEX 75;
  PROCEDURE Prt16Abort;         EXTERNAL 'PMSpl' INDEX 75;

  FUNCTION DosPrintDestControl; EXTERNAL 'PMSpl' INDEX 80;
  FUNCTION DosPrint16DestControl;
    EXTERNAL 'PMSpl' INDEX 80;

  FUNCTION DosPrintDestGetInfo; EXTERNAL 'PMSpl' INDEX 81;
  FUNCTION DosPrint16DestGetInfo;
    EXTERNAL 'PMSpl' INDEX 81;

  FUNCTION DosPrintDestEnum;    EXTERNAL 'PMSpl' INDEX 82;
  FUNCTION DosPrint16DestEnum;  EXTERNAL 'PMSpl' INDEX 82;

(* ====================================================== *)

  FUNCTION DosPrintJobContinue; EXTERNAL 'PMSpl' INDEX 84;
  FUNCTION DosPrint16JobContinue;
    EXTERNAL 'PMSpl' INDEX 84;

  FUNCTION DosPrintJobPause;    EXTERNAL 'PMSpl' INDEX 85;
  FUNCTION DosPrint16JobPause;  EXTERNAL 'PMSpl' INDEX 85;

  FUNCTION DosPrintJobDel;      EXTERNAL 'PMSpl' INDEX 86;
  FUNCTION DosPrint16JobDel;    EXTERNAL 'PMSpl' INDEX 86;

(* ====================================================== *)

  FUNCTION DosPrintJobGetInfo;  EXTERNAL 'PMSpl' INDEX 90;
  FUNCTION DosPrint16JobGetInfo;EXTERNAL 'PMSpl' INDEX 90;

  FUNCTION DosPrintJobSetInfo;  EXTERNAL 'PMSpl' INDEX 91;
  FUNCTION DosPrint16JobSetInfo;EXTERNAL 'PMSpl' INDEX 91;

  FUNCTION DosPrintJobEnum;     EXTERNAL 'PMSpl' INDEX 92;
  FUNCTION DosPrint16JobEnum;   EXTERNAL 'PMSpl' INDEX 92;

  FUNCTION DosPrintQAdd;        EXTERNAL 'PMSpl' INDEX 93;
  FUNCTION DosPrint16QAdd;      EXTERNAL 'PMSpl' INDEX 93;

  FUNCTION DosPrintQPause;      EXTERNAL 'PMSpl' INDEX 94;
  FUNCTION DosPrint16QPause;    EXTERNAL 'PMSpl' INDEX 94;

  FUNCTION DosPrintQContinue;   EXTERNAL 'PMSpl' INDEX 95;
  FUNCTION DosPrint16QContinue; EXTERNAL 'PMSpl' INDEX 95;

  FUNCTION DosPrintQDel;        EXTERNAL 'PMSpl' INDEX 96;
  FUNCTION DosPrint16QDel;      EXTERNAL 'PMSpl' INDEX 96;

  FUNCTION DosPrintQGetInfo;    EXTERNAL 'PMSpl' INDEX 97;
  FUNCTION DosPrint16QGetInfo;  EXTERNAL 'PMSpl' INDEX 97;

  FUNCTION DosPrintQSetInfo;    EXTERNAL 'PMSpl' INDEX 98;
  FUNCTION DosPrint16QSetInfo;  EXTERNAL 'PMSpl' INDEX 98;

  FUNCTION DosPrintQEnum;       EXTERNAL 'PMSpl' INDEX 99;
  FUNCTION DosPrint16QEnum;     EXTERNAL 'PMSpl' INDEX 99;

(* ====================================================== *)

  FUNCTION DosPrintDestAdd;     EXTERNAL 'PMSpl' INDEX 101;
  FUNCTION DosPrint16DestAdd;   EXTERNAL 'PMSpl' INDEX 101;

  FUNCTION DosPrintDestSetInfo; EXTERNAL 'PMSpl' INDEX 102;
  FUNCTION DosPrint16DestSetInfo;
    EXTERNAL 'PMSpl' INDEX 102;

  FUNCTION DosPrintDestDel;     EXTERNAL 'PMSpl' INDEX 103;
  FUNCTION DosPrint16DestDel;   EXTERNAL 'PMSpl' INDEX 103;

  FUNCTION DosPrintQPurge;      EXTERNAL 'PMSpl' INDEX 104;
  FUNCTION DosPrint16QPurge;    EXTERNAL 'PMSpl' INDEX 104;

{
  FUNCTION DosPrintJobGetID;    External 'PMSpl' INDEX 105;
  FUNCTION DosPrint16JobGetID;  External 'PMSpl' INDEX 105;
}

  FUNCTION DosPrintDriverEnum;  EXTERNAL 'PMSpl' INDEX 106;
  FUNCTION DosPrint16DriverEnum;EXTERNAL 'PMSpl' INDEX 106;

  FUNCTION DosPrintQProcessorEnum;
    EXTERNAL 'PMSpl' INDEX 107;
  FUNCTION DosPrint16QProcessorEnum;
    EXTERNAL 'PMSpl' INDEX 107;

  FUNCTION DosPrintPortEnum;    EXTERNAL 'PMSpl' INDEX 108;
  FUNCTION DosPrint16PortEnum;  EXTERNAL 'PMSpl' INDEX 108;

(* ===================================================== *)
{
  FUNCTION SPLQMQueryPrintRes;  External 'PMSpl' INDEX 140;
  FUNCTION SPL16QMQueryPrintRes;External 'PMSpl' INDEX 140;
}
(* ====================================================== *)
(*                       32 Bit                           *)
{
  FUNCTION SPL32QmOpen;         External 'PMSpl' INDEX 301;

  FUNCTION SPL32QmStartDoc;     External 'PMSpl' INDEX 302;

  FUNCTION SPL32QmEndDoc;
    External 'PMSpl'    INDEX 303;

  FUNCTION SPL32QmWrite;
    External 'PMSpl'    INDEX 304;

  FUNCTION SPL32QmAbort;
    External 'PMSpl'    INDEX 305;

  FUNCTION SPL32QmClose;
    External 'PMSpl'    INDEX 306;

  FUNCTION SPL32MessageBox;
    External 'PMSpl'    INDEX 307;

  FUNCTION SPL32QmAbortDoc;
    External 'PMSpl'    INDEX 308;

(* ===================================================== *)

  FUNCTION SPL32Init;
    External 'PMSpl'    INDEX 320;

(* ===================================================== *)

  FUNCTION SPL32StdOpen;
    External 'PMSpl'    INDEX 350;

  FUNCTION SPL32StdClose;
    External 'PMSpl'    INDEX 351;

  FUNCTION SPL32StdStart;
    External 'PMSpl'    INDEX 352;

  FUNCTION SPL32StdStop;
    External 'PMSpl'    INDEX 353;

  FUNCTION SPL32StdDelete;
    External 'PMSpl'    INDEX 354;

  FUNCTION SPL32StdGetBits;
    External 'PMSpl'    INDEX 355;

  FUNCTION SPL32StdQueryLength;
    External 'PMSpl'    INDEX 356;

(* ====================================================== *)

  FUNCTION Prt32Open;
    External 'PMSpl'    INDEX 370;

  FUNCTION Prt32Write;
    External 'PMSpl'    INDEX 371;

  FUNCTION Prt32DevIOCtl;
    External 'PMSpl'    INDEX 372;

  FUNCTION Prt32Close;
    External 'PMSpl'    INDEX 373;

  FUNCTION Prt32Abort;
    External 'PMSpl'    INDEX 375;
}
(* ====================================================== *)

  FUNCTION SplControlDevice;
    EXTERNAL 'PMSpl'    INDEX 380;

  FUNCTION SplQueryDevice;
    EXTERNAL 'PMSpl'    INDEX 381;

  FUNCTION SplEnumDevice;
    EXTERNAL 'PMSpl'    INDEX 382;

  FUNCTION SplReleaseJob;
    EXTERNAL 'PMSpl'    INDEX 384;

  FUNCTION SplHoldJob;
    EXTERNAL 'PMSpl'    INDEX 385;

  FUNCTION SplDeleteJob;
    EXTERNAL 'PMSpl'    INDEX 386;

(* ====================================================== *)

  FUNCTION SplQueryJob;
    EXTERNAL 'PMSpl'    INDEX 390;

  FUNCTION SplSetJob;
    EXTERNAL 'PMSpl'    INDEX 391;

  FUNCTION SplEnumJob;
    EXTERNAL 'PMSpl'    INDEX 392;

  FUNCTION SplCreateQueue;
    EXTERNAL 'PMSpl'    INDEX 393;

  FUNCTION SplHoldQueue;
    EXTERNAL 'PMSpl'    INDEX 394;

  FUNCTION SplReleaseQueue;
    EXTERNAL 'PMSpl'    INDEX 395;

  FUNCTION SplDeleteQueue;
    EXTERNAL 'PMSpl'    INDEX 396;

  FUNCTION SplQueryQueue;
    EXTERNAL 'PMSpl'    INDEX 397;

  FUNCTION SplSetQueue;
    EXTERNAL 'PMSpl'    INDEX 398;

  FUNCTION SplEnumQueue;
    EXTERNAL 'PMSpl'    INDEX 399;

(* ====================================================== *)

  FUNCTION SplCreateDevice;
    EXTERNAL 'PMSpl'    INDEX 401;

  FUNCTION SplSetDevice;
    EXTERNAL 'PMSpl'    INDEX 402;

  FUNCTION SplDeleteDevice;
    EXTERNAL 'PMSpl'    INDEX 403;

  FUNCTION SplPurgeQueue;
    EXTERNAL 'PMSpl'    INDEX 404;
{
  FUNCTION SplQueryJobId;
    External 'PMSpl'    INDEX 405;
}
  FUNCTION SplEnumDriver;
    EXTERNAL 'PMSpl'    INDEX 406;

  FUNCTION SplEnumQueueProcessor;
    EXTERNAL 'PMSpl'    INDEX 407;

  FUNCTION SplEnumPort;
    EXTERNAL 'PMSpl'    INDEX 408;

(* ====================================================== *)
(*                       32 Bit                           *)
{                 nicht implementiert

  FUNCTION SPL32EnumPrinter; External 'PMSpl'    INDEX 441;
  FUNCTION SPL32CopyJob;     External 'PMSpl'    INDEX 442;
  FUNCTION SPL32QmSetup;     External 'PMSpl' INDEX 443;
}

END.

(* ====================================================== *)
(*                   Ende von PMSPL.PAS                   *)
