(* ====================================================== *)
(*                        NAMPIPES.PAS                    *)
(*    Implementation of the functions of NAMPIPES.DLL     *)
(*          Translation to Pascal by jb / toolbox mag     *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT NamPipes;

INTERFACE

USES
  Os2Def;

TYPE
  PTraceBuf = RECORD
    pID     : WORD;
    tID     : WORD;
    cmd     : WORD;
    value   : WORD;
    offv    : WORD;
    segv    : WORD;
    mte     : WORD;
    rAX     : WORD;
    rBX     : WORD;
    rCX     : WORD;
    rDX     : WORD;
    rSI     : WORD;
    rDI     : WORD;
    rBP     : WORD;
    rDS     : WORD;
    rES     : WORD;
    rIP     : WORD;
    rCS     : WORD;
    rF      : WORD;
    rSP     : WORD;
    rSS     : WORD;
  END;

TYPE
  PipeInfo = RECORD
    cbOut           : WORD;
    cbIn            : WORD;
    cbMaxInst       : CHAR;
    cbCurInst       : CHAR;
    cbName          : CHAR;
    szName          : ARRAY [0..0] OF CHAR;
  END;

  NPI_Data1 = RECORD
    npi_obuflen     : WORD;
    npi_ibuflen     : WORD;
    npi_maxicnt     : CHAR;
    npi_curicnt     : CHAR;
    npi_namlen      : CHAR;
    npi_name        : ARRAY [0..0] OF CHAR;
  END;

  PipesEmSTate = RECORD
    fStatus : CHAR;
    fFlag   : CHAR;
    usKey   : WORD;
    usAvail : WORD;
  END;

  NpSs = RECORD
    npss_status     : CHAR;
    npss_flag       : CHAR;
    npss_key        : WORD;
    npss_avail      : WORD;
  END;

CONST
  NpSs_EoI            = 0;
  npss_RDATA          = 1;
  npss_WSPACE         = 2;
  npss_CLOSE          = 3;

  npss_WAIT           = 1;

  np_BLK              = $8000;
  np_SERVER           = $4000;
  np_WMESG            = $100;
  np_ICOUNT           = $0FF;

  np_DISCONNECTED     = 1;
  np_LISTENING        = 2;
  np_CONNECTED        = 3;
  np_CLOSING          = 4;

  np_ACCESS_INBOUND   = 0;
  np_ACCESS_OUTBOUND  = 1;
  np_ACCESS_DUPLEX    = 2;
  np_INHERIT          = 0;
  np_NOINHERIT        = $80;
  np_WRITEBEHIND      = 0;
  np_NOWRITEBEHIND    = $4000;

  np_READMODE_BYTE    = 0;
  np_READMODE_MESSAGE = $100;
  np_TYPE_BYTE        = 0;
  np_TYPE_MESSAGE     = $400;
  np_END_CLIENT       = 0;
  np_END_SERVER       = $4000;
  np_WAIT             = 0;
  np_NOWAIT           = $8000;
  np_UNLIMITED_INSTANCES = $FF;

TYPE
  AvailData = RECORD
    cbpipe          : WORD;
    cbmessage       : WORD;
 END;


FUNCTION DosCallNmPipe(    a : pChar;
                           b : Pointer;
                           c : WORD;
                           d : Pointer;
                           e : WORD;
                       VAR f : WORD;
                           g :LongInt {LONGCARD}
                           ) : WORD;

FUNCTION DosConnectNmPipe(a : WORD) : WORD;

FUNCTION DosDisConnectNmPipe(a : WORD) : WORD;

FUNCTION DosMakeNmPipe(    a : pChar;
                       VAR b : WORD;
                           c : WORD;
                           d : WORD;
                           e : WORD;
                           f : WORD;
                           g :LongInt {LONGCARD}
                           ) : WORD;

FUNCTION DosPeekNmPipe(   a : WORD;
                          b : Pointer;
                          c : WORD;
                      VAR d : WORD;
                      VAR e : AvailData;
                      VAR f : WORD
                          ) : WORD;

FUNCTION DosQNmPHandState(a : WORD; VAR b : WORD) : WORD;

FUNCTION DosQNmPipeInfo(a : WORD;
                        b : WORD;
                        c : Pointer;
                        d : LongInt {LONGCARD}
                        ) : WORD;

FUNCTION DosQNmPipeSemState(    a : SemaPhore;
                            VAR b : PipesEmSTate;
                                c : WORD
                                ) : WORD;

FUNCTION DosSetNmPHandState(a, b: WORD) : WORD;

FUNCTION DosSetNmPipeSem(a : WORD;
                         b : SemaPhore;
                         c : WORD
                         ) : WORD;

FUNCTION DosTransactNmPipe(    a : WORD;
                               b : Pointer;
                               c : WORD;
                               d : Pointer;
                               e : WORD;
                           VAR f : WORD
                               ) : WORD;

FUNCTION DosWaitNmPipe(a : pChar;
                       b : LongInt {LONGCARD}) : WORD;

FUNCTION Dos16CallNmPipe(    a : pChar;
                             b : Pointer;
                             c : WORD;
                             d : Pointer;
                             e : WORD;
                         VAR f : WORD;
                             g :LongInt {LONGCARD}
                             ) : WORD;

FUNCTION Dos16ConnectNmPipe(a : WORD) : WORD;

FUNCTION Dos16DisConnectNmPipe(a : WORD) : WORD;

FUNCTION Dos16MakeNmPipe(    a : pChar;
                         VAR b : WORD;
                             c : WORD;
                             d : WORD;
                             e : WORD;
                             f : WORD;
                             g : LongInt {LONGCARD}
                             ) : WORD;

FUNCTION Dos16PeekNmPipe(a : WORD;
                         b : Pointer;
                         c : WORD;
                     VAR d : WORD;
                     VAR e : AvailData;
                     VAR f : WORD
                         ) : WORD;

FUNCTION Dos16QNmPHandState(    a : WORD;
                            VAR b : WORD
                                ) : WORD;

FUNCTION Dos16QNmPipeInfo(a : WORD;
                          b : WORD;
                          c : Pointer;
                          d : LongInt {LONGCARD}
                          ) : WORD;

FUNCTION Dos16QNmPipeSemState(    a : SemaPhore;
                              VAR b : PipesEmSTate;
                                  c : WORD
                                  ) : WORD;

FUNCTION Dos16SetNmPHandState(a, b: WORD): WORD;

FUNCTION Dos16SetNmPipeSem(a : WORD;
                           b : SemaPhore;
                           c : WORD
                           ) : WORD;

FUNCTION Dos16TransactNmPipe(    a : WORD;
                                 b : Pointer;
                                 c : WORD;
                                 d : Pointer;
                                 e : WORD;
                             VAR f : WORD
                                 ) : WORD;

FUNCTION Dos16WaitNmPipe(a : pChar;
                         b : LongInt {LONGCARD}
                         ) : WORD;

IMPLEMENTATION

  FUNCTION DosMakeNmPipe;      EXTERNAL 'NAMPipes' INDEX  1;
  FUNCTION Dos16MakeNmPipe;    EXTERNAL 'NAMPipes' INDEX  1;

  FUNCTION DosQNmPipeInfo;     EXTERNAL 'NAMPipes' INDEX  2;
  FUNCTION Dos16QNmPipeInfo;   EXTERNAL 'NAMPipes' INDEX  2;

  FUNCTION DosConnectNmPipe;   EXTERNAL 'NAMPipes' INDEX  3;
  FUNCTION Dos16ConnectNmPipe; EXTERNAL 'NAMPipes' INDEX  3;

  FUNCTION DosDisConnectNmPipe; EXTERNAL 'NAMPipes' INDEX 4;
  FUNCTION Dos16DisConnectNmPipe;
  EXTERNAL 'NAMPipes' INDEX 4;

  FUNCTION DosQNmPHandState;    EXTERNAL 'NAMPipes' INDEX 5;
  FUNCTION Dos16QNmPHandState;  EXTERNAL 'NAMPipes' INDEX 5;

  FUNCTION DosSetNmPHandState;  EXTERNAL 'NAMPipes' INDEX 6;
  FUNCTION Dos16SetNmPHandState;EXTERNAL 'NAMPipes' INDEX 6;

  FUNCTION DosPeekNmPipe;       EXTERNAL 'NAMPipes' INDEX 7;
  FUNCTION Dos16PeekNmPipe;     EXTERNAL 'NAMPipes' INDEX 7;

  FUNCTION DosWaitNmPipe;       EXTERNAL 'NAMPipes' INDEX 8;
  FUNCTION Dos16WaitNmPipe;     EXTERNAL 'NAMPipes' INDEX 8;

  FUNCTION DosTransactNmPipe;   EXTERNAL 'NAMPipes' INDEX 9;
  FUNCTION Dos16TransactNmPipe; EXTERNAL 'NAMPipes' INDEX 9;

  FUNCTION DosCallNmPipe;      EXTERNAL 'NAMPipes' INDEX 10;
  FUNCTION Dos16CallNmPipe;    EXTERNAL 'NAMPipes' INDEX 10;
{
  FUNCTION DosRawReadNMPipe;   External 'NAMPipes' INDEX 11;
  FUNCTION Dos16RawReadNMPipe; External 'NAMPipes' INDEX 11;

  FUNCTION DosRawWriteNMPipe;  External 'NAMPipes' INDEX 12;
  FUNCTION Dos16RawWriteNMPipe;External 'NAMPipes' INDEX 12;
}
  FUNCTION DosSetNmPipeSem;    EXTERNAL 'NAMPipes' INDEX 13;
  FUNCTION Dos16SetNmPipeSem;  EXTERNAL 'NAMPipes' INDEX 13;

  FUNCTION DosQNmPipeSemState; EXTERNAL 'NAMPipes' INDEX 14;
  FUNCTION Dos16QNmPipeSemState;
  EXTERNAL 'NAMPipes' INDEX 14;

END.

(* ====================================================== *)
(*                    Ende von NAMPIPES.PAS               *)
