(* ====================================================== *)
(*                       KBDCALLS.PAS                     *)
(*     Implementation of the funktionen of KBDCALLS.DLL   *)
(*          Translation to Pascal by jb/toolbox mag       *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT KbdCalls;

INTERFACE

USES
  Os2Def;

(* Keyboard handling procedures. Most of these procedures *)
(* are needed only for very special applications. You can *)
(* read the keyboard simply by using KbdCharIn with a     *)
(* handle of 0.                                           *)

(* The record type returned by KbdCharIn *)

CONST
  KR_KBDCHARIN                = 1;
  KR_KBDPEEK                  = 2;
  KR_KBDFLUSHBUFFER           = 4;
  KR_KBDGETSTATUS             = 8;
  KR_KBDSETSTATUS             = $10;
  KR_KBDSTRINGIN              = $20;
  KR_KBDOPEN                  = $40;
  KR_KBDCLOSE                 = $80;
  KR_KBDGETFOCUS              = $100;
  KR_KBDFREEFOCUS             = $200;
  KR_KBDGETCP                 = $400;
  KR_KBDSETCP                 = $800;
  KR_KBDXLATE                 = $1000;
  KR_KBDSETCUSTXT             = $2000;

  IO_WAIT     = 0;
  IO_NOWAIT   = 1;

  KEYBOARD_AT_COMPATIBLE      = 1;
  KEYBOARD_ENHANCED_101       = $0AB41;
  KEYBOARD_ENHANCED_102       = $0AB41;
  KEYBOARD_ENHANCED_122       = $0AB85;
  KEYBOARD_SPACESAVER         = $0AB54;


TYPE
  KbdKeyInfo = RECORD
    chChar      : CHAR;
    chScan      : CHAR;
    fbStatus    : CHAR;
    bNlsShift   : CHAR;
    fsState     : WORD;
    time        : LongInt; (* LONGCARD *)
  END;

  StringInBuf = RECORD
    cb      : WORD;
    cchIn   : WORD;
  END;

  KbdHWid = RECORD
    cb      : WORD;
    idKbd   : WORD;
    usRes1  : WORD;
    usRes2  : WORD;
  END;

  KbdTrans = RECORD
    chChar          : CHAR;
    chScan          : CHAR;
    fbStatus        : CHAR;
    bNlsShift       : CHAR;
    fsState         : WORD;
    time            : LongInt (* LONGCARD *);
    fsDD            : WORD;
    fsXlate         : WORD;
    fsShift         : WORD;
    sZero           : WORD;
  END;

  KbdInfo = RECORD
    cb              : WORD;
    fsMask          : BYTE (* BITSET *);
    chTurnAround    : WORD;
    fsInterim       : WORD;
    fsState         : BYTE (* BITSET *);
  END;

(* This record type is used in the KbdGetStatus and *)
(* KbdSetStatus procedures                          *)

TYPE
  KbdStatus = RECORD
    Size           : WORD;   (* size of structure,        *)
                             (* including size            *)
    Mask           : BYTE (* BITSET*); (* mode bits       *)
    TurnaroundChar : WORD;   (* the RETURN char           *)
    InterimFlags   : WORD;   (* 5 -> on-the-spot          *)
                             (*      conversion req       *)
                             (* 7 -> interim character    *)
                             (*      flag                 *)
                             (* 8..15 -> NLS Shift State  *)
    ShiftState     : BYTE (*BITSET *); (* as above exc,   *)
                                       (* only bits 0..7  *)
  END;

(* the Mask field in above record has the following       *)
(* bits defined                                           *)

CONST
  EchoOn              = 0;
  EchoOff             = 1;
  RawMode             = 2;
  CookedMode          = 3;
  ModifyShiftState    = 4; (* set if shift state should   *)
                           (* be modified                 *)
  ModifyInterimFlags  = 5; (* set if interim flags should *)
                           (* be modified                 *)
  ModifyTurnaround    = 6; (* set if turnaround char      *)
                           (* should be modified          *)
  TurnaroundExtended  = 7; (* set if turnaround char is   *)
                           (* extended char               *)

(* Bit definitions for ShiftState *)

CONST
  RightShiftDown      = 0;
  LeftShiftDown       = 1;
  EitherControlDown   = 2;
  EitherAltDown       = 3;
  ScrollLockOn        = 4;
  NumLockOn           = 5;
  CapsLockOn          = 6;
  InsertOn            = 7;
  LeftControlDown     = 8;
  LeftAltDown         = 9;
  RightControlDown    = 10;
  RightAltDown        = 11;
  ScollLockDown       = 12;
  NumLockDown         = 13;
  CapsLockDown        = 14;
  SysReqDown          = 15;


(* Read a character from the keyboard *)

FUNCTION KbdCharIn(VAR Data     : KbdKeyInfo;
                                     (* the returned info *)
                       IOWait   : WORD;
                                (* 0 -> wait, 1 -> nowait *)
                       KbdHandle: WORD) : WORD;
                               (* logical keyboard handle *)
FUNCTION Kbd16CharIn(VAR Data     : KbdKeyInfo;
                                     (* the returned info *)
                         IOWait   : WORD;
                                (* 0 -> wait, 1 -> nowait *)
                         KbdHandle: WORD) : WORD;
                               (* logical keyboard handle *)



(* Close a logical keyboard *)
FUNCTION KbdClose(  Handle: WORD) : WORD;
FUNCTION Kbd16Close(Handle: WORD) : WORD;
                    (* logical keyboard handle *)


(* De-register a keyboard subsystem *)

FUNCTION KbdDeRegister: WORD;
FUNCTION Kbd16DeRegister: WORD;

(* Flush the keystroke buffer *)

FUNCTION KbdFlushBuffer(  KbdHandle: WORD) : WORD;
FUNCTION Kbd16FlushBuffer(KbdHandle: WORD) : WORD;
                           (* must be zero *)


(* Release the keyboard focus *)

FUNCTION KbdFreeFocus(  KbdHandle: WORD) : WORD;
FUNCTION Kbd16FreeFocus(KbdHandle: WORD) : WORD;
                        (* logical keyboard handle *)

    
(* Get the keyboard focus *)

FUNCTION KbdGetFocus(IOWait   : WORD; { 0 -> wait, 1 -> nowait  }
                     KbdHandle: WORD  { logical keyboard handle }
                                    ) : WORD;
FUNCTION Kbd16GetFocus(IOWait   : WORD; { 0 -> wait, 1 -> nowait  }
                       KbdHandle: WORD  { logical keyboard handle }
                                      ) : WORD;

(* Get the keyboard status *)

FUNCTION KbdGetStatus(Status    : KbdInfo; (* the returned info *)
                      KbdHandle : WORD     (* the keyboard handle *)
                               ): WORD;
FUNCTION Kbd16GetStatus(Status    : KbdInfo; (* the returned info *)
                        KbdHandle : WORD     (* the keyboard handle *)
                                 ): WORD;

(* Get the code page currently in use *)

FUNCTION KbdGetCP(    Reserved   : LongInt; (* must be zero *)
                  VAR CodePageID : WORD;    (* the returned code page *)
                      KbdHandle  : WORD     (* the logical keyboard handle *)
                                 ): WORD;
FUNCTION Kbd16GetCP(  Reserved   : LongInt; (* must be zero *)
                  VAR CodePageID : WORD;    (* the returned code page *)
                      KbdHandle  : WORD     (* the logical keyboard handle *)
                                ): WORD;

(* Open a logical keyboard *)

FUNCTION KbdOpen(VAR KbdHandle: WORD) : WORD;
                 (*  ^^^ the returned handle *)
FUNCTION Kbd16Open(VAR KbdHandle: WORD) : WORD;
                   (*  ^^^ the returned handle *)


(* Get keyboard data without removing it from the buffer *)

FUNCTION KbdPeek(VAR Data      : KbdKeyInfo; (* the returned character data *)
                     KbdHandle : WORD        (* logical keyboard handle *)
                             ) : WORD;
FUNCTION Kbd16Peek(VAR Data      : KbdKeyInfo; (* the returned character data *)
                       KbdHandle : WORD        (* logical keyboard handle *)
                               ) : WORD;

(* Register a keyboard subsystem.  This allows you to specify a procedure *)
(* in a dynamic link library that is called for various keyboard functions *)

FUNCTION KbdRegister(ModuleName  : pChar;   (* library module name *)
                     EntryPoint  : pChar;   (* name of procedure to call *)
                     FunctionMask: LongInt  (* LONGCARD *)
                                            (* functions handled by procedure *)
                               ) : WORD;
FUNCTION Kbd16Register(ModuleName  : pChar;   (* library module name *)
                       EntryPoint  : pChar;   (* name of procedure to call *)
                       FunctionMask: LongInt  (* LONGCARD *)
                                              (* functions handled by procedure *)
                                 ) : WORD;

(* Associates a translate table with a logical keyboard *)

FUNCTION KbdSetCP(codepage  : Pointer; (* address of the translate table *)
                  KbdHandle : WORD     (* logical keyboard handle        *)
                           ): WORD;
FUNCTION Kbd16SetCP(codepage  : Pointer; (* address of the translate table *)
                    KbdHandle : WORD     (* logical keyboard handle        *)
                             ): WORD;

(* Raise the priority of the foreground keyboard's thread.  To be *)
(* used only by the keyboard subsystem, not an application *)

FUNCTION KbdSetFgnd  : WORD;
FUNCTION Kbd16SetFgnd: WORD;

(* Set the keyboard status *)

FUNCTION KbdSetStatus(Status   : KbdInfo; (* the new status settings *)
                      KbdHandle: WORD     (* the logical keyboard handle *)
                              ): WORD;
FUNCTION Kbd16SetStatus(Status   : KbdInfo; (* the new status settings *)
                        KbdHandle: WORD     (* the logical keyboard handle *)
                                ): WORD;

(* Read a string from the keyboard *)

FUNCTION KbdStringIn(    CharBuffer : Pointer;  (* address of the string buffer *)
                     VAR a          : StringInBuf;
                         IOWait     : WORD;     (* 0 -> wait, 1 -> nowait *)
                         KbdHandle  : WORD      (* Logical keyboard handle *)
                                   ): WORD;
FUNCTION Kbd16StringIn(    CharBuffer : Pointer;  (* address of the string buffer *)
                       VAR a          : StringInBuf;
                           IOWait     : WORD;     (* 0 -> wait, 1 -> nowait *)
                           KbdHandle  : WORD      (* Logical keyboard handle *)
                                     ): WORD;

(* Translate a scan code and shift state into a character *)

FUNCTION KbdXlate(VAR XlateRec  : KbdTrans; (* the above record *)
                      KbdHandle : WORD      (* logical keyboard handle *)
                              ) : WORD;
FUNCTION Kbd16Xlate(VAR XlateRec  : KbdTrans; (* the above record *)
                        KbdHandle : WORD      (* logical keyboard handle *)
                                ) : WORD;

FUNCTION KbdGetHWID(  VAR a : KbdHWid; b : WORD) : WORD;
FUNCTION Kbd16GetHWID(VAR a : KbdHWid; b : WORD) : WORD;

FUNCTION KbdSetCustXt(VAR a : WORD; b : WORD) : WORD;
FUNCTION Kbd16SetCustXt(VAR a : WORD; b : WORD) : WORD;



IMPLEMENTATION

  FUNCTION KbdSetCustXt;      EXTERNAL 'KbdCalls' INDEX   1;
  FUNCTION Kbd16SetCustXt;    EXTERNAL 'KbdCalls' INDEX   1;

(* ====================================================== *)

  FUNCTION KbdGetCP;          EXTERNAL 'KbdCalls' INDEX   3;
  FUNCTION Kbd16GetCP;        EXTERNAL 'KbdCalls' INDEX   3;

  FUNCTION KbdCharIn;         EXTERNAL 'KbdCalls' INDEX   4;
  FUNCTION Kbd16CharIn;       EXTERNAL 'KbdCalls' INDEX   4;

  FUNCTION KbdSetCP;          EXTERNAL 'KbdCalls' INDEX   5;
  FUNCTION Kbd16SetCP;        EXTERNAL 'KbdCalls' INDEX   5;

{ nicht implementiert:
  FUNCTION KbdSynch;          External 'KbdCalls' INDEX   7;
  FUNCTION Kbd16Synch;        External 'KbdCalls' INDEX   7;
}
  FUNCTION KbdRegister;       EXTERNAL 'KbdCalls' INDEX   8;
  FUNCTION Kbd16Register;     EXTERNAL 'KbdCalls' INDEX   8;

  FUNCTION KbdStringIn;       EXTERNAL 'KbdCalls' INDEX   9;
  FUNCTION Kbd16StringIn;     EXTERNAL 'KbdCalls' INDEX   9;

  FUNCTION KbdGetStatus;      EXTERNAL 'KbdCalls' INDEX  10;
  FUNCTION Kbd16GetStatus;    EXTERNAL 'KbdCalls' INDEX  10;

  FUNCTION KbdSetStatus;      EXTERNAL 'KbdCalls' INDEX  11;
  FUNCTION Kbd16SetStatus;    EXTERNAL 'KbdCalls' INDEX  11;

  FUNCTION KbdGetFocus;       EXTERNAL 'KbdCalls' INDEX  12;
  FUNCTION Kbd16GetFocus;     EXTERNAL 'KbdCalls' INDEX  12;

  FUNCTION KbdFlushBuffer;    EXTERNAL 'KbdCalls' INDEX  13;
  FUNCTION Kbd16FlushBuffer;  EXTERNAL 'KbdCalls' INDEX  13;

  FUNCTION KbdXlate;          EXTERNAL 'KbdCalls' INDEX  14;
  FUNCTION Kbd16Xlate;        EXTERNAL 'KbdCalls' INDEX  14;

(* ====================================================== *)

  FUNCTION KbdClose;          EXTERNAL 'KbdCalls' INDEX  17;
  FUNCTION Kbd16Close;        EXTERNAL 'KbdCalls' INDEX  17;

  FUNCTION KbdFreeFocus;      EXTERNAL 'KbdCalls' INDEX  18;
  FUNCTION Kbd16FreeFocus;    EXTERNAL 'KbdCalls' INDEX  18;

(* ====================================================== *)

  FUNCTION KbdDeRegister;     EXTERNAL 'KbdCalls' INDEX  20;
  FUNCTION Kbd16DeRegister;   EXTERNAL 'KbdCalls' INDEX  20;

  FUNCTION KbdSetFgnd;        EXTERNAL 'KbdCalls' INDEX  21;
  FUNCTION Kbd16SetFgnd;      EXTERNAL 'KbdCalls' INDEX  21;

  FUNCTION KbdPeek;           EXTERNAL 'KbdCalls' INDEX  22;
  FUNCTION Kbd16Peek;         EXTERNAL 'KbdCalls' INDEX  22;

  FUNCTION KbdOpen;           EXTERNAL 'KbdCalls' INDEX  23;
  FUNCTION Kbd16Open;         EXTERNAL 'KbdCalls' INDEX  23;

  FUNCTION KbdGetHWID;        EXTERNAL 'KbdCalls' INDEX  24;
  FUNCTION Kbd16GetHWID;      EXTERNAL 'KbdCalls' INDEX  24;

{  not implemented:
  FUNCTION KbdSetHWid;        External 'KbdCalls' INDEX  25;
  FUNCTION Kbd16SetHWid;      External 'KbdCalls' INDEX  25;
}

END.

(* ====================================================== *)
(*                  Ende von KBDCALLS.PAS                 *)
