(* ====================================================== *)
(*                        BDCALLS.PAS                     *)
(*    Implementation of the functions of BDCALLS.DLL      *)
(*                OS/2 Bidi public header file.           *)
(*          Translation to Pascal by wr/toolbox mag       *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT BDCalls;

INTERFACE

USES
  Os2Def;


(*******  BidiHotKeys in BIDISTRUCT ***********************)
(*                                                        *)
(* The following defined value may be used to             *)
(* Enable/Disable the Bidi keyboard hot keys.             *)
(* To enable a hot key, perform an 'OR' operation on the  *)
(* Bidi hot key flag word in the KBVCBTYPE  structure     *)
(* with the required defined value.  To disable a hot key,*)
(* perform an 'AND NOT' operation on the Bidi hot key     *)
(* flag word in the KBVCBTYPE  structure with the         *)
(* required defined value.                                *)
(*                                                        *)
(**********************************************************)

CONST
  BDHKFLAG_PUSH         = $0004;
  BDHKFLAG_END_PUSH     = $0008;
  BDHKFLAG_AUTO_PUSH    = $0010;
  BDHKFLAG_FIELD_REV    = $0020;
  BDHKFLAG_SCREEN_REV   = $0040;
  BDHKFLAG_BIDI_POPUP   = $0200;
  BDHKFLAG_AUTOMATIC    = $0400;
  BDHKFLAG_INITIAL      = $0800;
  BDHKFLAG_MIDDLE       = $1000;
  BDHKFLAG_FINAL        = $2000;
  BDHKFLAG_ISOLATED     = $4000;

(***********  Bidi Flags in BIDISTRUCT ********************)
(*                                                        *)
(* The following defined value may be used to             *)
(* Enable/Disable the Bidi functions.                     *)
(* To enable a Bidi function, perform an 'OR' operation   *)
(* on the Bidi flags word in the BDKBVCB  structure with  *)
(* the required defined value.                            *)
(* To disable a Bidi fuction, perform an 'AND NOT'        *)
(* operation on the Bidi flags word in the BDKBVCB        *)
(* structure with the required defined value.             *)
(*                                                        *)
(**********************************************************)

CONST
  BDFLAG_AUTOPUSH_RTL   = $0001;
  BDFLAG_AUTOPUSH_LTR   = $0002;
  BDFLAG_PUSHLEVEL      = $0004;
  BDFLAG_LAYER          = $0010;
  BDFLAG_FIELD_REV      = $0020;

(********************* CSD in BIDIATT *********************)
(*                                                        *)
(* The following defined value may be used to select the  *)
(* specified                                              *)
(* bit in the Bidi Attributes.                            *)
(*                                                        *)
(**********************************************************)

CONST
  BDCSD_AUTOMATIC   =   $00000000;
  BDCSD_PASSTHRU    =   $00000001;
  BDCSD_BASE        =   $00000010;
  BDCSD_INITIAL     =   $00000011;
  BDCSD_MIDDLE      =   $00000012;
  BDCSD_FINAL       =   $00000013;
  BDCSD_ISOLATED    =   $00000014;
  BDNUM_ARABIC      =   $00000000;
  BDNUM_PASSTHRU    =   $00001000;
  BDNUM_HINDU       =   $00002000;
  BDORIENT_LTR      =   $00000000;
  BDORIENT_RTL      =   $00010000;
  BD_LEVEL          =   $30000000;
  BD_SUPPORT        =   $00000000;


(*********** the keyboard control block structure *********)

TYPE
  BdKvcB   = RECORD
    BDLength      : WORD;
    BDVersionId   : WORD;
    BDAtts        : WORD;
    Reserved      : WORD;
    BDHotKeyFlags : WORD;
    BDFlags       : WORD;
    Reserved2     : ARRAY[0..64] OF BYTE;
  END;


(******* the printer control block structure **************)
TYPE
  BdPrcb  = RECORD
    PRLength : WORD ;
    PRAtts   : LongInt;
    Reserved : ARRAY [0..14] OF BYTE;
  END;

(***** the Character Shape Determination structure *********)

TYPE
  Char16    = ARRAY[0..16] OF CHAR;
  pChar16   = ^Char16;

  UChar16   = ARRAY[0..16] OF BYTE;
  pUChar16  = ^UChar16;

  CSDRec = RECORD
    RecLength    : LONGINT;
    Buffer       : Char16;
    BufferLength : LONGINT;
    BufferIndex  : LONGINT;
  END;


  pCSDRec  = ^CSDRec; (* FAR16PTR *)
  pRetInfo = pBYTE;
  pSetInfo = pBYTE;


TYPE
  ApiRet16 = WORD; (* APIRET = ULong ????????????? *)
  FUNCTION NlsQueryBidiAtt(Effect: LongInt;
                           RetInfo: pRetInfo): ApiRet16;


  FUNCTION NlsSetBidiAtt(Effect  : LongInt;
                         SetInfo : pSetInfo): ApiRet16;


  FUNCTION NlsShapeBidiString(BidiAtts : LONGINT;
                              Reserved : LONGINT;
                              Source   : pChar16;
                              Target   : pChar16;
                              Length   : LONGINT;
                              Increment: LONGINT): ApiRet16;


  FUNCTION NlsEditShape (BidiAtts  : LONGINT;
                         Effect    : LongInt;
                         Source    : pCSDRec;
                         Target    : pCSDRec;
                         CSDState  : pULong;
                         Increment : LONGINT): ApiRet16;


  FUNCTION NlsInverseString(Source    : pChar16;
                            Target    : pChar16;
                            Length    : LONGINT;
                            Increment : LONGINT): ApiRet16;


  FUNCTION NlsConvertBidiNumerics(BidiAtts  : LONGINT;
                                  Reserved  : LongInt;
                                  Source    : pUChar16;
                                  Target    : pUChar16;
                                  Length    : LONGINT;
                                  Increment : LONGINT
                                           ): ApiRet16;


  FUNCTION NlsSetBidiPrint(BidiAtts   : LONGINT;
                           Length     : LONGINT;
                           FileHandle : WORD): ApiRet16;


  FUNCTION NlsConvertBidiString(Source   : pUChar16;
                                Target   : pUChar16;
                                Length,
                                Increment,
                                SBidiAtts,
                                TBidiAtts,
                                Reserved : LONGINT): ApiRet16;

  FUNCTION Nls16QueryBidiAtt(Effect  : LongInt;
                             RetInfo : pRetInfo): ApiRet16;


  FUNCTION Nls16SetBidiAtt (Effect : LongInt;
                          SetInfo  : pSetInfo): ApiRet16;


  FUNCTION Nls16ShapeBidiString(BidiAtts : LONGINT;
                              Reserved   : LONGINT;
                              Source     : pChar16;
                              Target     : pChar16;
                              Length     : LONGINT;
                              Increment  : LONGINT): ApiRet16;


  FUNCTION Nls16EditShape (BidiAtts  : LONGINT;
                         Effect      : LongInt;
                         Source      : pCSDRec;
                         Target      : pCSDRec;
                         CSDState    : pULong;
                         Increment   : LONGINT): ApiRet16;


  FUNCTION Nls16InverseString(Source    : pChar16;
                              Target    : pChar16;
                              Length    : LONGINT;
                              Increment : LONGINT): ApiRet16;


  FUNCTION Nls16ConvertBidiNumerics(BidiAtts : LONGINT;
                                    Reserved : LongInt;
                                    Source   : pUChar16;
                                    Target   : pUChar16;
                                    Length   : LONGINT;
                                    Increment: LONGINT
                                            ): ApiRet16;


  FUNCTION Nls16SetBidiPrint(BidiAtts   : LONGINT;
                             Length     : LONGINT;
                             FileHandle : WORD): ApiRet16;


  FUNCTION Nls16ConvertBidiString(Source    : pUChar16 ;
                                  Target    : pUChar16;
                                  Length    : LONGINT;
                                  Increment : LONGINT;
                                  SBidiAtts : LONGINT;
                                  TBidiAtts : LONGINT;
                                  Reserved  : LONGINT
                                           ): ApiRet16;

IMPLEMENTATION

  FUNCTION NlsConvertBidiNumerics;
    EXTERNAL 'BDCalls'INDEX  1;
  FUNCTION Nls16ConvertBidiNumerics;
    EXTERNAL 'BDCalls'INDEX  1;

  FUNCTION NlsConvertBidiString;EXTERNAL 'BDCalls' INDEX  2;
  FUNCTION Nls16ConvertBidiString;
    EXTERNAL 'BDCalls' INDEX  2;

{                 NOT      IMPLEMENTED
  FUNCTION NlsIntSetBidiAtt;    EXTERNAL 'BDCalls' INDEX  3;
  FUNCTION Nls16IntSetBidiAtt;  EXTERNAL 'BDCalls' INDEX  3;

  FUNCTION NlsIntQueryBidiAtt;  EXTERNAL 'BDCalls' INDEX  4;
  FUNCTION Nls16IntQueryBidiAtt;EXTERNAL 'BDCalls' INDEX  4;
}

  FUNCTION NlsSetBidiAtt;       EXTERNAL 'BDCalls' INDEX  5;
  FUNCTION Nls16SetBidiAtt;     EXTERNAL 'BDCalls' INDEX  5;

  FUNCTION NlsQueryBidiAtt;     EXTERNAL 'BDCalls' INDEX  6;
  FUNCTION Nls16QueryBidiAtt;   EXTERNAL 'BDCalls' INDEX  6;

  FUNCTION NlsInverseString;    EXTERNAL 'BDCalls' INDEX  7;
  FUNCTION Nls16InverseString;  EXTERNAL 'BDCalls' INDEX  7;

  FUNCTION NlsSetBidiPrint;     EXTERNAL 'BDCalls' INDEX  8;
  FUNCTION Nls16SetBidiPrint;   EXTERNAL 'BDCalls' INDEX  8;

  FUNCTION NlsEditShape;        EXTERNAL 'BDCalls' INDEX  9;
  FUNCTION Nls16EditShape;      EXTERNAL 'BDCalls' INDEX  9;

  FUNCTION NlsShapeBidiString;  EXTERNAL 'BDCalls' INDEX 10;
  FUNCTION Nls16ShapeBidiString;EXTERNAL 'BDCalls' INDEX 10;

{                       NOT   IMPLEMENTED
  FUNCTION NlPopup;             EXTERNAL 'BDCalls' INDEX 11;
  FUNCTION Nl16Popup;           EXTERNAL 'BDCalls' INDEX 11;
}
END.

(* ====================================================== *)
