(*========================================================*)
(*               ABSOLUTE.PAS Version 2.10                *)
(*       Copyright (c) 1991-95 J. Braun & DMV-Verlag      *)
(*       IF you use Turbo/BP 7 set VER60 in the IDE!      *)
(*--------------------------------------------------------*)

{$A+,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{$IFDEF VER60} {$X-,G-} {$ENDIF}

UNIT ABSOLUTE;

INTERFACE

CONST
  MaxBufSize   = 511;

TYPE
  tSectBuffer = ARRAY[0..MaxBufSize] OF BYTE;
  tSystems    = (none, IBM, MsDos, OS2, DRS, MOS, PLS, OS1, Win95);
  tDrives     = (Actual, A, B, C, D, E, F);
  tBPB        = RECORD
                  BytesPerSector    : WORD;
                  SectorsPerCluster : WORD;
                  ReservedSectors   : WORD;
                  NumberOfFATs      : BYTE;
                  RootEntries       : WORD;
                  TotalSectors      : WORD;
                  MediaDescriptor   : BYTE;
                  SectorsPerFAT     : WORD;
                  SectorsPerTrack   : WORD;
                  Heads             : WORD;
                  HiddenSectors     : LONGINT;
                  BigTotalSectors   : LONGINT;
                  Reserved          : ARRAY [1..6] OF BYTE;
                END;

CONST
  SysDir   : STRING[67] = 'C:\SYSTEM'; (* Sicherungsverzeichnis *)
                                       (* NUR HIER NDERN !     *)
  BootFile : STRING[5] = 'BOOT.';
  PartFile : STRING[5] = 'PART.';

  SysCount = Win95; (* Anzahl der Systeme. Nur hier ndern   *)
                   (* und die folgenden Arrays entsprechend *)
                   (* anpassen.                             *)

(* Kennungen im Bootsektor:                                *)
  SysIDs : ARRAY[tSystems] OF STRING[10]
     = ('',             (* none / Dummy               *)
        'IBMBIOCOM',    (* PC-DOS, DR-DOS 5, OS/2 1.0 *)
        'IOSYS',        (* MS-DOS                     *)
        'OS2LDR',       (* OS/2 ab V. 1.2             *)
        'DRBIOSSYS',    (* DR-DOS 3.41                *)
        '$$MOSSYS',     (* PC-MOS 4.0                 *)
        'DOSPLUSSYS',   (* Digital Research DOS-Plus  *)
        'OS2BIOCOM',    (* OS/2 V. 1.1                *)
        'IOSYS');       (* Windows '95                *)

  SysIDNames: ARRAY[tSystems] OF STRING[11]
     = ('',             (* none / Dummy               *)
        'IBMDOS.COM',   (* PC-DOS, DR-DOS 5, OS/2 1.0 *)
        'MSDOS.SYS',    (* MS-DOS                     *)
        'OS2LDR',       (* OS/2 ab V. 1.2             *)
        'DRBDOS.SYS',   (* DR-DOS 3.41                *)
        '$$SHELL.SYS',  (* PC-MOS 4.0                 *)
        'DOSPLUS.SYS',  (* Digital Research DOS-Plus  *)
        'OS2BIO.COM',   (* OS/2 V. 1.1                *)
        'MSDOS.SYS');   (* Windows '95                *)

(* Die erlaubten Kommandozeilenparameter:             *)
Systems : ARRAY[tSystems] OF STRING[3]
     = ('',     (* none / Dummy    *)
        'IBM',     (* PC-DOS, DR-DOS 5.0, OS/2 1.0 *)
        'DOS',     (* MS-DOS          *)
        'OS2',     (* MS-OS/2         *)
        'DRS',     (* DR-DOS 3.41     *)
        'MOS',     (* PC-MOS 4.0      *)
        'PLS',     (* DOS-Plus 1.2    *)
        'OS1',     (* IBM BS/2 V. 1.1 *)
        'WIN');    (* Windows '95     *)

(* Namen fr die Ausgaben des Programms:           *)
  Names : ARRAY [tSystems] OF STRING[12]
     = ('unbekannt',
        'IBM PC-DOS', (* inklusive DR-DOS 5.0      *)
        'MS-DOS',
        'OS/2 1.2/1.3',
        'DR-DOS',
        'PC-MOS/386',
        'DOS-Plus 1.2',
        'OS/2 1.1',
        'Windows ''95');

(* Meldungen:                                      *)
  ParamMsg : ARRAY[tSystems] OF STRING[23]
     = ('nicht gefunden!',
        'PC-DOS sowie DR-DOS 5/6',
        'MS-DOS',
        'OS/2 V. 1.2',
        'DR-DOS 3.41',
        'PC-MOS/386',
        'DOS-Plus 1.2',
        'OS/2 V. 1.1',
        'Windows ''95');

PROCEDURE ReadBootSector  (Drive: tDrives; VAR Buffer);
PROCEDURE WriteBootSector (Drive: tDrives; VAR Buffer);

PROCEDURE ReadPartition   (Drive: tDrives; VAR Buffer);
PROCEDURE WritePartition  (Drive: tDrives; VAR Buffer);

IMPLEMENTATION

USES 
  Dos;

TYPE
  pLayoutList = ^tLayoutList;

  tLayoutList = RECORD
    SectorNumber : WORD;
    SectorSize   : WORD;
    Next         : pLayoutList;
  END;

  tTrackLayout = RECORD
    SectorCount : WORD;
    Sectors     : pLayoutList;
  END;

  tDeviceParams = RECORD
    SpecialFunctions : BYTE;
    DeviceType       : BYTE;
    DeviceAttributes : WORD;
    Cylinders        : WORD;
    MediaType        : BYTE;
    DeviceBPB        : tBPB;
    TrackLayOut      : tTrackLayout;
  END;

  tR_W_Block = RECORD
    SpecialFunctions : BYTE;
    Head             : WORD;
    Cylinder         : WORD;
    FirstSector      : WORD;
    NumberOfSectors  : WORD;
    TransferAddress  : Pointer;
  END;


CONST
  GetParameters : BYTE    = $60;
  SetParameters : BYTE    = $40;
  WriteTrack    : BYTE    = $41;
  ReadTrack     : BYTE    = $61;
  FormatTrack   : BYTE    = $42;
  VerifyTrack   : BYTE    = $62;
  SetAccessFlag : BYTE    = $47;
  GetAccessFlag : BYTE    = $67;
  Dos330        =           $31E;

VAR
  SavedParams : ARRAY [tDrives] OF tDeviceParams;
  Regs        : Registers;
  IO_Error         : INTEGER;

FUNCTION CheckVersion: WORD;
VAR
  ver: WORD;
BEGIN
  ver := DosVersion;
  CheckVersion := Swap(ver);
END;

PROCEDURE Disp_IO_Error;
BEGIN
  WriteLn('An error occured, program halted!');
  Halt(1);
END;

PROCEDURE IO_Generic(Drive : tDrives; What : BYTE; VAR Struct);
VAR
  Regs : Registers;
BEGIN
  Regs.AH := $44;
  Regs.AL := $0D;
  Regs.BL := Ord(Drive);
  Regs.CH := $08;      (* Category (always $08) *)
  Regs.CL := What;
  Regs.DS := Seg(Struct);
  Regs.DX := Ofs(Struct);
  Intr($21, Regs);
  IF (Regs.Flags AND FCarry) = 0 THEN
    IO_Error := 0
  ELSE
    IO_Error := Regs.AX;
END;

PROCEDURE DiskRead(Drive                 : tDrives;
                   Head, Cyl, First, Num : WORD;
                   VAR Buffer);
VAR
  RW : tR_W_Block;
BEGIN
  RW.SpecialFunctions := 0;
  RW.Head             := Head;
  RW.Cylinder         := Cyl;
  RW.FirstSector      := First - 1;
  RW.NumberOfSectors  := Num;
  RW.TransferAddress  := Addr(Buffer);
  IO_Generic(Drive, ReadTrack, RW);
  IF IO_Error <> 0 THEN Disp_IO_Error;
END;

PROCEDURE DiskWrite(Drive                 : tDrives;
                    Head, Cyl, First, Num : WORD;
                    VAR Buffer);
VAR
  RW : tR_W_Block;
BEGIN
  RW.SpecialFunctions := 0;
  RW.Head             := Head;
  RW.Cylinder         := Cyl;
  RW.FirstSector      := First-1;
  RW.NumberOfSectors  := Num;
  RW.TransferAddress  := Addr(Buffer);
  IO_Generic(Drive, WriteTrack, RW);
  IF IO_Error <> 0 THEN Disp_IO_Error;
END;

PROCEDURE BIOSRead(Drive                 : tDrives;
                   Head, Cyl, First, Num : WORD;
                   VAR Buffer);
BEGIN
  WITH Regs DO BEGIN
    AH := 2;
    AL := Num;
    CH := Cyl;
    CL := First;
    DH := Head;
    IF Drive < C THEN
      DL := BYTE(Drive)
    ELSE
      DL := BYTE(Drive) + $80 - BYTE(C);
    ES := Seg(Buffer);
    BX := Ofs(Buffer);
    Intr($13, Regs);
  END;
END;

PROCEDURE BIOSWrite(Drive                 : tDrives;
                    Head, Cyl, First, Num : WORD;
                    VAR Buffer);
BEGIN
  WITH Regs DO BEGIN
    AH := 3;
    AL := Num;
    CH := Cyl;
    CL := First;
    DH := Head;
    IF Drive < C THEN
      DL := BYTE(Drive)
    ELSE
      DL := BYTE(Drive) + $80 - BYTE(C);
    ES := Seg(Buffer);
    BX := Ofs(Buffer);
    Intr($13, Regs);
  END;
END;

PROCEDURE ReadBootSector(Drive: tDrives; VAR Buffer);
BEGIN
  IF Drive < C THEN BEGIN
    IF CheckVersion < Dos330 THEN
      BIOSRead(Drive, 0, 0, 1, 1, Buffer)
    ELSE
      DiskRead(Drive, 0, 0, 1, 1, Buffer)
  END ELSE BEGIN
    IF CheckVersion < Dos330 THEN
      BIOSRead(Drive, 1, 0, 1, 1, Buffer)
    ELSE
      DiskRead(Drive, 1, 0, 1, 1, Buffer)
    END;
END;

PROCEDURE WriteBootSector(Drive: tDrives; VAR Buffer);
BEGIN
  IF Drive < C THEN BEGIN
    IF CheckVersion < Dos330 THEN
      BIOSWrite(Drive, 0, 0, 1, 1, Buffer)
    ELSE
      DiskWrite(Drive, 0, 0, 1, 1, Buffer);
  END ELSE BEGIN
    IF CheckVersion < Dos330 THEN
      BIOSWrite(Drive, 1, 0, 1, 1, Buffer)
    ELSE
      DiskWrite(Drive, 1, 0, 1, 1, Buffer);
  END;
END;

PROCEDURE ReadPartition(Drive: tDrives; VAR Buffer);
BEGIN
  IF CheckVersion < Dos330 THEN
    BIOSRead(Drive, 0, 0, 1, 1, Buffer)
  ELSE
    DiskRead(Drive, 0, 0, 1, 1, Buffer);
END;

PROCEDURE WritePartition(Drive: tDrives; VAR Buffer);
BEGIN
  IF CheckVersion < Dos330 THEN
    BIOSWrite(Drive, 0, 0, 1, 1, Buffer)
  ELSE
    DiskWrite(Drive, 0, 0, 1, 1, Buffer);
END;

END.

(*========================================================*)
(*                  Ende von ABSOLUTE.PAS                 *)
