/* A simple demo program to show the use of the bgi driver in C              */
/* Copyright (C)1990 by Peter F. Jones. ALL RIGHTS RESERVED                  */
/* Note: you must link it to ativw256.obj which has the autodetect function. */



#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <math.h>
#include <graphics.h>
#include "ativw256.h"



void triangle(int x1, int y1,  int x2,  int y2,  int x3, int y3)
{
 int tri[8];

   tri[0] = x1;
   tri[1] = y1;
   tri[2] = x2;
   tri[3] = y2;
   tri[4] = x3;
   tri[5] = y3;
   tri[6] = x1;
   tri[7] = y1;

   fillpoly(4,tri);

};


main()
{

int driver,mode;
int counter;
int xc,yc,x1,y1,x2,y2;
float scale,angle_factor;
int r,g,b;
float angle_offset,angle_offset_r,angle_offset_g,angle_offset_b;
float angle;

char far *driver_name;


driver = installuserdriver("ativw256",detect_ATI_VGA_Wonder);
if (grOk !=graphresult())
   {
     printf("Error in installing ATI VGA Wonder Driver\n");
     exit(1);
   };

driver = DETECT;
initgraph(&driver,&mode,"");
if (grOk !=graphresult())
   {
     printf("Error in init\n");
     exit(1);
   };

   xc = getmaxx()/2;
   yc = getmaxy()/3;


  driver_name = getdrivername();
  xc = xc - (  textwidth("Driver Name: ")+textwidth(driver_name) )/2;
  setcolor(WHITE);
  outtextxy(xc,yc,"Driver Name: ");
  xc = xc + textwidth("Driver Name: ");
  outtextxy(xc,yc,driver_name);


  xc = getmaxx()/2;
  yc = getmaxy()/2;
  scale = getmaxy()/2;
  angle_factor = 2*3.14159/(float)(1+getmaxcolor());
  for(counter=0;counter<=getmaxcolor();counter++)
     {
       setcolor(counter);
       setfillstyle(SOLID_FILL,counter);
       x1 = xc + (int) (scale * cos( angle_factor * (double)counter));
       y1 = yc + (int) (scale * sin( angle_factor * (double)counter));

       x2 = xc + (int) (scale * cos( angle_factor * (double)(counter+1)));
       y2 = yc + (int) (scale * sin( angle_factor * (double)(counter+1)));
       triangle(xc,yc,x1,y1,x2,y2);
     }


angle_offset = 0.0;
while(!kbhit())
  {

  angle_offset_r  =   angle_offset;
  angle_offset_g  =   angle_offset +     2.0*3.14159/3.0;
  angle_offset_b  =   angle_offset + 2.0*2.0*3.14159/3.0;

  for(counter=0;counter<=getmaxcolor();counter++)
     {
       angle = angle_factor * (double)counter;
       r  =   (int) ((63.0/2.0) * (1.0+ cos(angle_offset_r + angle)));
       g  =   (int) ((63.0/2.0) * (1.0+ cos(angle_offset_g + angle)));
       b  =   (int) ((63.0/2.0) * (1.0+ cos(angle_offset_b + angle)));
       setrgbpalette(counter,r,g,b);
     }

angle_offset = angle_offset + 0.2;

  };




getch();
closegraph();
};

