

{$F+}
function detect_ATI_VGA_Wonder : integer;
{
This a standard autodetect function as outlines in the Turbo Pascal Manual.
If the card is detected, the highest available mode number is returned.
Otherwise a negative number indicating an error is returned.


copyright(c) 1990 by Peter F. Jones. ALL RIGHTS RESERVED.
This software may be used and included in other programs as
outlined in your software license.
}
const copyright1: string[60] = 'copyright(c) 1990 by Peter F. Jones. ALL RIGHTS RESERVED.';
function test_bios_mode(bios_mode:byte):boolean;
var AX : word;
  begin
       inline( $8A / $0846);  { mov al,[bp+8]   or  mov al,[bp+8]   or  bios_mode }
                              { al has desired mode on input           }
                              { on return ax = 0xffff if not supported }

       inline( $55        );  { push      bp           }
       inline( $8B / $EC  );  { mov       bp,sp        }
       inline( $06        );  { push      es           }
       inline( $B4 / $12  );  { mov       ah,12h       }
       inline( $BB / $5506);  { mov       bx,5506h     }
       inline( $BD / $FFFF);  { mov       bp,0ffffh    }
       inline( $CD / $10  );  { int       10h          }
       inline( $8B / $C5  );  { mov       ax,bp        }
       inline( $07        );  { pop       es           }
       inline( $5D        );  { pop       bp           }

       inline( $89 / $fc46);  { mov [bp-4],ax mov AX,ax    }


  test_bios_mode := AX<>$FFFF;

end;

function test_512K_memory:boolean;
var AX : word;
  begin


     inline($06);              {    push es         ;save registers es and bx                     }
     inline($53);              {    push bx                                                       }
     inline($B8 / $C000);      {    mov  ax,0c000h  ;define storage location of EXTENDED_REG      }
     inline($8E / $C0);        {    mov  es,ax                                                    }
     inline($BB / $10 / $00);  {    mov  bx,10h                                                   }
     inline($26 / $8B / $17);  {    mov  dx,es:[bx] ;get the value of EXTENDED_REG from contents  }
                               {                    ;of the storage location C000:0010h           }
     inline($5B);              {    pop  bx         ;restore registers es and bx                  }
     inline($07);              {    pop  es                                                       }
     inline($FA);              {    cli                                                           }
                               {                    ;mov       dx,EXTENDED_REG                    }
     inline($B0 / $BB);        {    mov       al,0bbh                                             }
     inline($EE);              {    out       dx,al                                               }
     inline($42);              {    inc       dx                                                  }
     inline($EC);              {    in        al,dx                                               }
     inline($FB);              {    sti                                                           }
     inline($24 / $20);        {    and       al,020h                                             }

     inline( $89 / $fc46);     {    mov [bp-4],ax mov AX,ax                                       }


    test_512K_memory := (AX and $20)<>0;



end;
   type manufacturer_type = array[0..8] of char;
   var found : boolean;
       manufacturer : ^manufacturer_type;
       chip_set : ^manufacturer_type;
       counter : integer;
   const manufacturer_id : string[9] = '761295520';
   const chip_set_id : string[2] = '31';


     begin
        detect_ATI_VGA_Wonder := -11;   {return error if not found}

        found := true;
        manufacturer := ptr($C000,$31);
        chip_set     := ptr($C000,$40);

        for counter := 0 to 8 do
          if manufacturer^[counter] <> manufacturer_id[counter+1] then found := false;
        if not found then exit;        {return error}
        for counter := 0 to 1 do
          if chip_set^[counter] <> chip_set_id[counter+1] then found := false;
        if not found then exit;        {return error}

       if test_512K_memory then  {if 512k then try hires modes}
          begin
             if test_bios_mode($63) then  {check 800x600}
                  begin
                     detect_ATI_VGA_Wonder := 3;
                     exit;
                  end;

             if test_bios_mode($62) then  {check 640x480}
                  begin
                     detect_ATI_VGA_Wonder := 2;
                     exit;
                  end;
          end;

             if test_bios_mode($61) then  {check 640x400}
                  begin
                     detect_ATI_VGA_Wonder := 1;
                     exit;
                  end;

             if test_bios_mode($13) then  {check 320x200}
                  begin
                     detect_ATI_VGA_Wonder := 0;
                     exit;
                  end;
     end;
{$F-}


