/*  Project main
	 ITD
	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    main.exe Application
	 FILE:         mainapp.cpp
	 AUTHOR:       TK


    OVERVIEW
	 ========
	 Source file for implementation of mainApp (TApplication).
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "mainapp.h"
#include "mnabtdlg.h"         // Definition of about dialog.
#include "mntradlg.h"         //	Class MainTradersDlg
#include "mncusdlg.h"         //	Class MainCustomerDlg
#include "mnaffdlg.h"         // Definition of about dialog.
#include "TUADS.H"


//{{mainApp Implementation}}
WORD hInst ;


DEFINE_RESPONSE_TABLE1(mainApp, TApplication)
//{{mainAppRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_EXIT, CmExit),
	 EV_COMMAND(CM_HELP_ABOUT, CmHelpAbout),
	 EV_COMMAND(CM_VIEW_TRADERS, CmViewTraders),
	 EV_COMMAND(CM_VIEW_CUSTOMERS,CmViewCustomers) ,
	 EV_COMMAND(CM_VIEW_AFFAIRS,CmViewAffairs) ,
//{{mainAppRSP_TBL_END}}
END_RESPONSE_TABLE;


class SDIDecFrame : public TDecoratedFrame {
public:
	 SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
				TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
		{  }
	 ~SDIDecFrame ()
		{  }
};


mainApp::mainApp () : TApplication("BCC Examples")
{
}


mainApp::~mainApp ()
{
}


void mainApp::SetupSpeedBar (TDecoratedFrame *frame)
{
	 //
	 // Create default toolbar New and associate toolbar buttons with commands.
	 //
	 TControlBar* cb = new TControlBar(frame);
	 cb->Insert(*new TButtonGadget(BM_FILE_MODIFY, CM_FILE_MODIFY));
	 cb->Insert(*new TButtonGadget(BM_FILE_SAVE, CM_FILE_SAVE));
	 cb->Insert(*new TButtonGadget(BM_EXIT, CM_EXIT));
	 cb->Insert(*new TSeparatorGadget(6));
	 cb->Insert(*new TButtonGadget(BM_VIEW_TRADERS, CM_VIEW_TRADERS));
	 cb->Insert(*new TButtonGadget(BM_VIEW_CUSTOMERS, CM_VIEW_CUSTOMERS));
	 cb->Insert(*new TButtonGadget(BM_VIEW_AFFAIRS, CM_VIEW_AFFAIRS));
	 cb->Insert(*new TSeparatorGadget(6));
	 cb->Insert(*new TButtonGadget(BM_HELP_ABOUT, CM_HELP_ABOUT));

	 cb->SetHintMode(TGadgetWindow::EnterHints);

	 frame->Insert(*cb, TDecoratedFrame::Top);
}


//////////////////////////////////////////////////////////
// mainApp
// =====
// Application intialization.
//
void mainApp::InitMainWindow ()
{
	 WORD param = 4;

	 Client = new TWindow(0, "");
	 SDIDecFrame * frame = new SDIDecFrame(0, GetName(), Client, TRUE);

	 nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

	 frame->SetIcon(this, IDI_SDIAPPLICATION);

	 frame->AssignMenu(SDI_MENU);

	 frame->Attr.AccelTable = SDI_MENU;

	 SetupSpeedBar(frame);

	 TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
												TStatusBar::CapsLock        |
												TStatusBar::NumLock         |
												TStatusBar::ScrollLock      |
												TStatusBar::Overtype);
	 frame->Insert(*sb, TDecoratedFrame::Bottom);

	 MainWindow = frame;

	 EnableBWCC();
	 hInst = (unsigned short)GetInstance() ;
	 OpenMBase(hInst,"DEMO.mbf",param);

}




BOOL mainApp::CanClose()
{
  CloseMBase(hInst,"DEMO.mbf");
  ClientDone(hInst);
  return TRUE ;
}

void mainApp::CmExit ()
{
  PostQuitMessage(0) ;
}

void mainApp::CmViewTraders ()
{
	 MainTradersDlg(MainWindow).Execute();
}

void mainApp::CmViewCustomers ()
{
	 MainCustomerDlg(MainWindow).Execute();
}

void mainApp::CmViewAffairs ()
{
	 MainAffairsDlg(MainWindow).Execute();
}

void mainApp::CmHelpAbout ()
{
	 mainAboutDlg(MainWindow).Execute();
}

int OwlMain (int , char* [])
{
	 mainApp     App;
	 int         result;
	 result = App.Run();
	 return result;
}
