*--------*---------*---------*---------*---------
*  Function..........: WRITEINI
*) Description.......: Writes an entry to a specified section 
*) ..................: of the WIN.INI file.
*) ..................: 
*  Syntax............: llSuccess = WRITEINI([ExpC1],[ExpC2],[ExpC3])
*  ..................: ExpC1 = the section of WIN.INI to write to
*  ..................: 	(e.g. [Windows] or [Devices])
*  ..................: ExpC2 = The specific entry within that section to
*  ..................:  write to
*  ..................: ExpC3 = The information to be written
*  Uses..............: FOXTOOLS.FLL
*  ..................: 
*  Returns...........: jlRetVal, Logical, .T. if written successfully
*  Calls.............: Windows API function WriteProfileString()
*  ..................: OPENTOOL(), YNALERT()
*  Changes...........:
*  Called By.........: Generic
*--------*---------*---------*---------*---------

PARAMETER pcSection, pcEntry, pcString
PRIVATE LIKE j*
IF OPENTOOL()	
	jnFn = regfn("WRITEPROFILESTRING","CCC","I")
	jnRetVal = callfn(jnFn,pcSection,pcEntry,pcString)
ELSE
	=YNALERT("Couldn't open FOXTOOLS.FLL",3)
	jnRetVal = 0
ENDIF	
IF jnRetVal = 0
	jlRetVal = .F.
ELSE
	jlRetVal = .T.
ENDIF
RETURN jlRetVal
