*************************************************************************
* File: Dualpick.prg      Written by: Jeff Neeley CIS 71700,532
*						 Enhanced by: Richard Wainwright CIS 75521,2530
*************************************************************************
* This file, along with it's attendant screens, implements a "dual"
* picklist with ADD, REMOVE, ADD ALL, REMOVE ALL. I keep seeing
* this type of selection device, and finally one of my customers
* just "wanted" it. (It's actually a very powerful routine.)
* This may be modified and used however you like - no worries.
*******************************************************************
* The following procedures are used by valids in the dualpick screen.
* The LARRAY (left array) should be filled before calling the screen.
* The RARRAY (right array) will be filled (or not) by actions
* taken on that screen.
*******************************************************************
*** RLW - 3/16/95 - Modified code for selecting all items to be MUCH quicker -
*** run against 40,000 item larray now takes 1 sec. to move all items from
*** one list to the other, original code would have taken several minutes.
*** I've added another screen LITLPICK.SPR for those times when you want a small
*** pick list - 10 items, easy to count with...
*** BTW, Jeff provided a really nice picker here, and I want to thank him
*** for his efforts!

*** Parameters: ShowSort - allows (or inhibits) display of Sort? checkbox.
***             DoSort - Enable/disable sorting if ShowSort is False
***             LcTitle - Window title for window containing pick boxes.        
PARAMETER showsort,dosort,lcTitle

*** Returns Xreturn, a comma delimited string of items selected.
PUBL xreturn

***** SAMPLE CALL *****
***   x = dualpick(.T.,"Select Items") 
***   or 
***   DO dualpick WITH .T.,"Select Items"
***   ?xreturn


*** RLW - 3/16/95
IF TYPE('larray')='U'
   PUBLIC ARRAY larray(20)
   larray(1)  = "Apple"
   larray(2)  = "Banana"
   larray(3)  = "Carrot"
   larray(4)  = "Dog"
   larray(5)  = "Eagle"
   larray(6)  = "Frankfurter"
   larray(7)  = "Golem"
   larray(8)  = "Hanger"
   larray(9)  = "Igloo"
   larray(10) = "Jumper"
   larray(11) = "Kangaroo"
   larray(12) = "Lunar Lander"
   larray(13) = "Mars Colony"
   larray(14) = "Newton"
   larray(15) = "Ostrich"
   larray(16) = "Penguin"
   larray(17) = "Quasar"
   larray(18) = "Roentgen"
   larray(19) = "Star"
   larray(20) = "Twister"
   lctitle='Pick Box Test'
ENDIF

*** RLW - 3/16/95
*** This allows us to turn sorting of Selected items on or off.  Default is to 
*** have sorting turned on for Selected items.
IF PARA()=0
	showsort=.T.,dosort=.T.
ENDIF		
IF TYPE('showsort') = 'U' 
	showsort=.T.
ENDIF	

IF TYPE('dosort') = 'U' 
	dosort=.T.
ENDIF	

IF dosort=.T. 
	msort=.T.
ELSE
	msort=.F.
ENDIF

IF showsort=.T. AND dosort=.F.
	msort=.F.
ENDIF	

*** RLW - 3/16/95
*** This allows us to move all items VERY quickly, very helpful for large lists.
=ACOPY(larray,xarray)

*** RLW - 3/16/95
IF PARA()=2 OR TYPE('lcTitle')='U'
   lctitle='Choose From Available Items'
ENDIF

*** Choose which screen you wish to run
DO litlpick.spr
* DO dualpick.spr

*** Build comma delimited list of items chosen
xreturn=''
FOR i=1 TO ALEN(rarray)
	xreturn=xreturn+ALLTR(rarray[i])+','
ENDFOR
xreturn=SUBS(xreturn,1,LEN(xreturn)-1)
RETURN xreturn

********************
PROCEDURE addpick
********************
IF lpick <= ALEN(larray)
   IF !EMPTY(rarray(1)) AND !EMPTY(larray(lpick))
      DIMENSION rarray(1 + ALEN(rarray))
   ENDIF
   IF !EMPTY(larray(lpick))
      rarray(ALEN(rarray)) = larray(lpick)
     IF dosort OR msort
      = ASORT(rarray)
     ENDIF 
   ENDIF
   IF ALEN(larray) > 1
      = ADEL(larray,lpick)
      DIMENSION larray(ALEN(larray) - 1)
   ELSE
      larray(1) = ""
   ENDIF
   IF lpick > ALEN(larray)
      lpick = ALEN(larray)
   ENDIF
ENDIF
_CUROBJ = _CUROBJ
SHOW GETS
RETURN

********************
PROCEDURE rempick
********************
IF rpick <= ALEN(rarray)
   IF !EMPTY(larray(1)) AND !EMPTY(rarray(rpick))
      DIMENSION larray(1 + ALEN(larray))
   ENDIF
   IF !EMPTY(rarray(rpick))
      larray(ALEN(larray)) = rarray(rpick)
      = ASORT(larray)
   ENDIF
   IF ALEN(rarray) > 1
      = ADEL(rarray,rpick)
      DIMENSION rarray(ALEN(rarray) - 1)
   ELSE
      rarray(1) = ""
   ENDIF
   IF rpick > ALEN(rarray)
      rpick = ALEN(rarray)
   ENDIF
ENDIF
_CUROBJ = _CUROBJ
SHOW GETS
RETURN

********************
PROCEDURE addallpick
********************
*** RLW - 3/16/95
*** Kill both arrays and populate rarray from xarray
DIME rarray(1)
rarray(1)=SPAC(1)

DIME larray(1)
larray(1)=SPAC(1)

=ACOPY(xarray,rarray)

msort=.T.
SHOW GETS
RETURN

*** Original code
* lpick = 1
* DO WHILE !EMPTY(larray(1))
*   IF !EMPTY(rarray(1)) AND !EMPTY(larray(lpick))
*      DIMENSION rarray(1 + alen(rarray))
*   ENDIF
*   IF !EMPTY(larray(lpick))
*      rarray(ALEN(rarray)) = larray(lpick)
*   ENDIF
*   IF ALEN(larray) > 1
*      = ADEL(larray,lpick)
*      DIMENSION larray(ALEN(larray) - 1)
*   ELSE
*      larray(1) = ""
*   ENDIF
* ENDDO
* = ASORT(rarray)


********************
PROCEDURE remallpick
********************
*** RLW - 3/16/95
*** Kill both arrays and populate larray from xarray
DIME larray(1)
larray(1)=SPAC(1)

DIME rarray(1)
rarray(1)=SPAC(1)

=ACOPY(xarray,larray)

SHOW GETS
RETURN

*** Original code, not used anymore.
IF .F.
   rpick = 1
   DO WHILE !EMPTY(rarray(1))
      IF !EMPTY(larray(1)) AND !EMPTY(rarray(rpick))
         DIMENSION larray(1 + ALEN(larray))
      ENDIF
      IF !EMPTY(rarray(rpick))
         larray(ALEN(larray)) = rarray(rpick)
      ENDIF
      IF ALEN(rarray) > 1
         = ADEL(rarray,rpick)
         DIMENSION rarray(ALEN(rarray) - 1)
      ELSE
         rarray(1) = ""
      ENDIF
   ENDDO
   = ASORT(larray)
   SHOW GETS
   RETURN
ENDIF .F.

********************
PROC mbutton
********************
PARAMETER clause
xreturn=.T.
DO CASE 
	
	CASE clause="W" 
	
	CASE clause="V" 
		
	CASE clause="M" 
		xreturn='Use items selected.'

ENDCASE
RETURN xreturn