****************************************************************************
**** Application  - Generic Routine                                     ****
**** Variation    - 1.01 - 9 Jan 1995                                   ****
**** Program Name - WAITMSG.PRG                                         ****
****************************************************************************
****                     C O P Y R I G H T                              ****
****************************************************************************
**** This program is placed in the public domain by Paul M. de Freitas  ****
**** and  Capricorn  South Limited.    It may be freely used and        ****
**** amended to suit a programmer's specific purposes and may be passed ****
**** on or used on the specific understanding that neither Paul M. de   ****
**** Freitas or Capricorn South Ltd. can be held responsible for either ****
**** the manner or outcome of its use. User beware!                     ****
****************************************************************************
****                P U R P O S E   O F   P R O G R A M                 ****
****************************************************************************
**** This program provides a shortcut to all required WAIT functions.   ****
**** It was designed to get around the fact that I hate typing!         ****
****************************************************************************
****              C O M P I L E   I N S T R U C T I O N S               ****
****************************************************************************
****                                                                    ****
****            FoxPro for Windows Version 2.5B or greater              ****
****                                                                    ****
****************************************************************************
****                             N O T E S                              ****
****************************************************************************
**** SYNTAX:  WAITMSG(|<c_msg>||,n_tmo|)                                ****
****                                                                    ****
**** PARAM:   c_msg  : optional message to display - blank kills WAIT   ****
****          n_tmo  : timeout - default is 10 seconds                  ****
****                           - enter 99 for exclusion of NOWAIT       ****
****                                                                    ****
**** RETURN:  TRUE                                                      ****
****                                                                    ****
**** USAGE :  To simplify control of WAIT messages on-screen            ****
****                                                                    ****
****          =WAITMSG("Record has been updated...")                    ****
****          =WAITMSG("This message will vanish in 30 secs...",30)     ****
****          =WAITMSG()  && clears prior message displayed             ****
****          =WAITMSG("Press a key, dummy...",99)                      ****
****                                                                    ****
****                                                                    ****
****************************************************************************
****                 A M E N D M E N T   H I S T O R Y                  ****
****************************************************************************
**** Bug  | Report | Reported | Description of    | Fix | Date of| Line ****
**** Rpt #|  Date  |    By    |    Activity       |  By |   Fix  | Tags ****
****------|--------|----------|-------------------|-----|--------|------****
****      |12/01/95| PdF/CSL  | Written           |     |        |      ****
****      |        |          |                   |     |        |      ****
****      |        |          |                   |     |        |      ****
****************************************************************************

**** PROCEDURE waitmsg  &&&& remove asterisks to incorporate in your lib!

  
PROCEDURE waitmsg
  **** this is a shorthand procedure to control WAIT messages
  PARAMETERS c_msg,n_tmo
  **** c_msg := message to display or omit to turn of wait
  **** n_tmo := timeout
  DO CASE
    CASE TYPE("c_msg")<>"C" OR (TYPE("c_msg")=="C" AND EMPTY(c_msg))
      **** turn off the WAIT message
      WAIT CLEAR
    CASE PARAMETERS()=2 AND TYPE("n_tmo")=="N"
      IF n_tmo >= 99
        **** display the WAIT and wait for a keypress
          WAIT WINDOW c_msg
      ELSE
        **** display the WAIT with a timeout
        WAIT WINDOW c_msg NOWAIT TIMEOUT n_tmo
      ENDIF
    OTHERWISE
      **** display the WAIT with a default timeout of 10 seconds
      WAIT WINDOW c_msg NOWAIT TIMEOUT 10
  ENDCASE
  RETURN .T.
