****************************************************************************
**** Application  - Generic Routine                                     ****
**** Variation    - 1.01 - 9 Jan 1995                                   ****
**** Program Name - RETRIM.PRG                                          ****
****************************************************************************
****                     C O P Y R I G H T                              ****
****************************************************************************
**** This program is placed in the public domain by Paul M. de Freitas  ****
**** and  Capricorn  South Limited.    It may be freely used and        ****
**** amended to suit a programmer's specific purposes and may be passed ****
**** on or used on the specific understanding that neither Paul M. de   ****
**** Freitas or Capricorn South Ltd. can be held responsible for either ****
**** the manner or outcome of its use. User beware!                     ****
****************************************************************************
****                P U R P O S E   O F   P R O G R A M                 ****
****************************************************************************
**** This program left trims a character GET field restoring the        ****
**** original length of the memvar associated with the GET.             ****
****                                                                    ****
**** It was designed to get around the fact that FoxProW does not       ****
**** recognise that a field is empty, and that therefore, the cursor    ****
**** should be placed at the left of the field regardless of where the  ****
**** field was first clicked on.                                        ****
****************************************************************************
****              C O M P I L E   I N S T R U C T I O N S               ****
****************************************************************************
****                                                                    ****
****            FoxPro for Windows Version 2.5B or greater              ****
****                                                                    ****
****************************************************************************
****                             N O T E S                              ****
****************************************************************************
**** SYNTAX:  RETRIM(|<n_lngth>|)                                       ****
****                                                                    ****
**** PARAM:   n_lngth  : optional length to trim to                     ****
****                     - default is GET memvar length                 ****
****                                                                    ****
**** RETURN:  TRUE                                                      ****
****                                                                    ****
**** USAGE :  Field VALID routine where left justify is required and    ****
****          original memvar length must be maintained or changed      ****
****                                                                    ****
****             RETRIM() && remember to click on expression button     ****
****                                                                    ****
****                                                                    ****
****                                                                    ****
****************************************************************************
****                 A M E N D M E N T   H I S T O R Y                  ****
****************************************************************************
**** Bug  | Report | Reported | Description of    | Fix | Date of| Line ****
**** Rpt #|  Date  |    By    |    Activity       |  By |   Fix  | Tags ****
****------|--------|----------|-------------------|-----|--------|------****
****      |24/12/94| PdF/CSL  | Written           |     |        |      ****
****      |        |          |                   |     |        |      ****
****      |        |          |                   |     |        |      ****
****************************************************************************

**** PROCEDURE retrim  &&&& remove asterisks to incorporate in your lib!

  **** ensures character field is left trimmed and correct length
  **** typical usage is in username and password verification
  **** grab the memvar name
  PARAMETERS l_lngth
  IF PARAMETERS()=1
    m.l_ll=m.l_lngth
  ELSE
    m.l_ll=0
  ENDIF
  m.l_xx = "m."+VARREAD()
  **** only try to convert character types
  IF TYPE(m.l_xx)<>"C"
    WAIT "Error - invalid field type passed to RETRIM!" WINDOW NOWAIT
    RETURN .T.
  ENDIF
  IF m.l_ll=0
    **** get the original length
    m.l_ll = LEN(&l_xx)
  ENDIF
  **** left trim in case of leading space(s)
  m.l_yy = PADR(LTRIM(&l_xx),m.l_ll)
  **** convert to proper case
  STORE m.l_yy TO (l_xx)
  **** display result
  SHOW GET &l_xx
  **** leave
  RETURN .T.

