****************************************************************************
* STARTAPP.PRG - Used to find/run newest version of application.  v1.00
*                Locates the newest version (by date/time) of your
*                application and runs it.  Great way to update 
*                applications that are running 24/hrs a day, or are
*                difficult to get all users out of at one time.
*              **Original idea from Craig Berntson, CIS ID 75143,3230**
*
*       SYNTAX -  =STARTAPP("app_name")   
*             OR  DO STARTAPP WITH "app_name"
*
* FREE!!! - I wrote this program for my own use and am releasing
*           it into puplic domain on the following conditions.
*         - If you use it, PLEASE let me know.  (It's nice to know that
*           others find your work useful.)  CIS - 73424,536.
*         - A thank-you gift of $1 would be appreciated if you find that
*           you are frequently using this code either un-modified or
*           as a base for other code.  (HOWEVER, IT IS NOT REQUIRED!)
*         - I must get credit for this code if used in any publication.
*         - My name must not be removed from the comments of this code
*           as the original writer.
*         - If you release any updated/revised version, you must add
*           to these comments.  Include your name and a summary
*           of what you have fixed/added.  (Please, send me a copy of
*           the updated code.)
*
*
*   PARAMETERS - m.appname - (Character) Name of application to be run.
*                DO not include .APP!  STARTAPP will search for the 
*                newest build that starts with the passed name.
*
*      RETURNS - .T. if an .APP file was found... No gaurantee that it
*                the application actually ran!
*
*
*      EXAMPLE - To change your application MYAPP.EXE so that it uses
*                STARTAPP:  Re-build MYAPP into MYAPP1.APP.  
*                
*                Make a new .EXE called MYAPP.EXE.  The only .PRGs you 
*                need in MYAPP.EXE are STARTAPP.PRG, and one that has 
*                the single line:
*                           DO STARTAPP WITH "MYAPP"
*                
*                Updating after you start using STARTAPP:
*              - Your application (MYAPP1.APP) is being used. You make
*                some changes, then build MYAPP2.APP.  Simply copy 
*                MYAPP2.APP into the same directory as MYAPP1.APP.
*                As soon as the user quits your application and goes
*                back in, they are running the update.  
*
****************************************************************************
PARAMETERS m.appname
PRIVATE _xy_fot_qrl                              && _probably_ won't be used in called .APP
PRIVATE cpys,max,i,applist,m.runapp
IF EMPTY(m.appname)
	WAIT WINDOW "No application name given to STARTAPP.PRG"
	RETURN .F.
ENDIF
IF SET("TALK")='ON'
	SET TALK OFF
	_xy_fot_qrl='ON'
ELSE
	_xy_fot_qrl='OFF'
ENDIF
m.appname=m.appname+"*.APP"

cpys=ADIR(applist,m.appname)                     && Get list of matching files
IF cpys>0                                        && Any coppies of APP found?
   max=1
   FOR i=1 TO cpys                               && Find newest date/time.
      IF applist[i,3]>applist[max,3] OR ;
        (applist[i,3]=applist[max,3] AND applist[i,4]>applist[max,4])
      	 max=i
      ENDIF
   ENDFOR 
   m.runapp=applist[max,1]                       && Here's our .APP name.
   RELEASE cpys,max,i,applist,m.appname          && Don't need these variables anymore.
   DO (m.runapp)                                 && Finally... run the thing.
   SET TALK &_xy_fot_qrl                         && Restore original TALK setting.
   RETURN .T.                                    
ELSE
   WAIT WINDOW "No version of "+m.appname+" found by STARTAPP.PRG"
   SET TALK &_xy_fot_qrl
   RETURN .F.
ENDIF
