**
* Function....: YNALERT
* Called by...: Generic
*
* Abstract....: 
*
* Returns.....: Logical
*				.T. if "Yes" or "Ok" is selected, .F. if "No"
* Parameters..:
*
* Syntax......: llRetVal=YNALERT(<ExpC1>,[<ExpN1>])
* 				<ExpC1> - Message to be displayed in the message-box
* 				<ExpN1> - numeric parameter to specify defaults:
*				1 - "Yes" and "No" - "Yes" is the default
*				2 - "Yes" and "No" - "No" is the default
*				3 - "Ok"
*
* Notes.......: Cross-platform.  Under FP/Win, uses the FOXTOOLS.FLL 
*				MsgBox() Function.  Identical in operation on both platforms,
*				except that under FP/Win, the <Esc> key, rather than selecting
*				the "No" option, has no effect
**
FUNCTION YNALERT
PARAMETERS pcMsg,pnDef
IF _DOS
	DO CASE
		CASE TYPE("pnDef")="L" OR pnDef=1
			winwidth=MAX((LEN(pcMsg) + 4),14)
			pr_strng = "*TH \!\<Yes;\?\<No"
			pb_width = 11
			ynans = 1
		CASE TYPE("pnDef")="N" AND pnDef=2
			winwidth=MAX((LEN(pcMsg) + 4),14)
			pr_strng = "*TH \<Yes;\!\?\<No"
			pb_width = 11
			ynans = 2
		CASE TYPE("pnDef")="N" AND pnDef=3
			winwidth=MAX((LEN(pcMsg) + 4),14)
			pr_strng="*TH \<Ok"
			pb_width=6
			ynans=1
	ENDCASE 	
	lcol=40-INT(winwidth/2)
	rcol = lcol + winwidth
	lnMsgPos = INT((winwidth-LEN(pcMsg))/2)
	DEFINE WINDOW reply FROM 10,lcol TO 16,rcol DOUBLE COLOR SCHEME 7
	ACTIVATE WINDOW reply IN SCREEN
	@ 1,lnMsgPos SAY pcMsg
	@ 3,(winwidth-pb_width)/2 GET ynans FUNCTION EVALUATE("pr_strng")  DEFAULT ynans
	IF ynans=2
		KEYBOARD CHR(9)
	ENDIF
	READ
	IF ynans = 1
		alertreply = .T.
	ELSE
		alertreply = .F.
	ENDIF (ynans = 1)
	DEACTIVATE WINDOW reply
	RELEASE WINDOW reply
ELSE
	IF ! "FOXTOOLS" $ SET("LIBRARY")
		SET LIBRARY TO SYS(2004) + "FOXTOOLS.FLL" ADDITIVE
	ENDIF 
	DO CASE
	CASE TYPE("pnDef")="L" OR pnDef=1
		lnTypeSymbol=36 && YN and Question Mark "Yes" default
	CASE TYPE("pnDef")="N" AND pnDef=2
		lnTypeSymbol=292 && YN and Question Mark "No" default
	CASE TYPE("pnDef")="N" AND pnDef=3
		lnTypeSymbol=48 && Ok and Exclamation point
	ENDCASE 	
	lnResult=MsgBox( pcMsg, "",lnTypeSymbol) 
	IF lnResult=6 OR lnResult=1
		alertreply = .T.
	ELSE
		alertreply = .F.
	ENDIF
ENDIF
RETURN alertreply
*EOF YNALERT
