*!*********************************************************************
*!
*!      Procedure: NOTIFY
*!
*!          Calls: CNTR           (procedure in CATALOG.PRG)
*!
*!*********************************************************************
* Call with parameter places message on screen
* Call without parameter removes message
**************************************************
PROCEDURE notify
PARAMETERS pcMsg
PRIVATE lnCtrRow, lnCtrCol,lcOldFont
IF _WINDOWS
	lcOldFont=CURRFONT("SCREEN")
	MODIFY WINDOW SCREEN FONT "FIXEDSYS",10
ENDIF
lnCtrRow=INT(WROWS("")/2)
lnCtrCol=INT(WCOLS("")/2)
IF TYPE("pcMsg") = "C"
	onOff = .T.
ELSE
	onOff = .F.
ENDIF
IF onoff
	IF _WINDOWS
		lpos=(WCOLS("")/2) - FLEN(ALLTRIM(pcMsg),"MS Sans Serif",12,"BT")/2
	ELSE
		lpos = INT((WCOLS("")-LEN(pcMsg))/2)
	ENDIF
	lcol = lpos - 4
	rcol = lcol + LEN(pcMsg) + 8
	IF _WINDOWS
		DEFINE WINDOW alert FROM lnCtrRow-3,lcol TO lnCtrRow+1,rcol PANEL COLOR RGB(,,,0,255,255) FONT "MS Sans Serif",12
	ELSE	
		DEFINE WINDOW alert FROM lnCtrRow-3,lcol TO lnCtrRow+1,rcol DOUBLE COLOR SCHEME 7
	ENDIF
	ACTIVATE WINDOW alert IN SCREEN NOSHOW
	IF _WINDOWS
		lnMsgCol=(WCOLS("alert")/2) - FLEN(ALLTRIM(pcMsg),"MS Sans Serif",12,"BT")/2
		@ .75,lnMsgCol SAY pcMsg FONT "MS Sans Serif",12 STYLE "BT"
		*@ 1,CTRCOL(pcMsg,"FIXEDSYS",10,"Alert") SAY pcMsg COLOR RGB(255,0,0,0,255,255)
	ELSE
		@ 1,4 SAY pcMsg
	ENDIF
	SHOW WINDOW alert
ELSE
	IF WEXIST("alert")
		DEACTIVATE WINDOW alert
		RELEASE window alert
	ENDIF (WEXIST("alert"))
ENDIF (onoff)
IF _WINDOWS
	MODIFY WINDOW SCREEN FONT &lcOldFont
ENDIF

RETURN
