*--------*---------*---------*---------*---------
*  Function..........: JustPath
*) Description.......: Return just the path name 
*) ..................: from "pcFileName"
*  Syntax............:
*  Parameters........: pcFileName, Character,
*  ..................:  file name to remove path from
*  Uses..............:
*  Returns...........: jcRetVal, Character,
*  ..................:  file name without path
*  ..................:  NOTE - returns NULL string
*  ..................:  if no path on file name
*  Calls.............:
*  Changes...........:
*  Called By.........:
*--------*---------*---------*---------*---------
FUNCTION JustPath
PARAMETERS pcFileName
PRIVATE ALL LIKE j*
jcFileName = ALLTRIM(UPPER(m.pcFileName))
IF '\' $ jcFileName
	jcRetVal = SUBSTR(jcFileName,1,RAT('\',jcFileName))
	IF RIGHT(jcRetVal,1) = '\' AND LEN(jcRetVal) > 1 ;
			AND SUBSTR(jcRetVal,LEN(jcRetVal)-1,1) <> ':'
		jcRetVal = SUBSTR(jcRetVal,1,LEN(jcRetVal)-1)
	ENDIF ( RIGHT(jcRetVal,1) = '\' AND LEN(jcRetVal) > 1 ; )
ELSE
	jcRetVal = ''
ENDIF ( '\' $ m.pcFileName )
RETURN jcRetVal
*EOF JustPath
