*--------*---------*---------*---------*---------
*  Function..........: CurrFont
*) Description.......: Determins the font of the
*) ..................: specified, currently active
*) ..................: window or the screen.
*  Syntax............: ? CURRFONT([<expC>|"SCREEN"])
*  Parameters........:
*  Uses..............:
*  Returns...........: jcRetVal, Character, the font,
*  ..................: point size and style of the 
*  ..................: specified window (WONTOP() by default)
*  Calls.............:
*  Changes...........:
*  Called By.........:
*--------*---------*---------*---------*---------
FUNCTION CurrFont
PARAMETERS pcWindow
PRIVATE ALL LIKE j*
IF PARAMETERS()=0
   jcWindow=WONTOP()
ELSE
   IF UPPER(pcWindow)="SCREEN")
      jcWindow=""
   ELSE
      jcWindow=pcWindow
   ENDIF
ENDIF

jcRetVal="'" + WFONT(1,jcWindow) +"',"+ LTRIM(STR(WFONT(2,jcWindow))) + " STYLE  '" + WFONT(3,jcWindow) + "'"
RETURN  jcRetVal
*EOF CurrFontf
