*:*********************************************************************
*:
*:        Program: SIMILAR.PRG
*:
*:         System: SIMILAR() UDF
*:         Author: Pat Adams   (718) 469-4032
*:      Copyright (c) 1988, DB Unlimited
*:  Last modified: 09/29/88     11:05
*:
*********************************************************************************
                              PROCEDURE Similar
*********************************************************************************
*& UDF to determine similar sounds                                              *
*                                                                               *
*   Based upon a concept published by Neil Weicher in Volume 1.6 of the         *
*   NYMCUG LINKER.                                                              *
*                                                                               *
*   This routine takes the passed parameter and scans it for similar sounds     *
*   and returns a value based on the similar sounds.  SIMILAR() is intended     *
*   as a replacement for SOUNDEX() when dealing primarily with last name        *
*   fields.  While it is far from perfect, it is superior to SOUNDEX() for      *
*   this particular purpose.                                                    *
*                                                                               *
*   For purposes of clarity, the position of the item(s) being replaced has     *
*   been stored to a memvar, PPOS, and that memvar used with the STUFF()        *
*   function in this code.  The speed of the UDF can be increased by those      *
*   two lines of code into one.                                                 *
*                                                                               *
*   SIMILAR() attempts only to deal with similar sounds in last names.          *
*                                                                               *
*   Although this was written for and has been tested in FoxBASE+, it should    *
*   work equally well in dBXL, Quicksilver, Clipper and dBASE IV.               *
*                                                                               *
*   Unfortunately, FoxBASE+ does not permit use of UDF's in indexing.  There-   *
*   for, it is necessary to create an additional field in the database to       *
*   hold the similar sound, then index on that field.                           *
*                                                                               *
*   This UDF is NOT placed in the public domain.   It is made available for     *
*   free use by all members in good standing of the International Dbase Users   *
*   Group.  Additionally, individuals who enhance SIMILAR() and provide copies  *
*   of that enhancement to IDBUG and/or Pat Adams are hereby granted free use   *
*   of SIMILAR().                                                               *
*                                                                               *
*   The International Dbase Users Group can be reached at:                      *
*       70 A Greenwich Avenue, #101                                             *
*       New York, New York  10011                                               *
*       VOICE: (212) 869-3921           BBS: (212) 869-3923                     *
*                                                                               *
*   Charter membership dues in IDBUG are $60 per year.                          *
*                                                                               *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
PARAMETERS iinput
PRIVATE sendback

IF LEN(iinput) <> 0
* ====================================================================
*$ Ensure string to be evaluated is all upper case & trim any leading
*  or trailing blank spaces
* ===================================================================
sendback = UPPER(TRIM(LTRIM(iinput)))
SET TALK Off
* =============================================================
* NOTE: The order of the following IF statements is important
* =============================================================

DO WHILE AT(" ", sendback) <> 0
   * =================================
   *$ Remove any embedded blank spaces
   * =================================
   STORE AT(" ", sendback) TO ppos
   sendback = STUFF(sendback, ppos,1,"")
ENDDO while at(" ", sendback) <> 0

DO WHILE AT("'", sendback) <> 0
   * ========================
   *$ Remove any apostrophies
   * ========================
   STORE AT("'", sendback) TO ppos
   sendback = STUFF(sendback, ppos,1,"")
ENDDO while at("'", sendback) <> 0

DO WHILE AT("-", sendback) <> 0
   * ===================
   *$ Remove any dashes
   * ===================
   STORE AT("-", sendback) TO ppos
   sendback = STUFF(sendback, ppos,1,"")
ENDDO while at("-", sendback) <> 0

IF AT("ST ", sendback) <> 0 .OR. AT("ST.", sendback) <> 0
   * =====================================================
   *$ If last name contains abbreviation for saint, expand
   * =====================================================
   IF AT("ST ", sendback) <> 0
      STORE AT("ST ", sendback) TO ppos
   ENDIF at("ST ", etc.
   
   IF AT("ST.", sendback) <> 0
      STORE AT("ST.", sendback) TO ppos
   ENDIF at("ST.", etc.
   
   sendback = STUFF(sendback, ppos,3,"SANT")
ENDIF at("ST ", sendback, etc.

DO WHILE AT(".", sendback) <> 0
   * ==========================
   *$ Remove any other periods
   * ==========================
   STORE AT(".", sendback) TO ppos
   sendback = STUFF(sendback, ppos,1,"")
ENDDO while at(".", sendback) <> 0

IF AT("GRAY", sendback) <> 0 .OR. AT("GREY", sendback) <> 0
* ==================================
*$ Change all GRAY and  GREY to GRA
* ==================================
    IF AT("GRAY", sendback) <> 0
        STORE AT("GRAY", sendback) TO ppos
    ELSE
        STORE AT("GREY", sendback) TO ppos
    ENDIF at("GRAY"

    sendback = STUFF(sendback, ppos, 4, "GRA")
ENDIF AT("GRAY", etc.

* =====================================================
*$ Change all occurrances of variants of STEIN to STIN
* =====================================================
IF AT("STEIN", sendback) <> 0 
    STORE AT("STEIN", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 5, "STIN")
ENDIF at("STEIN", etc.

IF AT("STIEN", sendback) <> 0
    STORE AT("STIEN", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 5, "STIN")
ENDIF at("STIEN", sendback) <> 0

IF AT("STINE", sendback) <> 0
    STORE AT("STINE", sendback) TO ppos
    sendback = STUFF(sendback, ppos,5, "STIN")
ENDIF at("STINE", etc.

IF sendback = "DAVIES" .OR. sendback = "DAVEIS"
* ===================================
*$ Change variants of Davis to Davis
* ===================================
    sendback = "DAVIS"
ENDIF sendback = "DAVIES", etc.

* ==================================
*$ Change variants of "BERG" to BERG
* ==================================
IF AT("BURG",sendback) <> 0
    STORE AT("BURG", sendback) TO ppos
    sendback = STUFF(sendback, ppos,4,"BERG")
ENDIF at(sendback, 'BURG') <> 0

IF AT("BIRG",sendback) <> 0
    STORE AT("BIRG", sendback) TO ppos
    sendback = STUFF(sendback, ppos,4,"BERG")
ENDIF at(sendback, 'BIRG') <> 0
IF SUBSTR(sendback,(LEN(sendback)-1),2) = "CE"
   * =====================================================
   *$ If last two letters of name are CE, replace with S
   * =====================================================
   STORE LEN(sendback) - 1 TO ppos
   sendback = STUFF(sendback, ppos,2, "S")
ENDIF substr((len(sendback)-1),2) = "CE"

IF SUBSTR(sendback,(LEN(sendback)-1),2) = "EY"
* =========================================
*$ If last names ends with EY, change to i
* =========================================
    STORE LEN(sendback) - 1 TO ppos
    sendback = STUFF(sendback, ppos, 2, "I")
ENDIF substr(sendback, (len(lendback)-1),2) = 'EY'

IF AT("ICH", sendback) <> 0
* ==============================
*$ Change ICH combinations to IK
* ==============================
    STORE AT("ICH", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "IK")
ENDIF at("ICH", sendback) <> 0

IF AT("BB", sendback) <> 0
   * =======================================
   *$ Replace occurrance of BB with B
   * =======================================
   STORE AT("BB", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"B")
ENDIF at("BB", etc.

IF AT("BRAUN", sendback) <> 0
   STORE AT("BRAUN", sendback) TO ppos
   sendback = STUFF(sendback, ppos,4,"BROWN")
ENDIF at("BRAUN", etc.


IF AT("CH", sendback) <> 0
   * =====================================
   *$ Replace all CH combinations with SH
   * =====================================
   STORE AT("CH", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"SH")
ENDIF at("CH", sendback)  <> 0

IF AT("C", sendback) = 1
   * ===========================================================
   *$ If first letter of string is C and it's not part of a CH,
   *  replace it with a K
   * ===========================================================
   sendback = STUFF(sendback,1,1,"K")
ENDIF at("C", sendback) = 1

IF AT("CO", sendback) <> 0
   * ================================
   * Replace CO combinations with KO
   * ================================
   STORE AT("CO", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"KO")
ENDIF at("CO", sendback) <> 0

IF AT("CUE", sendback) <> 0
   * =======================================
   *$ Replace occurrance of CUE with Q
   * =======================================
   STORE AT("CUE", sendback) TO ppos
   sendback = STUFF(sendback,ppos,3,"Q")
ENDIF at("CUE", etc.

IF AT("HAUGH", sendback) <> 0
   * =======================================
   *$ Replace occurrance of HAUGH with HO
   * =======================================
   STORE AT("HAUGH", sendback) TO ppos
   sendback = STUFF(sendback,ppos,4,"HO")
ENDIF at("HAUGH", etc.

IF AT("HAU", sendback) <> 0
   * =======================================
   *$ Replace occurrance of HAU with HOW
   * =======================================
   STORE AT("HAU", sendback) TO ppos
   sendback = STUFF(sendback,ppos,3,"HOW")
ENDIF at("HAU", etc.

DO WHILE AT("GHT", sendback) <> 0
   * ===================================
   *$ replace occurrances of GHT with T
   * ===================================
   STORE AT("GHT", sendback) TO ppos
   sendback = STUFF(sendback, ppos, 3, "T")
ENDDO while at('GHT", sendback) <> 0

IF AT("JOHN", sendback) <> 0
   * =======================================
   *$ Replace occurrance of JOHN with JON
   * =======================================
   STORE AT("JOHN", sendback) TO ppos
   sendback = STUFF(sendback,ppos,4,"JON")
ENDIF at("JOHN", etc.

IF AT("KAHN", sendback) <> 0
   * =======================================
   *$ Replace occurrance of KAHN with KON
   * =======================================
   STORE AT("KAHN", sendback) TO ppos
   sendback = STUFF(sendback,ppos,4,"KON")
ENDIF at("KAHN", etc.

IF AT("MIDT", sendback) <> 0
   * ========================================
   *$ Replace occurrances of MIDT with MIT
   * ========================================
   STORE AT("MIDT", sendback) TO ppos
   sendback = STUFF(sendback,ppos,4,"MIT")
ENDIF at("MIDT", etc.

IF AT("IE",sendback) <> 0
   * =================================================
   * Replace any IE combinations in the string with i
   * =================================================
   STORE AT("IE", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"E")
ENDIF at ("IE", sendback) <> 0

IF AT("EI",sendback) <> 0
   * =================================================
   * Replace any EI combinations in the string with I
   * =================================================
   STORE AT("EI", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"I")
ENDIF at ("EI", sendback) <> 0

IF AT("EA", sendback) <> 0 .AND. AT("EA", sendback) <> LEN(sendback) -1
   * ========================================================
   * Replace any EA combinations with A if not at end of name
   * ========================================================
   STORE AT("EA", sendback) TO ppos
   sendback = STUFF(sendback, ppos, 2, "A")
ENDIF at("EA", sendback) <> 0

IF AT("EE", sendback) <> 0
   * ===================================
   * Replace any EE combinations with E
   * ===================================
   STORE AT("EE", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"E")
ENDIF at("EE", sendbac,) <> 0

IF AT("EU", sendback) <> 0
   * ===================================
   * Replace any EU combinations with U
   * ===================================
   STORE AT("EU", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"U")
ENDIF at("EU", etc.

IF AT("UE", sendback) <> 0
* =============================
*$ Change UE combinations to U
* ==============================
   STORE AT("UE", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"U")
ENDIF at("UE", etc.

IF AT("UGH", sendback) <> 0
* ====================
*$ Replace UGH with U
* ====================
    STORE AT("UGH", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "U")
ENDIF at("UGH", etc.

IF AT("UI", sendback) <> 0
* ==================
*$ Change UI to I
* ===================
    STORE AT("UI", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "I")
ENDIF at("UI",sendback) <> 0

IF AT("EW", sendback) <> 0
   * ===================================
   * Replace any EW combinations with U
   * ===================================
   STORE AT("EW", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"U")
ENDIF at("EW", etc.

DO WHILE AT("AY", sendback) <> 0
* ================
*$ Change AY to A
* =================
    STORE AT("AY", sendback) TO ppos
    sendback = STUFF(sendback, ppos,2, "A")
ENDDO while at("AY", sendback) <> 0

IF AT("AA", sendback) <> 0
   * ===================================
   * Replace any AA combinations with A
   * ===================================
   STORE AT("AA", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"A")
ENDIF at("AA", etc.

IF AT("AI", sendback) <> 0
   * ===================================
   * Replace any AI combinations with A
   * ===================================
   STORE AT("AI", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"A")
ENDIF at("AI", etc.

IF AT("AE", sendback) <> 0
   * ===================================
   * Replace any AE combinations with A
   * ===================================
   STORE AT("AE", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"A")
ENDIF at("AE", etc.

IF AT("AGH", sendback) <> 0
* ==================
*$ Change AGH to AH
* ==================
    STORE AT("AGH", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "AH")
ENDIF at("AGH"


IF AT("IO", sendback) <> 0 .AND. AT("IO", sendback) <> LEN(sendback)-1
   * ==================================================================
   * Replace any IO combinations with I unless it comes at end of name
   * ==================================================================
   STORE AT("IO", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"I")
ENDIF at("IO", etc.

IF AT("OO", sendback) <> 0
   * ===================================
   * Replace any OO combinations with O
   * ===================================
   STORE AT("OO", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"O")
ENDIF at("OO", etc.

DO WHILE AT("OA", sendback) <> 0
* =============================
*$ Convert OA combinatins to O
* =============================
    STORE AT("OA", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "O")
ENDDO while at("OA", etc.

DO WHILE AT("OE", sendback) <> 0
* =============================
*$ Convert OE combinatins to O
* =============================
    STORE AT("OE", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "O")
ENDDO while at("OE", etc.

IF AT("OUGH", sendback) <> 0 .AND. sendback <> "OUGH"
* ================================
*$ Change OUGH combinations to OF
* ================================
    STORE AT("OUGH", sendback) TO ppos
    sendback = STUFF(sendback, ppos,4, "OF")
ENDIF at("OUGH", sendback) <> 0

IF AT("OU", sendback) <> 0
   * ===================================
   * Replace any OU combinations with OW
   * ===================================
   STORE AT("OU", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"OW")
ENDIF at("OU", etc.

IF AT("Y", sendback) <> 0
   * ===================================
   * Replace any Y combinations with I
   * ===================================
   STORE AT("Y", sendback) TO ppos
   sendback = STUFF(sendback, ppos,1,"I")
ENDIF at("Y", etc.

IF AT("KN", sendback) <> 0
   * ===================================
   * Replace any KN combinations with N
   * ===================================
   STORE AT("KN", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"N")
ENDIF at("KN", etc.

IF AT("PF", sendback) <> 0
* ================
*$ Change PF to F
* ================
    STORE AT("PF", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "F")
ENDIF at("PF", etc.

DO WHILE AT("PH", sendback) <> 0
* ==================================
*$ Replace occurrances of PH with F
* ==================================
    STORE AT("PH", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "F")
ENDDO while at("PH", sendback) <> 0

IF AT("FF", sendback) <> 0
   * =======================================
   *$ Replace occurrance of FF with F
   * =======================================
   STORE AT("FF", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"F")
ENDIF at("FF", etc.

IF AT("MC", sendback) = 1
   * ===========================================
   *$ If a name begins with Mc, convert to MAK
   * ===========================================
   sendback = STUFF(sendback,1,2,"MAK")
ENDIF at("MC", sendback) = 1

IF AT("MAC", sendback) = 1
   * ===========================================
   *$ If a name begins with Mac, convert to MAK
   * ===========================================
   sendback = STUFF(sendback,1,3,"MAK")
ENDIF AT("MAC", sendback) = 1

IF AT("CC", sendback) <> 0
   * =======================================
   *$ Replace occurrance of CC with C
   * =======================================
   STORE AT("CC", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"C")
ENDIF at("CC", etc.

DO WHILE AT("CK", sendback) <> 0
   * =============================
   *$ Convert CK combinations to K
   * =============================
   STORE AT("CK", sendback) TO ppos
   sendback = STUFF(sendback, ppos, 2, "K")
ENDDO while at("CK", sendback) <> 0

DO WHILE AT("KK", sendback) <> 0
* ===================
*$ Change KK to K
* ===================
    STORE AT("KK", sendback) TO ppos
    sendback = STUFF(sendback, ppos,2, "K")
ENDDO while at("KK", sendback) <> 0

DO WHILE AT("GG", sendback) <> 0
   * ==================================
   *$ Replace occurrances of GG with G
   * ==================================
   STORE AT("GG", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"G")
ENDDO while at("GG", etc.

IF AT("SS", sendback) <> 0
   * =======================================
   *$ Replace occurrance of SS with S
   * =======================================
   STORE AT("SS", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"S")
ENDIF at("SS", etc.

IF AT("NN", sendback) <> 0
   * =======================================
   *$ Replace occurrance of NN with N
   * =======================================
   STORE AT("NN", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"N")
ENDIF at("NN", etc.

IF AT("MM", sendback) <> 0
   * =======================================
   *$ Replace occurrance of MM with M
   * =======================================
   STORE AT("MM", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"M")
ENDIF at("MM", etc.

IF AT("TT", sendback) <> 0
   * =======================================
   *$ Replace occurrance of TT with T
   * =======================================
   STORE AT("TT", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"T")
ENDIF at("TT", etc.

IF AT("LL", sendback) <> 0
   * =======================================
   *$ Replace occurrance of LL with L
   * =======================================
   STORE AT("LL", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"L")
ENDIF at("LL", etc.

IF AT("RR", sendback) <> 0
   * =======================================
   *$ Replace occurrance of RR with R
   * =======================================
   STORE AT("RR", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"R")
ENDIF at("RR", etc.

IF AT("DD", sendback) <> 0
   * =======================================
   *$ Replace occurrance of DD with D
   * =======================================
   STORE AT("DD", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"D")
ENDIF at("DD", etc.

DO WHILE AT("PB", sendback) <> 0
   * ===============================
   *$ Change occurances of PB to B
   * ===============================
   STORE AT("PB", sendback) TO ppos
   sendback = STUFF(sendback, ppos, 2, "B")
ENDDO while at("PB", sendback) <> 0

IF AT("PP", sendback) <> 0
   * =======================================
   *$ Replace occurrance of PP with P
   * =======================================
   STORE AT("PP", sendback) TO ppos
   sendback = STUFF(sendback,ppos,2,"P")
ENDIF at("PP", etc.


DO WHILE AT("REY", sendback) <> 0
* ====================
*$ Convert REY to RA
* =====================
    STORE AT("REY", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "RA")
ENDDO while at("REY", etc.

DO WHILE AT("OW", sendback) <> 0
   * ===================================
   *$ Replace occurrances of OW with O
   * ===================================
   STORE AT("OW", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"O")
ENDDO while at("OW", sendback) <> 0

DO WHILE AT("WR", sendback) <> 0
   * ================================
   *$ Convert occurrances of WR to R
   * ================================
   STORE AT("WR", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"R")
ENDDO while at("WR", etc.

DO WHILE AT("SZY", sendback) <> 0
* ==================================
*$ Convert occurrances of SZY to SI
* ==================================
    STORE AT("SZY", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "SI")
ENDDO while at("SZY", etc.

IF AT("HI", sendback) <> 0 .AND. AT("HI", sendback) <> 1
* ======================================================================
*$ Convert HI's to I if they do not occur at the beginning of last name
* ======================================================================
    STORE AT("HI", sendback) TO ppos
    sendback = STUFF(sendback, ppos,2, 'I')
ENDIF at("HI", etc.

DO WHILE AT("IAN", sendback) <> 0
   * ===================================
   *$ Change occurrances of IAN with EN
   * ===================================
   STORE AT("IAN", sendback) TO ppos
   sendback = STUFF(sendback, ppos,3,"EN")
ENDDO while at("IAN", sendback) <> 0

IF AT("II", sendback) <> 0
   * ===================================
   * Replace any II combinations with I
   * ===================================
   STORE AT("II", sendback) TO ppos
   sendback = STUFF(sendback, ppos,2,"I")
ENDIF at("II", etc.

IF AT("OHE", sendback) <> 0
* ================================
*$ Convert OHE combinatins to OE
* ================================
    STORE AT("OHE", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 3, "OE")
ENDIF at("OHE", etc.

DO WHILE AT("OH", sendback) <> 0
* ==================================
*$ Change any OH combinations to O
* ==================================
    STORE AT("OH", sendback) TO ppos
    sendback = STUFF(sendback, ppos, 2, "O")
ENDDO while at("OH", etc.

IF SUBSTR(sendback,(LEN(sendback)-1),2) = "UZ" .AND. LEN(sendback) > 4
   * ======================================
   *$ If last name ends in UZ, change to Z
   * ======================================
   STORE LEN(sendback) - 1 TO ppos
   sendback = STUFF(sendback, ppos, 2, "Z")
ENDIF substr(sendback,len(sendback)-1),2) = "UZ"

IF SUBSTR(sendback,LEN(sendback),1) = "E" .AND. LEN(sendback) <> 2
   * ==============================================================
   *$ If last letter of last name is E remove unless name is only 
   *  two characters in length
   * ==============================================================
    IF SUBSTR(sendback, (LEN(sendback)-1),2) <> "GE"
    * ==========================================
    *$ Do not remove final E if name ends in GE
    * ==========================================
        IF SUBSTR(sendback, (LEN(sendback) -1),2) <> "FE"
        * ==========================================
        *$ Do not remove final E if name ends in FE
        * ==========================================
           STORE LEN(sendback) TO ppos
           sendback = STUFF(sendback, ppos, 1, "")
        ENDIF substr(sendback, (len(sendback, etc.
    ENDIF substr(sendback, (len(sendback)-1), etc.
ENDIF substr(sendback(len(sendback),1) = 'E', etc.

IF SUBSTR(sendback,(LEN(sendback)-1),2) = "EI"
   * =================================================
   *$ IF IE combination occurs at end of a word replace with E
   * =================================================
   STORE LEN(sendback)-1 TO ppos
   sendback = STUFF(sendback,ppos,2,"E")
ENDIF substr((len(sendback)-1),2) = "EI"

IF SUBSTR(sendback,(LEN(sendback)-1),2) = "AI"
   * ===========================================================
   *$ If an AI combination occurs at end of word replace with I
   * ===========================================================
   STORE LEN(sendback)-1 TO ppos
   sendback = STUFF(sendback, ppos,2, "I")
ENDIF substr((len(sendback)-1),2) = "AI"

ELSE
    sendback = ""
ENDIF len(iinput) <> 0
RETURN sendback
* END UDF SIMILAR()
