FUNCTION Roman
*-------------------------------------------------------------------------------
*-- Programmer..: Nick Carlin
*-- Date........: 04/13/1988
*-- Notes.......: A function designed to return a Roman Numeral based on
*--               an Arabic Numeral input ...
*-- Written for.: dBASE III+
*-- Rev. History: 07/25/1991 -- Modified by Ken Mayer for 1) dBASE IV, 1.1,
*--                             updated to a function, and the procedure
*--                             GetRoman was done away with (combined into the
*--                             function).
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Roman(<nArabic>)
*-- Example.....: ? Roman(32)
*-- Returns.....: Roman Numeral (character string) equivalent of Arabic numeral
*--               passed to it. In example:  XXXII
*-- Parameters..: nArabic = Arabic number to be converted to Roman
*-------------------------------------------------------------------------------

	parameters nArabic
	private nCounter,nValue
	
	cRoman = ""                 && this is the returned value
	nCounter = 0                && init counter
	do while nCounter < 4       && loop four times, once for thousands, once
	                            && four hundreds, tens and singles ...
		nCounter = nCounter + 1  && increment counter
		do case                  && determine roman numerals to use
			case nCounter = 1     && first time through the loop
				nDiv   = 1000      && divide by 1000
				cSmall = "M"       && smallest value 
				cMid   = "W"       && next up ...
				cBig   = "Y"       && largest passed with this ... 10,000s
			case nCounter = 2
				nDiv   = 100
				cSmall = "C"
				cMid   = "D"
				cBig   = "M"
			case nCounter = 3
				nDiv   = 10
				cSmall = "X"
				cMid   = "L"
				cBig   = "C"
			case nCounter = 4
				nDiv   = 1
				cSmall = "I"
				cMid   = "V"
				cBig   = "X"
		endcase
		nValue = mod(int(nArabic/nDiv),10)
		do case
			case nValue = 0
				                && do nothing
			case nValue = 1
				cRoman = cRoman + cSmall                           && 1 = I
			case nValue = 2
				cRoman = cRoman + cSmall + cSmall                  && 2 = II
			case nValue = 3
				cRoman = cRoman + cSmall + cSmall + cSmall         && 3 = III
			case nValue = 4
				cRoman = cRoman + cSmall + cMid                    && 4 = IV
			case nValue = 5
				cRoman = cRoman + cMid                             && 5 = V
			case nValue = 6
				cRoman = cRoman + cMid + cSmall                    && 6 = VI
			case nValue = 7
				cRoman = cRoman + cMid + cSmall + cSmall           && 7 = VII
			case nValue = 8
				cRoman = cRoman + cMid + cSmall + cSmall + cSmall  && 8 = VIII
			case nValue = 9
				cRoman = cRoman + cSmall + cBig                    && 9 = IX
		endcase
		
	enddo  && while nCounter < 4
	
RETURN cRoman
*-- EoF: Roman()

*----------

FUNCTION Arabic
*-------------------------------------------------------------------------------
*-- Programmer..: Ken Mayer
*-- Date........: 07/25/1991
*-- Notes.......: This is going to be an attempt to convert a Roman Numeral
*--               to an Arabic ... It parses the roman numeral into an array,
*--               and checks each character ... if the previous character
*--               causes the value to subtract (for example, IX = 9, not 10)
*--               we subtract that value, and then set the previous value
*--               to 0, otherwise we would get some odd values in return.
*--               So far, it works fine.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Arabic(<cRoman>)
*-- Example.....: ?Arabic("XXIV")
*-- Returns.....: Arabic number (from example, 24)
*-- Parameters..: cRoman = character string containing roman numeral to be
*--               converted.
*-------------------------------------------------------------------------------

	parameters cRoman
	private nCounter
	
	cRoman = upper(cRoman)   && convert to all caps in case ...
	
	declare cChar[15],nNum[15] && hopefully no string will be sent that large ...
	
	nMax = 0                && counter for later on ..
	nCounter = 0            && parse cRoman into the array, one character per
	do while nCounter < 15  &&  array element ...
		nCounter = nCounter + 1
		if len(trim(substr(cRoman,nCounter,1))) > 0  && if something's there
			cChar[nCounter] = substr(cRoman,nCounter,1)
			nNum[nCounter] = 0 && init array ...
			nMax = nMax + 1   && set max times through NEXT loop
		else
			exit
		endif
	enddo
	
	*-- Now that it's in an array ... we need to look at it ... and convert
	*-- each character to an arabic number ... this can get really wierd ...
	nCounter = 0
	do while nCounter < nMax
		nCounter = nCounter + 1
		do case
			case cChar[nCounter] = "I"    && 1
				nNum[nCounter] = 1
			case cChar[nCounter] = "V"    && 5
				if nCounter > 1 .and. cChar[nCounter - 1] = "I"
					nNum[nCounter] = 4      && IV = 4
					nNum[nCounter - 1] = 0  && don't add anything later ...
				else
					nNum[nCounter] = 5      && otherwise we have 5
				endif
			case cChar[nCounter] = "X"    && 10
				if nCounter > 1 .and. cChar[nCounter - 1] = "I"
					nNum[nCounter] = 9      && IX = 9
					nNum[nCounter - 1] = 0  && same ... don't add this ...
				else
					nNum[nCounter] = 10     && X = 10
				endif
			case cChar[nCounter] = "L"    && 50
				if nCounter > 1 .and. cChar[nCounter - 1] = "X"
					nNum[nCounter] = 40     && XL = 40
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 50     && L = 50
				endif
			case cChar[nCounter] = "C"    && 100
				if nCounter > 1 .and. cChar[nCounter -1] = "X"
					nNum[nCounter] = 90     && XC = 90
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 100
				endif
			case cChar[nCounter] = "D"    && 500
				if nCounter > 1 .and. cChar[nCounter - 1] = "C"
					nNum[nCounter] = 400    && CD = 400
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 500
				endif
			case cChar[nCounter] = "M"    && 1,000
				if nCounter > 1 .and. cChar[nCounter - 1] = "C"
					nNum[nCounter] = 900    && CM = 900
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 1000
				endif
			case cChar[nCounter] = "W"    && 5,000
				if nCounter > 1 .and. cChar[nCounter - 1] = "M"
					nNum[nCounter] = 4000   && MW = 4000
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 5000
				endif
			case cChar[nCounter] = "Y"    && 10,000
				if nCounter > 1 .and. cChar[nCounter - 1] = "M"
					nNum[nCounter] = 9000   && MY = 9000
					nNum[nCounter - 1] = 0
				else
					nNum[nCounter] = 10000
				endif
			&& that's plenty big ...
		endcase
	enddo

	*-- Add it all together ... it SHOULD give us the proper arabic value
	nArabic = 0
	nCounter = 0
	do while nCounter < nMax
		nCounter = nCounter + 1
		nArabic = nArabic + nNum[nCounter]
	enddo
	
RETURN nArabic
*-- EoF: Arabic()
