**********************************************************
* Procedure: DISKREAD                    REV. 10/26/94
* Written by: Dennis Derringer
*             Derringer Software, Inc.
*             CIS: 71436,121
*
* This routine will create a database of all the files listed
* on the drive. It's a very simple routine that can be
* expanded upon by your own code. Since the FILENAME is a
* separate filed you could list all the directories that
* contain a file or files with common extensions.

* A file named DISKFILE will be created if it does not exist.
* The structure of the file is as follows:
*
*  -FIELD--  TYPE  LENGTH
*  PATHNAME   A       100
*  FILENAME   A        12
*  FILESIZE   N         9
*  FILEDATE   D         8
*  FILETIME   A         8
*  FILEATTR   A         5
*
* Variables that could be changed are:
*
*  CRNTPATH - Indicates the 'top' level directory to start in.
*  WILDCARD - Using anything other than '*.*' will not allow 
*             sub-directories below the starting CRNTPATH to be
*             accessed. This is because the ADIR command will only
*             include directory names if the '*.*' is used.

PRIVATE ;
	crntpath,;
	crntrec,;
	wildcard,;
	pathonly,;
	i

crntpath ="C:\"
wildcard ="*.*"
pathonly = .F.
crntrec  = 0

IF !FILE('DISKFILE.DBF')
	DO createfile
ENDIF

* NOTE: You will need to put your own code in to ZAP the current
* database if you've already run this routine once.

* IMPORTANT: Database should NOT be ordered!
SET ORDER TO

DO WHILE .T.
	WAIT WINDOW NOWAIT crntpath + TRANS(reccount(), "     Records: 99999999")

	* Load the current directory into the TEMP array. Include DIRECTORIES,
	* SYSTEM and HIDDEN files.
	=ADIR(temp,crntpath+wildcard,"DSH")

	*Keep up with the last record in the database that was read
	crntrec = RECNO()

	FOR i = 1  TO ALEN(temp,1)

		* Check to see if only the PATH's are to be stored and
		IF pathonly AND RIGHT(TEMP(i,5),1) != "D"
			LOOP
		ENDIF
		* Don't store if the filename is "." or ".."
		IF RTRIM(TEMP(i,1)) $ ".."
			LOOP
		ENDIF

		* Put more test in at this point to LOOP if something
		* is TRUE or FALSE. You could add files based on SIZE,
		* DATE range or attribute.

		* Add entry to the file
		APPEND BLANK
		REPLACE PATHNAME WITH crntpath
		REPLACE FILENAME WITH TEMP(i,1)
		REPLACE FILESIZE WITH TEMP(i,2)
		REPLACE FILEDATE WITH TEMP(i,3)
		REPLACE FILETIME WITH TEMP(i,4)
		REPLACE FILEATTR WITH TEMP(i,5)

	ENDFOR

	* Go back to the record past the last one that was read before
	GOTO crntrec+1

	* Step through the file until an entry is found that represents
	* a 'DIRECTORY'. If one is found, make the 'crntpath' equal to
	* that PATHNAME and DIRECTORY and then EXIT the DO LOOP so that
	* the filenames in that directory can be added.
	
	DO WHILE .T.
		IF RIGHT(FILEATTR,1) = "D"
			crntpath = RTRIM(PATHNAME) + RTRIM(FILENAME)+"\"
			EXIT
		ENDIF
		SKIP 1
		IF EOF()
			EXIT
		ENDIF
	ENDDO
	IF EOF() OR crntrec = RECCOUNT()
		EXIT
	ENDIF
ENDDO

**********************************
PROCEDURE createfile
**********************************

WAIT WINDOW 'CREATING FILE...'

CREATE DBF DISKFILE ;
	(PATHNAME C(100),;
	 FILENAME C(12),;
	 FILESIZE N(9,0),;
	 FILEDATE D(8),;
	 FILETIME C(8),;
	 FILEATTR C(5))

* Suggested INDEXES:
* ==================
* INDEX ON FILENAME+PATHNAME TAG FILENAME
* INDEX ON PATHNAME+FILENAME TAG PATHNAME
* INDEX ON PATHNAME TAG PATHONLY UNIQUE
