? proper("hot 'n now")
? proper("mcdonald's")
? proper("macdonald's")
? proper("o'brian")
? proper(" 'this one")
? proper("'this one")
? proper("\this one")
? proper("'sticks")
? proper(" 'sticks")
? proper("clinton's")

FUNCTION Proper     && Convert a String to Proper Noun Format
PARAMETERS cBaseStr
*------------------------------------------------------------------------------
*-- Programmer..: Clinton L. Warren (VBCES/CLW)
*-- Date........: 07/10/1991
*-- Notes.......: Returns cBaseStr converted to proper case.  Converts
*--             : "Mc", "Mac", and "'s" as special cases.  Inspired by
*--             : A-T's CCB Proper function.  cBaseStr isn't modified.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 07/10/1991 1.0 - Original version (VBCES/CLW)
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Proper(<cArg>)
*-- Example.....: Proper("mcdonald's") returns "McDonald's"
*-- Returns.....: Propertized string (e.g. "Test String")
*-- Parameters..: cArg = String to be propertized
*------------------------------------------------------------------------------

private nPos, cDeli, cWrkStr

  cWrkStr = lower(cBaseStr) + ' '		&& space necessary for 's processing
  
  nPos = at('mc', cWrkStr)			&& "Mc" handling
  do while nPos # 0
    cWrkStr = stuff(cWrkStr, nPos, 3, upper(substr(cWrkStr, nPos, 1)) ;
                   	+ lower(substr(cWrkStr, nPos + 1, 1)) ;
				    + upper(substr(cWrkStr, nPos + 2, 1)))    
    nPos = at('mc', cWrkStr)
  enddo

  nPos = at('mac', cWrkStr)			&& "Mac" handling
  do while nPos # 0
    cWrkStr = stuff(cWrkStr, nPos, 4, upper(substr(cWrkStr, nPos, 1)) ;
				+ lower(substr(cWrkStr, nPos + 1, 2)) ;
				+ upper(substr(cWrkStr, nPos + 3, 1)))
    nPos = at('mac', cWrkStr)
  enddo

  cWrkStr = stuff(cWrkStr, 1, 1, upper(substr(cWrkStr, 1, 1)))
  nPos = 2
  cDeli = [ -.'"\/`]				&& standard delimiters

  do while nPos <= len(cWrkStr)		&& 'routine' processing
    if substr(cWrkStr,nPos-1,1) $ cDeli
      cWrkStr = stuff(cWrkStr, nPos, 1, upper(substr(cWrkStr,nPos,1)))
    endif
    nPos = nPos + 1
  enddo

  nPos = at("'S ", cWrkStr)			&& 's processing
  do while nPos # 0
    cWrkStr = stuff(cWrkStr, nPos, 2, lower(substr(cWrkStr, nPos, 2)))
    nPos = at('mac', cWrkStr)
  enddo
  
RETURN (cWrkStr)
*-- EOF: Proper(cBaseStr)

