*:*********************************************************************
*:
*: Procedure file: C:\MODEM\PROGRESS.PRG
*:
*:         System: PROGRESS
*:         Author: Taken from ADBUS BBS, Fox Conference
*:    Enhanced by: Richard A. Druckenmiller
*:      Copyright:
*:  Last modified: 02/12/92     13:30
*:
*:  Procs & Fncts: PROGSET()
*:               : PROGUP()
*:               : PROGREL()
*:
*:      Documented 01/09/92 at 20:30               FoxDoc  version 2.10b
*:
*:*********************************************************************
*:  Example on how to call this program:
*:  SET PROC TO PROGRESS
*:  =PROGSET(RECCOUNT(), 'Replacing Names with UPPER(name)')
*:  REPL ALL name WITH UPPER(name) FOR PROGUP('L')
*:  =PROGREL
*:  SET PROC TO
*:
*:*********************************************************************
*!*********************************************************************
*!
*!       Function: PROGSET()
*!
*!*********************************************************************
FUNCTION progset
PARAMETERS maxl,t_itle
PUBLIC b_savetalk,b_savestat,b_savecloc,box_cnt,cttot,step_cnt,c2,maxlsave,start_time
PRIVATE ALL LIKE v_*

*** ENVIRONMENT
*** SAVE TALK'S PREV. SETTING AND SET TO OFF
IF SET('TALK') = 'ON'  
   SET TALK OFF       
   b_savetalk = 'ON'    
ELSE   && TALK is OFF 
   b_savetalk = 'OFF'  
ENDIF
*** SAVE STATUS BAR'S PREV. SETTING AND SET TO OFF
b_savestat = SET('STATUS')
SET STATUS OFF  
*** SAVE CLOCKS PREV. SETTING AND SET TO ON
b_savecloc = SET('CLOCK')
SET CLOCK ON

start_time = SECONDS()
STORE maxl TO cttot, maxlsave

STORE 0 TO step_cnt
IF PARAMETERS()=1
   t_itle='Progress'
ENDIF (parameters()=1)
DEFINE WINDOW progress FROM 5,0 TO 11,78 SHADOW TITLE t_itle 
CLEAR
ACTIVATE WINDOW progress
c1=SCHEME(1,1)
@ 1,1, 3,75  BOX
@2,2 SAY REPL(CHR(177),73) COLOR &c1
cttot=cttot/72
box_cnt=1
RELEASE v_*
RETURN


*!*********************************************************************
*!
*!       Function: PROGUP()
*!
*!*********************************************************************
FUNCTION progup
PARAMETERS ctype

SET TALK OFF       

step_cnt=step_cnt +1
IF (step_cnt/cttot)>box_cnt
   c2=SCHEME(1,9)
   box_cnt=box_cnt+1
*   IF NOT WONTOP('progress')
      ACTIVATE WINDOW progress
*   ENDIF (not wontop('progress'))

   DO guts

ENDIF ((step_cnt/cttot)>BOX_CNT)

*** TIME ELAPSED
@4,2 SAY STOTS(SECONDS()-start_time)
*@ROW(),COL() SAY ' TIME ELAPSED'   

IF PARAMETERS()=1
   DO CASE
   CASE  UPPER(ctype)='C'
      RETURN ''
   CASE  UPPER(ctype)='L'
      RETURN .T.
   CASE UPPER(ctype)='N'
      RETURN 0
   CASE UPPER(ctype)='D'
      RETURN {  /  /  }
   ENDCASE
ENDIF (PARA()=1)
RETURN


*!*********************************************************************
*!
*!       Function: PROGREL()
*!
*!*********************************************************************
FUNCTION progrel
PRIVATE ALL LIKE v_*

SET TALK OFF       

IF NOT WVISIBLE('progress')
   ACTIVATE WINDOW progress
ENDIF (not wvisible('progress'))

DO guts
*** TIME ELAPSED
@4,2 SAY STOTS(SECONDS()-start_time)
@ROW(),COL() SAY ' TIME ELAPSED'   
 
c2=SCHEME(1,9)
@2,2 SAY REPL(CHR(178),73) COLOR &c2
v_savecurs = SET('CURSOR')
SET CURSOR OFF
WAIT WINDOW 'Completed.  Press any key.' 
SET CURSOR &v_savecurs

*** RESET AND CLEANUP ENVIRONMENT
SET CLOCK &b_savecloc
SET STATUS &b_savestat
SET TALK &b_savetalk
RELEASE WINDOW progress
RELEASE box_cnt,cttot,step_cnt,c2,maxlsave,start_time
RELEASE ALL LIKE v_*,b_*

*** END OF PROGRAM
RETURN


*!*********************************************************************
*!
*!       Procedure: GUTS
*!
*!*********************************************************************
*** DISPLAYS ALL INFO TO WINDOW
PROCEDURE guts

*** PERCENT DONE
@0,1 SAY ((step_cnt/maxlsave)*100) PICT '999.99%'
*@ROW(),COL() SAY ' DONE'
*** RATE (PROCESSES/SEC)
@0,20 SAY STR((step_cnt/(SECONDS()-start_time)))
@ROW(),COL() SAY ' PROCESSES/SECOND'
*** PERCENT TO GO
@0,68 SAY ((maxlsave-step_cnt)/maxlsave)*100 PICT '999.99%'
*@ROW(),COL() SAY ' TO GO'
*** THERMOMETER
@2,2 SAY REPL(CHR(178),box_cnt) COLOR &c2
*** ETA
@4,32 SAY STOTS(SECONDS()+((SECONDS()-start_time)/step_cnt) * (maxlsave-step_cnt))
@ROW(),COL() SAY ' ETA'
**** TIME TO GO  
@4,67 SAY STOTS(((SECONDS()-start_time)/step_cnt) * (maxlsave-step_cnt))
*@ROW(),COL() SAY ' TO GO'
RETURN   


*!*********************************************************************
*!
*!       Function: STOTS
*!
*!*********************************************************************
*** TURNS AN AMOUNT OF SECONDS INTO TIME CHARACTER STRING 
FUNCTION stots
PARAMETERS seconds

IF seconds < 0
   RETURN '00:00:00'
ELSE
   RETURN STRTRAN(STR(INT(MOD(seconds/3600,24)),2)+':'+;
                  STR(INT(MOD(seconds/  60,60)),2)+':'+;
                  STR(INT(MOD(seconds,60)),2),' ','0')
ENDIF                  
*: EOF: PROGRESS.PRG
