************************************************************************************************
*
*  Written by:  Gregory A. Green
*               3832 Forest Creek Way
*               Martinez, GA  30907
*
*  Program:     PROFILE.PRG 1994 Gregory A. Green. All rights reserved.
*
*               January 1994, Revision 0
*               Developed for FoxPro for Windows, V2.5a
*
*               The author assumes no liability from the use of these functions; all uses
*               are solely and entirely the responsibility of the end-user of these
*               routines.
*
*  Description: Provides input/output routines for defining a configuration file of user
*               settings or other parameters that are saved to disk between user sessions
*
*  Globals:     None
*
************************************************************************************************
*
*  Example calls to SetProfileString() and GetProfileString()
*
PRIVATE _line1, _line2, okcancel, _test_dlg, file_name, str_section, str_name, str_value

	file_name = "PROFILE.INI"
	str_section = "User Settings"
	str_name = "Text Line One"
	str_value = "This is string text one"
 	num_bytes = SetProfileString(file_name,str_section,str_name,str_value)
	IF num_bytes = 0
		WAIT WINDOW "ERROR -- Not able to write configuration string 1"
		RETURN
	ENDIF

	str_name = "Text Line Two"
	str_value = "This is string text two"
	num_bytes = SetProfileString(file_name,str_section,str_name,str_value)
	IF num_bytes = 0
		WAIT WINDOW "ERROR -- Not able to write configuration string 2"
		RETURN
	ENDIF

	_line1 = GetProfileString(file_name,str_section,"Text Line One")
	IF EMPTY(_line1)
		WAIT WINDOW "ERROR -- Not able to read configuration string 1"
		RETURN
	ENDIF

	_line2 = GetProfileString(file_name,str_section,"Text Line Two")
	IF EMPTY(_line2)
		WAIT WINDOW "ERROR -- Not able to read configuration string 2"
		RETURN
	ENDIF


	IF NOT WEXIST("_test_dlg")
		DEFINE WINDOW _test_dlg AT 0.000, 0.000 SIZE 17.125,90.857 FONT "MS Sans Serif", 10 ;
			NOFLOAT NOCLOSE NOMINIMIZE NONE COLOR RGB(,,,192,192,192)
		MOVE WINDOW _test_dlg CENTER
	ENDIF
	ACTIVATE WINDOW _test_dlg NOSHOW
	CLEAR
	@ 1.313,12.714 SAY "This is a test Screen for Displaying Text" + CHR(13) + ;
		"read from a configuration file" SIZE 2.000,41.455, 0.000 PICTURE "@I" ;
		FONT "Arial", 18 STYLE "BT" COLOR RGB(255,255,255,,,,)
	@ 1.438,13.000 SAY "This is a test Screen for Displaying Text" + CHR(13) + ;
		"read from a configuration file" SIZE 2.000,41.455, 0.000 PICTURE "@I" ;
		FONT "Arial", 18 STYLE "BT" COLOR RGB(0,0,0,,,,)
	@ 1.375,12.857 SAY "This is a test Screen for Displaying Text" + CHR(13) + ;
		"read from a configuration file" SIZE 2.000,41.455, 0.000 PICTURE "@I" ;
		FONT "Arial", 18 STYLE "BT" COLOR RGB(0,0,128,,,,)
	@ 7.063,14.286 SAY "First Line of Text:" FONT "MS Sans Serif", 12 STYLE "BT"
	@ 10.375,14.286 SAY "Second Line of Text:" FONT "MS Sans Serif", 12 STYLE "BT"
	@ 12.875,30.857 GET okcancel PICTURE "@*HT OK;Cancel" SIZE 1.625,12.500,0.500 ;
		DEFAULT 1 FONT "MS Sans Serif", 8 STYLE "B"
	@ 7.000,40.286 SAY _line1 SIZE 1.000,32.000 FONT "MS Sans Serif", 12 STYLE "B"
	@ 10.375,40.286 SAY _line2 SIZE 1.000,32.000 FONT "MS Sans Serif", 12 STYLE "B"
	@ 15.500,0.000 TO 17.125,90.857 PATTERN 1 PEN 1, 8 COLOR RGB(128,128,128,128,128,128)
	@ 0.000,0.000 TO 15.500,7.000 PATTERN 1 PEN 1, 8 COLOR RGB(0,128,128,0,128,128)
	SHOW WINDOW _test_dlg
	READ CYCLE
	RELEASE WINDOW _test_dlg
RETURN


************************************************************************************************
*
*  Routine for getting a string from user configuration file
*
*  Return Value:      string value or null if not found
*
*  Parameters:        file_name    the name of the configuration file; full path optional,
*                                  will use the search path as specified by SET PATH command
*                                  if not located first in the current directory
*                     str_section  the section in the configuration file to retrieve the
*                                  string from
*                     str_name     the name of the string text to retrieve
*
FUNCTION GetProfileString
PARAMETER file_name, str_section, str_name
	PRIVATE fhandle, str_buffer, str_value, ndx

	IF FILE(file_name)                            && Check if configuration file exists
		fhandle = FOPEN(file_name)                 && Open for read only
		=FSEEK(fhandle,0,0)                        && Goto beginning of file
		DO WHILE NOT FEOF(fhandle)                 && Loop to find string header section
			str_buffer = FGETS(fhandle)             && Get string of text from file
			IF ATC(str_section,str_buffer) > 0      && Test if section header found
				DO WHILE NOT FEOF(fhandle)           && Loop to find string text
					str_buffer = FGETS(fhandle)       && Get string of text from file
					IF ATC(str_name,str_buffer) > 0   && Test if string text found
						ndx = ATC("=",str_buffer) + 1  && Get starting position of return string
						str_value = SUBSTR(str_buffer,ndx)
						EXIT
					ENDIF
					str_value = SPACE(1)              && String not found, set return to null
					IF ATC("[",str_buffer) > 0        && Test if next section encountered
						EXIT                           && Next section, exit loop
					ENDIF
				ENDDO
				EXIT
			ENDIF
			str_value = SPACE(1)                    && String not found, set return to null
		ENDDO
		=FCLOSE(fhandle)                           && Close file
	ELSE
		str_value = SPACE(1)                       && File not found, set return to null
	ENDIF
RETURN str_value


************************************************************************************************
*
*  Routine for setting a string in a user configuration file
*
*  Return Value:      number of bytes written to file, or 0 if cannot write to file (Note: the
*                     value returned will be the number of bytes last successfully written and
*                     not necessarily the number of bytes for the string passed to write;
*                     therefore, success is determined if number returned is greater than zero.)
*
*  Parameters:        file_name    the name of the configuration file; full path optional,
*                                  will use the search path as specified by SET PATH command
*                                  if not located first in the current directory
*                     str_section  the section in the configuration file to write the
*                                  string under
*                     str_name     the name of the string text to write
*                     str_value    the value of the string text to write (Note: the value
*                                  does not have to be a string -- can be passed as a string,
*                                  numeric, or logical.)
*
*
FUNCTION SetProfileString
PARAMETER file_name, str_section, str_name, str_value
	PRIVATE fhandle, str_buffer, thandle, temp_name, num_bytes, write_section, write_value

	IF FILE(file_name)
		write_section = .F.                                   && Set not written flag (section)
		write_value = .F.                                     && Set not written flag (value)
		fhandle = FOPEN(file_name,12)                         && Open conf file for read/write
		temp_name = sys(2003) + "\temp.ini"                   && Set temp file name for conf file
		thandle = FCREATE(temp_name)                          && Create temporary conf file
		DO WHILE NOT FEOF(fhandle)                            && Loop to find string header section
			str_buffer = FGETS(fhandle)                        && Get line of text from conf file
			num_bytes = FPUTS(thandle,str_buffer)              && Write out text name and value
			IF ATC(str_section,str_buffer) > 0                 && Test if section header found
				write_section = .T.                             && Indicate section header written
				DO WHILE NOT FEOF(fhandle)                      && Loop to find string text
					str_buffer = FGETS(fhandle)                  && Get string of text from file
					IF ATC(str_name,str_buffer) > 0              && Test if string text found
						num_bytes = put_str_value(thandle,str_name,str_value)
						write_value = .T.                         && Indicate conf value written
						EXIT
					ELSE
						IF ATC("[",str_buffer) = 1                && Check for next section
							num_bytes = put_str_value(thandle,str_name,str_value)
							write_value = .T.                      && Indicate conf value written
							num_bytes=FPUTS(thandle,str_buffer)    && Write out text name and value
							EXIT
						ELSE
							num_bytes=FPUTS(thandle,str_buffer)    && Write out text name and value
						ENDIF
					ENDIF
				ENDDO
				IF !write_value                                 && Check if conf value written
					num_bytes = put_str_value(thandle,str_name,str_value)
					write_value = .T.                            && Indicate conf value written
				ENDIF
				IF num_bytes > 0                                && Check if user text written
					DO WHILE NOT FEOF(fhandle)                   && Loop to write remaining file
						str_buffer = FGETS(fhandle)               && Get text from conf file
						num_bytes = FPUTS(thandle,str_buffer)     && Write text to temp file
					ENDDO
				ENDIF
				EXIT                                            && Exit loop
			ENDIF
		ENDDO
		IF !write_section                                     && Check if sect/conf value written
			str_buffer = "[" + str_section + "]"
			num_bytes=FPUTS(thandle,str_buffer)                && Write out section header text
			IF num_bytes > 0
				num_bytes = put_str_value(thandle,str_name,str_value)
			ENDIF
		ENDIF
		=FCLOSE(fhandle)                                      && Close file
		=FCLOSE(thandle)                                      && Close file
		IF num_bytes > 0                                      && Check if user text written
			ndx = ATC(".",file_name)                           && Get file name w/o extension
			bak_name = LEFT(file_name,ndx) + "BAK"             && Add extension to bak name
			IF FILE(bak_name)                                  && Check if backup exists
				DELETE FILE (bak_name)                          && Delete if exists
			ENDIF
			RENAME (file_name) TO (bak_name)
			RENAME (temp_name) TO (file_name)
		ELSE
			DELETE FILE temp_name                              && Not written, del tmp & return
		ENDIF
	ELSE
		fhandle = FCREATE(file_name)                          && File does not exist, create
		IF fhandle > -1                                       && Check for file creation error
			str_buffer = "[" + str_section + "]"
			num_bytes=FPUTS(fhandle,str_buffer)                && Write out section header text
			IF num_bytes > 0
				num_bytes = put_str_value(fhandle,str_name,str_value)
				=FCLOSE(fhandle)                                && Close file
			ENDIF
		ELSE
			num_bytes = 0
		ENDIF
	ENDIF
RETURN num_bytes


************************************************************************************************
*
*  Routine for writing the user string value to the configuration file based on data type
*
FUNCTION put_str_value
PARAMETER handle, str_name, str_value
	PRIVATE str_buffer

	DO CASE                                                 && Determine data type to write
		CASE TYPE('str_value') = "C"                         && User string is of char type
			str_buffer = str_name + "=" + str_value
			num_bytes=FPUTS(handle,str_buffer)                && Write out text name and value
		CASE TYPE('str_value') = "N"                         && User string is numeric
			str_buffer = str_name + "=" + STR(str_value)
			num_bytes=FPUTS(handle,str_buffer)                && Write out text name and value
		CASE TYPE('str_value') = "D"                         && User string is date
			str_buffer = str_name + "=" + DTOC(str_value)
			num_bytes=FPUTS(handle,str_buffer)                && Write out text name and value
		CASE TYPE('str_value') = "L"                         && User string is logical
			IF str_value
				str_buffer = str_name + "=TRUE"
			ELSE
				str_buffer = str_name + "=FALSE"
			ENDIF
			num_bytes=FPUTS(handle,str_buffer)                && Write out text name and value
		OTHERWISE                                            && Data type unknown
			num_bytes = 0
	ENDCASE
RETURN num_bytes

