* Program.: PRINTIT.PRG
* Author..: Barry W. Grant, CLU  (Source ID: TCN158)
* Date....: 07/05/85
* Notes...: My version of a utility program to print ASCII text files.
*           Two database (.DBF) files must be CREATED.  Each .DBF file
*           structure consists of one CHARACTER field:
*
*               .DBF file          Field Name       Field Length
*
*               PRINTLST.DBF       file_name            40
*               PRINTFIL.DBF       m_line               80
*
*           Memory Variables Used:
*
*               doit     - logical for a "DO WHILE" loop
*               ans      - length = 1, for user Y/N responses
*               page_no  - numeric for the page number
*               f_name   - length = 8, file name
*               file_ext - length = 3, file extension
*                             (.COM, .EXE, .DBF and .OBJ extensions are
*                              "trapped" in Line 89.)
*               m_path   - length = 36, complete DOS path search criteria
*                             Example:  C:\SUBDIR1\SUBDIR2\
*                             Leave blank if file(s) to be printed are
*                             in same location as this program.
*               p_file   - length = 12, complete DOS file name (including
*                             path criteria when applicable)
*
*           DOS wildcard characters ("*", "?") may be used in the file name
*           and file extension.  All matching files will be printed.

CLEAR
SET TALK OFF
SET CONFIRM ON
SET SAFETY OFF
SET BELL OFF
SET COLOR TO  7/0,U
SELECT 1
USE printlst
SELECT 2
USE printfil
STORE .T. TO doit
DO WHILE doit
   CLEAR
   f_name = "        "
   m_path = SPACE(36)
   file_ext = "   "
   p_file =  "            "
   ans = " "
   page_no = 1
   @  8,5 SAY "Enter Drive and Path (if applicable):"
   @  8,43 GET m_path PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
   @ 10,5 SAY "Enter the name of the ASCII text file to be printed: "
   @ 10,58 GET f_name PICTURE "!!!!!!!!"
   @ 12,5 SAY "                           Enter the file extension: "
   @ 12,58 GET file_ext PICTURE "!!!"
   READ
   CLEAR
   IF f_name = "        "
      @  8,5  SAY "A FILE NAME (or wildcard character) MUST BE ENTERED!"
      @ 10,5  SAY "Select another file? Y/N: "
      @ 10,33 GET ans PICTURE "!"
      READ
      IF ans = "Y"
         LOOP
      ELSE
         EXIT
      ENDIF
   ENDIF
   @ 10,27 SAY "SEARCHING DISK FOR FILE(s)"
   STORE TRIM(m_path)+TRIM(f_name)+"."+TRIM(file_ext) TO p_file
   * next command redirects the DOS directory to a temporary .TXT file
   DIR &p_file > tprint.txt
   SELECT 1
   IF LASTREC() <> 0
      ZAP
   ENDIF
   APPEND FROM tprint SDF
   GO TOP
   DO WHILE SUBSTR(file_name,1,1) = " "
      SKIP
   ENDDO
   IF SUBSTR(file_name,1,14) <> "File not found"
      STORE .T. TO p_loop
      DO WHILE p_loop
         STORE SUBSTR(file_name,1,8) TO f_name
         STORE SUBSTR(file_name,10,3) TO file_ext
         STORE TRIM(m_path)+TRIM(f_name)+"."+TRIM(file_ext) TO p_file
         IF file_ext="COM" .OR. file_ext="EXE" .OR. file_ext="OBJ" .OR. ;
            file_ext="DBF"
            CLEAR
            @ 10,20 SAY "&p_file IS NOT AN ASCII FILE!"
         ELSE
            SELECT 2
            IF LASTREC() <> 0
               ZAP
            ENDIF
            CLEAR
            @ 10,26 SAY "READING FILE TO BE PRINTED"
            APPEND FROM &p_file SDF
            STORE 1 TO line_cnt, page_no
            CLEAR
            @ 10,20 SAY "PRINTING FILE: &p_file"
            SET DEVICE TO PRINT
            @ 3,5 SAY p_file
            @ 3,40 SAY DATE()
            @ 3,70 SAY "Page "+STR(page_no,3,0)
            STORE 5 TO line_cnt
            GO TOP
            DO WHILE .NOT. EOF()
               IF line_cnt > 60
                  EJECT
                  STORE page_no + 1 TO page_no
                  @ 3,5  SAY p_file
                  @ 3,40 SAY DATE()
                  @ 3,70 SAY "Page "+STR(page_no,3,0)
                  STORE 5 TO line_cnt
               ENDIF
               @ line_cnt,0 SAY m_line
               STORE line_cnt + 1 TO line_cnt
               SKIP
            ENDDO
            EJECT
            SET DEVICE TO SCREEN
            CLEAR
            SELECT 1
         ENDIF
         SKIP
         IF EOF() .OR. SUBSTR(file_name,1,1) = " "
            STORE .F. TO p_loop
         ELSE
            LOOP
         ENDIF
      ENDDO
      CLEAR
      @ 10,5  SAY "Print another file? Y/N: "
      @ 10,32 GET ans PICTURE "!"
      READ
      IF ans = "Y"
         ZAP
         LOOP
      ENDIF
   ELSE
      CLEAR
      @  8,5  SAY "FILE DOES NOT EXIST!"
      @ 10,5  SAY "Select another file? Y/N: "
      @ 10,32 GET ans PICTURE "!"
      READ
      IF ans = "Y"
         LOOP
      ENDIF
   ENDIF
   STORE .F. TO doit
ENDDO
IF FILE("tprint.txt")
   ERASE tprint.txt
ENDIF
SELECT 1
ZAP
SELECT 2
ZAP
CLEAR ALL
QUIT

* End of file:  PRINTIT.PRG
*******************************************************
