*:*****************************************************************************
*:
*: Procedure file: C:\DEV\COMMON\NUMWORDS.PRG
*:
*:         System: The Deacon/library routine
*:         Author: Victor M. Font Jr.
*:      Copyright (c) 1993, Victor M. Font Jr.
*:  Last modified: 06/15/93     18:39
*:
*:  Procs & Fncts: BLDCENTS()
*:               : BLDSTR()
*:               : SAYINTS()
*:               : SAYTEENS()
*:               : SAYTENS()
*:
*:      Documented 06/15/93 at 18:45               FoxDoc  version 2.10f
*:*****************************************************************************
*/ Pass in the amount you want converted to words.
*/ this function can handle up to 999,999,999,999.99
*/ if you're writing checks for amounts this large or larger,
*/ then give me a call, you can afford to have me work for you
*/ I suggest displaying or printing amounts generated with this function
*/ in the following fashion:
*/ var = padc(" "+numwords(amount)+" ",EXP{n},"*")
*/ @ x,y say var

PARAMETERS l_amount
PRIVATE ALL LIKE l_*			&& declare all of your local variables private

*/ foxpro can only handle numbers with a 16 digit precision
*/ soooo, if the number's too large, generate an error
IF l_amount > 9999999999999.99
    RETURN "Sorry, number too large"			&& insert your own error trap routine here
ENDIF

*/ convert the number to a string
l_amount = ALLTRIM(STR(l_amount,16,2))

*/ get the length of the string to dimension an array
l_count = LEN(l_amount)

*/ create an array and fill each member with a number from the amount
DIMENSION l_str_arry[l_count]
FOR l_x = 1 TO l_count
    l_str_arry[l_x] = SUBS(l_amount,l_x,1)
ENDFOR

*/ build your "numbers converted to words" string
l_centstr = bldcents()
l_hundstr = IIF(l_count>=4,bldstr(1),"")
l_thoustr = IIF(l_count>=7,bldstr(2),"")
l_millstr = IIF(l_count>=10,bldstr(3),"")
l_billstr = IIF(l_count>=13,bldstr(4),"")
l_trilstr = IIF(l_count>=16,bldstr(5),"")

*/  return the word string
RETURN l_trilstr+l_billstr+l_millstr+l_thoustr+l_hundstr+l_centstr


*/ build the cents string to display at the end of the word string
*!*****************************************************************************
*!
*!       Function: BLDCENTS()
*!
*!*****************************************************************************
FUNCTION bldcents
DO CASE
CASE l_str_arry[l_count-1]=="0" AND l_str_arry[l_count]=="0" 	&& if there are no cents, return null
    l_saystr = ""
CASE l_str_arry[l_count-1]=="0" AND l_str_arry[l_count]<>"0"	&& if less than 10 cents, return "& x/100"
    l_saystr = " & " + l_str_arry[l_count]+"/100"
OTHERWISE
    l_saystr = " & " + l_str_arry[l_count-1]+l_str_arry[l_count]+"/100"	&& return "& xx/100"
ENDCASE
*/ now return the string
RETURN l_saystr


*/ this function is used to build the actual word strings
*/ the l_pass parameter is used determine whether we are building hundreds,
*/ thousands, millions, or billions.  the l_factor variable is calculated
*/ based on the value of l_pass.  l_factor is used to point to the proper
*/ character array position.

*!*****************************************************************************
*!
*!       Function: BLDSTR()
*!
*!*****************************************************************************
FUNCTION bldstr
PARAMETER l_pass					&& which string are we building? hunds, thous, mills, or bills
l_factor = (l_pass-1)*3				&& offset for character array position
DO CASE								&& remember - l_count is the length of the number string
CASE l_count = (4+l_factor)			&& only one number to format
    l_saystr = IIF(l_str_arry[l_count-(3+l_factor)]=="0","",sayints(l_str_arry[l_count-(3+l_factor)]))
CASE l_count = (5+l_factor)			&& two numbers to format
    DO CASE
    CASE l_str_arry[l_count-(3+l_factor)]<>"0" AND l_str_arry[l_count-(4+l_factor)] == "1"		&& number is in the teens
        l_saystr = sayteens(l_str_arry[l_count-(3+l_factor)])
    OTHERWISE																					&& any other two digit number
        l_saystr = saytens(l_str_arry[l_count-(4+l_factor)])
        l_saystr = IIF(l_str_arry[l_count-(3+l_factor)]=="0",l_saystr,l_saystr+"-"+LOWER(sayints(l_str_arry[l_count-(3+l_factor)])))
    ENDCASE
CASE l_count >= (6+l_factor)		&& 3 digit number to format
    DO CASE
    CASE l_str_arry[l_count-(3+l_factor)]<>"0" AND l_str_arry[l_count-(4+l_factor)] == "1" AND l_str_arry[l_count-(5+l_factor)] <> "0"			&& number includes a teen figure such as one hundred eleven
        l_saystr = sayints(l_str_arry[l_count-(5+l_factor)])+" Hundred "+sayteens(l_str_arry[l_count-(3+l_factor)])
    CASE l_str_arry[l_count-(3+l_factor)]=="0" AND l_str_arry[l_count-(4+l_factor)] == "0" AND l_str_arry[l_count-(5+l_factor)] <> "0"			&& even hundred number like 100, 200, etc.
        l_saystr = sayints(l_str_arry[l_count-(5+l_factor)])+" Hundred"
    CASE l_str_arry[l_count-(3+l_factor)]<>"0" AND l_str_arry[l_count-(4+l_factor)] == "0" AND l_str_arry[l_count-(5+l_factor)] <> "0" 			&& number with 0 in the middle, 101, 202, 303, etc.
        l_saystr = sayints(l_str_arry[l_count-(5+l_factor)])+" Hundred "+sayints(l_str_arry[l_count-(3+l_factor)])
    CASE l_str_arry[l_count-(5+l_factor)]=="0" AND l_str_arry[l_count-(4+l_factor)] == "0" AND l_str_arry[l_count-(3+l_factor)] <> "0"			&& double-oh number, 007
        l_saystr = sayints(l_str_arry[l_count-(3+l_factor)])
    CASE l_str_arry[l_count-(5+l_factor)]=="0" AND l_str_arry[l_count-(4+l_factor)] <> "0" AND l_str_arry[l_count-(3+l_factor)] <> "0"			&& zero, digit, digit
        l_saystr = saytens(l_str_arry[l_count-(4+l_factor)])
        l_saystr = IIF(l_str_arry[l_count-(3+l_factor)]=="0",l_saystr,l_saystr+"-"+LOWER(sayints(l_str_arry[l_count-(3+l_factor)])))
    OTHERWISE																																	&& any other combination
        l_saystr = sayints(l_str_arry[l_count-(5+l_factor)])+" Hundred "
        l_saystr = IIF(ALLTRIM(l_saystr)<>"Hundred",l_saystr,"") + saytens(l_str_arry[l_count-(4+l_factor)])
        l_saystr = IIF(l_str_arry[l_count-(3+l_factor)]=="0",l_saystr,l_saystr+"-"+LOWER(sayints(l_str_arry[l_count-(3+l_factor)])))
    ENDCASE
OTHERWISE
    l_saystr = ""				&& just in case the numbers don't fit any of the above profiles
ENDCASE
*/ now pass a properly formatted string
RETURN IIF(ALLTRIM(l_saystr)<>"Hundred",l_saystr,"") + IIF(l_pass=2 AND ""<>ALLTRIM(l_saystr)," Thousand ",IIF(l_pass=3 AND ""<>ALLTRIM(l_saystr)," Million ",IIF(l_pass=4 AND ""<>ALLTRIM(l_saystr)," Billion ",IIF(l_pass=5," Trillion ",""))))


*/ function to convert numbers from 1 to 9
*!*****************************************************************************
*!
*!       Function: SAYINTS()
*!
*!*****************************************************************************
FUNCTION sayints
PARAMETER l_ints
DO CASE
CASE l_ints = "0"		&& if you include 0 instead of otherwise, this executes a little faster
    l_intstr = ""
CASE l_ints = "1"
    l_intstr = "One"
CASE l_ints = "2"
    l_intstr = "Two"
CASE l_ints = "3"
    l_intstr = "Three"
CASE l_ints = "4"
    l_intstr = "Four"
CASE l_ints = "5"
    l_intstr = "Five"
CASE l_ints = "6"
    l_intstr = "Six"
CASE l_ints = "7"
    l_intstr = "Seven"
CASE l_ints = "8"
    l_intstr = "Eight"
CASE l_ints = "9"
    l_intstr = "Nine"
ENDCASE
RETURN l_intstr


*/ function to convert numbers from 11 to 19
*!*****************************************************************************
*!
*!       Function: SAYTEENS()
*!
*!*****************************************************************************
FUNCTION sayteens
PARAMETER l_teens
DO CASE
CASE l_teens = "0"		&& if you include 0 instead of otherwise, this executes a little faster
    l_teenstr = ""
CASE l_teens = "1"
    l_teenstr = "Eleven"
CASE l_teens = "2"
    l_teenstr = "Twelve"
CASE l_teens = "3"
    l_teenstr = "Thirteen"
CASE l_teens = "4"
    l_teenstr = "Fourteen"
CASE l_teens = "5"
    l_teenstr = "Fifteen"
CASE l_teens = "6"
    l_teenstr = "Sixteen"
CASE l_teens = "7"
    l_teenstr = "Seventeen"
CASE l_teens = "8"
    l_teenstr = "Eighteen"
CASE l_teens = "9"
    l_teenstr = "Nineteen"
ENDCASE
RETURN l_teenstr


*/ function to convert numbers from 10 to 90 by tens
*!*****************************************************************************
*!
*!       Function: SAYTENS()
*!
*!*****************************************************************************
FUNCTION saytens
PARAMETER l_tens
DO CASE
CASE l_tens = "0"		&& if you include 0 instead of otherwise, this executes a little faster
    l_tenstr = ""
CASE l_tens = "1"
    l_tenstr = "Ten"
CASE l_tens = "2"
    l_tenstr = "Twenty"
CASE l_tens = "3"
    l_tenstr = "Thirty"
CASE l_tens = "4"
    l_tenstr = "Forty"
CASE l_tens = "5"
    l_tenstr = "Fifty"
CASE l_tens = "6"
    l_tenstr = "Sixty"
CASE l_tens = "7"
    l_tenstr = "Seventy"
CASE l_tens = "8"
    l_tenstr = "Eighty"
CASE l_tens = "9"
    l_tenstr = "Ninety"
ENDCASE
RETURN l_tenstr
*: EOF: NUMWORDS.PRG
