* 
* Some network utils - save, append, delete
* Written by Brent Douglas
*
*
***************************************************
* SMARTSAVE - routine to do incremental save 
*			allow users to update same record 
*			without too much hassle.  will save
*			only your changes AND refresh your
*			memvars to reflect changes made by
*			other users.
*

*
* this code is placed in screen setup section
* 
* "safety" is used in SMARTSAVE to verify changes
*
ok=.T.
DIMENSION SAFETY(1)
STORE '' TO SAFETY
*

SCATTER MEMVAR MEMO
SCATTER TO SAFETY

****************************************************
*
* 
*
* edits here...
*
*
*
* USED in a save button...
* 

DO smartsave

*
* refresh screen to show any possible changes
*
show gets

**********************************************
*
* on leaving record, check to see if
* you have not saved changes...
*

IF changemade()
	ok=CONFIRM("changes not saved")
ENDIF

IF ok
	RETURN
ENDIF

***************************************************
PROCEDURE smartsave
*
* written to make a gather only write back YOUR changes.
* refreshes from record (will pick up others changes)
*
* assume array named safety
*
PRIVATE x,VAR,cvar,fname,cntents
*
FOR x=1 TO ALEN(SAFETY)
	VAR='m.'+FIELD(x)
	cvar=&var

	IF cvar <> SAFETY(x)
		*
		* you made a change
		* ---
		SAFETY(x)=cvar
		*
	ELSE
		**************************************
		*
		* refresh element from database.
		* - move off record to try to get update from net...
		*
		**************************************
		*
		rhold=RECNO()
		IF !EOF()
			SKIP
		ELSE
			IF !BOF()
				SKIP -1
			ENDIF
		ENDIF
		*****************
		IF rhold <> 0
			GOTO rhold
		ENDIF
		*****************
		fname=FIELD(x)
		cntents=&fname
		SAFETY(x)=cntents
		*
	ENDIF
NEXT

IF RLOCK()
	GATHER FROM SAFETY MEMO
	UNLOCK
	*
	FLUSH
	*
	* reset vars to what the rec really contains.
	*
	SCATTER TO SAFETY MEMO
	SCATTER MEMVAR MEMO
ENDIF
*
RETURN
***************************************************
***************************************************
Function changemade
private chngd
chngd=.F.
*
* checks all  memvars against safety array to verify
* YOUR changes have been saved.
*
* assume array named safety
*
PRIVATE x,VAR,cvar,fname,cntents
*
FOR x=1 TO ALEN(SAFETY)
	VAR='m.'+FIELD(x)
	cvar=&var

	IF cvar <> SAFETY(x)
		*
		* you made a change
		* ---
		chngd =.t.
		*
	ENDIF
NEXT

RETURN chngd




*
******************************************************************
*
PROCEDURE netappend

*
* recycle deleted records (if available)
* before adding recs
*
* assumes indexed so that blanks go to top.
* -------
*

GO TOP
IF DELETED()
	IF RLOCK()
		RECALL
		UNLOCK
	ENDIF
ELSE
	APPEND BLANK
ENDIF

RETURN

*
******************************************************************
*
PROCEDURE netdelete

SCATTER MEMVAR MEMO BLANK
SCATTER MEMO TO SAFETY
IF RLOCK()
	DELETE
	GATHER MEMVAR MEMO
	UNLOCK
ENDIF

RETURN

