***********************************************************************
* File Name......: $Workfile:   LOADSQL.PRG  $
* Revision Level.: $Revision:   1.0  $
* Last Update....: $Date:    07 Nov 1991 14:45:42  $
* ----------------------------------------------------------------------
* Language.......: dBASE IV 1.1 Server Edition, Microsoft SQL Server
* Author.........: Kevin J. Weaver, PC Solutions
*                  Gatehouse, Station Square
*                  Pittsburgh, PA  15219
* BBS Userid.....: KWEAVER
* Notice.........: Copyright 1991, PC Solutions.
*                  May be used for non-commercial purposes only.
* ----------------------------------------------------------------------
* Synopsis.......: This utility loads a text file into SQL Server using
*                  the SENDSQL command.  It's purpose is to allow
*                  dBASE IV S/E to load text files ala ISQL.
*
*                  This utility is useful for loading and maintaining
*                  stored procedures, triggers, etc. without having
*                  to leave the dBASE environment.  The same ASCII 
*                  text files which can be loaded from ISQL can be
*                  loaded from dBASE with LoadSQL.
*
*                  Include the ISQL "GO" command in input files to
*                  force the server to execute intervening commands.
*                  A "GO" is assumed at the end of the input file.
* ----------------------------------------------------------------------
* Parameters.....: expC - File Name (may include path)
* Returns........: none
* ----------------------------------------------------------------------
* Notes..........: 
*                  Requires SQL_LIB.PRS procedure file.
*                  Requires SQLINE.DBF = LINE char(254)
*                  Will disable any ON ERROR handler in effect when called.
*
*                  Assumes user is already logged into the server and 
*                  the appropriate database is started.
*
* History........: 
* 11-07-91 kjw   : Created.
************************************************************************
* procedure LoadSQL
parameters cInFile

private lProcess, cSavCrs, cSavTalk, cSavSafe, cSavProc

if set("talk") = "ON"
   set talk off
   cSavTalk = "ON"
else
   cSavTalk = "OFF"
endif

*-- Setup environment
cSavProc = set("procedure")
set procedure to SQL_LIB

cSavCrs = set("cursor")
set cursor off
cSavSafe = set("safety")
set safety off

lProcess   = file(cInFile)             && Test for existance of input file

if lProcess
   use SQLINE in select() exclusive
   select SQLINE
   zap
   append from (cInFile) type sdf
   go top

   on error do SQLErrHand with message()

   *-- Process the file
   ?
   do CancelSQL

   do while .not. eof()
      if upper(ltrim(rtrim(LINE))) = "GO"
         do ExecSQL
      else
         do SendLine with rtrim(LINE)
      endif
      skip
   enddo
   do ExecSQL

   on error                           && Disable error handler
   zap
   use in SQLINE
else
   ? "LoadSQL: Input file not found"
endif

*-- Reset environment
set procedure to (cSavProc)
set safety &cSavSafe
set talk &cSavTalk
set cursor &cSavCrs
return

*-- EOF: LoadSQL.prg
